******************* Code origin and group orientation in GTD *************************
* Generated for the paper:
* Kis-Katos, K., Liebert, H., and Schulze, G.G., 2014, On the heterogeneity of terror, European Economic Review, 68, 116-136.
* Please cite this paper if you are using the do-file.

* This is a coding file that has been originally run in Stata 12 to define group identities based on 
* GTD (gtd_v2_10.dta)
* The program "ident" encodes 6 new variables on originating country and group identity
* The output can be then used to generate country-year-event or country-year-fatalities data.

cap log close coding
log using "$progdir/code_origin.log", replace name(coding)

// Define coding variables:
gen origin = .
gen pol_iden = .
gen sepeth_iden = .
gen rel_iden = .
gen major_id = .
gen identified = .
lab var origin      "Originating country of terror, denoted by original GTD code"
lab var pol_iden    "Political identity of group: 0-none, 1-left, 2-right, 3-antileft, 4-other leftist type"
lab var sepeth_iden "Ethnic-separatist identity of group: 0-none, 1-ethnic/separatist, 2-anti-separatist"
lab var rel_iden    "Religious identity of group: 0-none, 1-Islamist, 2-Christian, 3-Hindu, 4-Jewish, 5-other"
lab var major_id    "Primary ideology of group: 0-none, 1-political, 2-ethnic/sep., 3-religious, 4-green/human/animal rights, 5-anti-war"
lab var identified  "Group with clear organizational identity: 0-no, 1-yes, 2-bandits, 3-imputed identity"
* In our paper we use only groups with identified==1

// Define Coding routines:
* In most cases ident is used, further versions are applied in few selected cases
capture program drop ident	// coding routine takes 7 consecutive arguments
program define ident
    replace origin = `1'       if gname=="`7'"
    replace pol_iden = `2'     if gname=="`7'"
    replace sepeth_iden = `3'  if gname=="`7'"
    replace rel_iden = `4'     if gname=="`7'"
    replace major_id = `5'	 if gname=="`7'"
    replace identified = `6'   if gname=="`7'"
end

* ident1 differentiates between groups of the same name by location of attack
capture program drop ident1	
program define ident1         // coding routine takes 8 consecutive arguments
    replace origin = `1'       if gname=="`7'" & country==`8' // differentiate by location of attack
    replace pol_iden = `2'     if gname=="`7'" & country==`8' 
    replace sepeth_iden = `3'  if gname=="`7'" & country==`8'
    replace rel_iden = `4'     if gname=="`7'" & country==`8'
    replace major_id = `5'     if gname=="`7'" & country==`8'	
    replace identified = `6'   if gname=="`7'" & country==`8'	
end

* ident2 differentiates between groups of the same name by group subname
capture program drop ident2	
program define ident2         // coding routine takes 8 consecutive arguments
    replace origin = `1'       if gname=="`7'" & gsubname=="`8'" // differentiate by group subname
    replace pol_iden = `2'     if gname=="`7'" & gsubname=="`8'" 
    replace sepeth_iden = `3'  if gname=="`7'" & gsubname=="`8'"
    replace rel_iden = `4'     if gname=="`7'" & gsubname=="`8'"
    replace major_id = `5'     if gname=="`7'" & gsubname=="`8'"	
    replace identified = `6'   if gname=="`7'" & gsubname=="`8'"	
end

* ident3 differentiates between groups of the same name by the year of attack
capture program drop ident3	
program define ident3         // coding routine takes 8 consecutive arguments
    replace origin = `1'       if gname=="`7'" & iyear>=`8' // differentiate by year of attack
    replace pol_iden = `2'     if gname=="`7'" & iyear>=`8'
    replace sepeth_iden = `3'  if gname=="`7'" & iyear>=`8'
    replace rel_iden = `4'     if gname=="`7'" & iyear>=`8'
    replace major_id = `5'     if gname=="`7'" & iyear>=`8'	
    replace identified = `6'   if gname=="`7'" & iyear>=`8'	
end


local cc "country" // country is the name of the location variable in GTD, 
// when `cc' is used in the following routine, origin is set equal to location

// Generate group totals:
bysort gname: gen group_total = _N // total number of observations per group

* Groups ordered by number of incidents by 2008
ident 159  1 0 0 1 1 "Shining Path (SL)"                                   // Peru
ident 61   1 0 0 1 1 "Farabundo Marti National Liberation Front (FMLN)"    // El Salvador
ident 233  0 1 2 2 1 "Irish Republican Army (IRA)"				     // to Northern Ireland
ident 185  1 1 0 2 1 "Basque Fatherland and Freedom (ETA)"                 // nationalist left
ident 45   1 0 0 1 1 "Revolutionary Armed Forces of Colombia (FARC)"		// today aimed at rent extraction
ident 45   1 0 2 1 1 "National Liberation Army of Colombia (ELN)"		// liberation theology
ident 186  0 1 0 2 1 "Liberation Tigers of Tamil Eelam (LTTE)"  	          // not classified as left-wing
ident 209  1 1 0 2 1 "Kurdistan Workers' Party (PKK)" 			          // to Turkey
ident 155  0 1 0 2 0 "Palestinians"					               // to Palestine, separatist, not clear whether religious
ident 160  1 0 0 1 1 "New People's Army (NPA)"                             // Philippines
ident 145  3 0 0 1 1 "Nicaraguan Democratic Force (FDN)"                   // guerilla, anti-communist!
ident 43   1 0 0 1 1 "Manuel Rodriguez Patriotic Front (FPMR)"             // Chile
ident 92   0 1 5 2 0 "Sikh Extremists"					               // to India
ident 4    0 0 1 3 1 "Taliban"						               // to Afghanistan
ident 183  1 1 0 2 1 "African National Congress (South Africa)"	          // in an ethnicity based conflict
ident 238  0 1 0 2 1 "Corsican National Liberation Front (FLNC)"           // France
ident 159  1 0 0 1 1 "Tupac Amaru Revolutionary Movement (MRTA)"           // Peru
ident 45   1 0 0 1 1 "M-19 (Movement of April 19)"                         // Colombia
ident 186  1 1 0 1 1 "People's Liberation Front (JVP)"			          // left-wing, ethnic/nationalist anti-tamil
ident 8    3 0 0 1 1 "National Union for the Total Independence of Angola (UNITA)" // anti-communist
ident 167  0 1 0 2 0 "Chechens"						               // Russia, could be also seen as religious
ident `cc' 0 0 0 0 2 "Narco-Terrorists" 					          // equal to location country
ident `cc' 0 0 0 0 0 "Death Squad" 					               // equal to location country
ident 233  0 2 2 2 0 "Protestant Extremists"				               // to Northern Ireland, anti-separatists
ident 43   1 0 0 1 1 "Movement of the Revolutionary Left (MIR) (Chile)"	// guerilla
ident 110  0 0 1 3 1 "Hizballah" // Lebanon, Islamist, anti-zionist
ident `cc' 0 0 1 3 0 "Muslim Militants"					// equal to location country
ident 233  0 2 2 2 1 "Ulster Volunteer Force (UVF)"			// anti-separatists
ident 60   0 0 1 3 1 "al-Gama'at al-Islamiyya (IG)"			// formed a political wing
ident 45   1 0 0 1 1 "Popular Liberation Army (EPL)"
ident 155  0 1 1 3 1 "Hamas (Islamic Resistance Movement)"		// to palestine, sep ethn
ident 209  1 0 0 1 1 "Dev Sol"
ident 233  0 2 2 2 1 "Ulster Freedom Fighters (UFF)"			// anti-separatists
ident 145  3 0 0 1 1 "Nicaraguan Resistance"
ident 186  0 1 0 2 0 "Tamils"
ident 98   1 0 0 1 1 "Red Brigades"
ident `cc' 2 0 0 1 0 "Neo-Nazi Group"					// equal to location country
ident `cc' 0 0 0 0 0 "Individual"						// equal to location country
ident 160  0 1 1 3 1 "Moro Islamic Liberation Front (MILF)" // philippines
ident 185  1 0 0 1 1 "First of October Antifascist Resistance Group (GRAPO)"
ident 145  1 0 0 1 1 "Sandinista National Liberation Front (FSLN)"
ident 45   1 0 0 1 1 "Simon Bolivar Guerrilla Coordinating Board (CGSB)"
ident `cc' 1 0 0 1 0 "Maoist Insurgents"					// equal to location country, could also be set equal to nepal
ident 137  3 0 0 1 1 "Mozambique National Resistance Movement (MNR)"
ident 110  1 1 0 2 1 "Armenian Secret Army for the Liberation of Armenia"  // set to Lebanon where it was founded by Armenian diaspora
ident `cc' 0 0 1 3 1 "Islamic Jihad (Ideological Grouping)" 		// equal to location if not by PIJ, guerilla
ident2 155 0 1 1 3 1 "Islamic Jihad (Ideological Grouping)" "Palestinian Islamic Jihad ("
ident2 155 0 1 1 3 1 "Islamic Jihad (Ideological Grouping)" "al-Quds Brigades (PIJ)" 
ident2 155 0 1 1 3 1 "Islamic Jihad (Ideological Grouping)" "al-Aqsa Battallions" 
ident 160  0 1 1 3 1 "Moro National Liberation Front (MNLF)" // philippines
ident `cc' 2 0 2 1 0 "Anti-Abortion Group"				// equal to location, rightwing
ident `cc' 0 1 0 2 0 "Separatists"						// equal to location 
ident 155  1 1 0 2 1 "Palestine Liberation Organization (PLO)"
ident 92   0 1 0 2 1 "United Liberation Front of Assam (ULFA)"
ident 6    0 0 1 3 1 "Armed Islamic Group (GIA)"
ident 153  0 1 0 2 1 "Muttahida Qami Movement (MQM)" // Karachi based Urdu-speaking muslims
ident 61   1 0 0 1 1 "People's Liberation Forces (FPL)"
ident 36   1 0 0 1 1 "Khmer Rouge"
ident 83   1 0 0 1 1 "Guerrilla Army of the Poor (EGP)"
ident `cc' 0 1 0 2 0 "Hutus"						// equal to location 
ident `cc' 0 0 1 3 0 "Islamic Terrorists"					// equal to location 
ident 6    0 0 1 3 1 "Islamic Salvation Front (FIS)"
ident 145  3 0 0 1 1 "Democratic Revolutionary Alliance (ARDE)"
ident 83   1 0 0 1 1 "Guatemalan National Revolutionary Unity (URNG)"
ident `cc' 0 1 1 2 0 "Muslim Separatists"					// equal to location 
ident `cc' 1 0 0 1 0 "Left-Wing Guerrillas"				// equal to location 
ident 238  0 1 0 2 1 "Corsican National Liberation Front- Historic Channel"
ident 213  0 1 2 3 1 "Lord's Resistance Army (LRA)"
ident 160  0 0 1 3 1 "Abu Sayyaf Group (ASG)" // philippines
ident 233  1 1 2 2 1 "Irish National Liberation Army (INLA)"		// to northern ireland, could also be to ireland
ident 155  0 1 1 3 1 "Al-Aqsa Martyrs Brigade"				// Fatah-close
ident 83   1 0 0 1 1 "Revolutionary Organization of People in Arms (ORPA)"
ident 11   1 0 0 1 1 "Montoneros (Argentina)"
ident 93   0 1 1 2 1 "Free Aceh Movement (GAM)"				// Indonesia
ident 78   1 0 0 1 1 "November 17 Revolutionary Organization (N17RO)"
ident 94   1 0 1 1 1 "Mujahideen-I-Khalq (MK)" // took part in 1979 revolution, wants to overthrow the Islamic Republic
ident 155  1 1 0 2 1 "Popular Front for the Liberation of Palestine (PFLP)" // far left, major ideology still ethnic
ident 45   0 0 0 0 2 "The Extraditables" // personal mafia interests
ident 43   1 0 0 1 1 "United Popular Action Movement" // chile
ident 95   0 0 1 3 1 "Al-Qa`ida in Iraq"					// to iraq
ident 19   0 1 0 2 1 "Shanti Bahini - Peace Force"
ident 145  3 0 0 1 1 "Contras"
ident `cc' 0 0 0 0 0 "Opposition Group"					// equal to location 
ident 92   1 0 0 1 1 "People's War Group (PWG)"				// banned maoist party in india with guerilla units
ident `cc' 0 0 1 3 1 "Muslim Brotherhood"				// equal to location, sometimes also polwing
ident 78   1 0 0 1 1 "Revolutionary People's Struggle (ELA)"
ident 92   0 1 0 2 0 "Bodo Militants"
ident 11   1 0 0 1 1 "Ejercito Revolucionaria del Pueblo (ERP) (Argentina)"
ident 153  0 0 1 3 1 "Lashkar-e-Taiba (LeT)"				// to  pakistan, ~int org based in pak, all attacks here in india
ident `cc' 0 0 1 3 0 "Muslim Fundamentalists"				// equal to location 
ident 163  1 1 0 2 1 "Fuerzas Armadas de Liberacion Nacional (FALN)"	// left-wing and separatist
ident 217  1 0 0 1 1 "New World Liberation Front (NWLF)"
ident `cc' 0 1 2 2 0 "Irish Catholic Extremists"				// equal to location, all in northern ireland
ident 92   0 1 0 2 0 "Kashmiri Militants"				// to india, potentially islamist
ident `cc' 1 0 0 1 0 "Communists"					// equal to location
ident 69   0 1 0 2 1 "Resistenza" // Corsa
ident 209  1 0 0 1 1 "Turkish People's Liberation Army"
ident 138  0 1 0 2 1 "Karen National Union"
ident 362  1 0 0 1 1 "Red Army Faction (RAF)"				// to west germany, some obs. have country equal germany, check again
ident 92   0 1 1 2 1 "Hizbul Mujahideen (HM)"				// to india, mostly kashmiris
ident 61   1 0 0 1 1 "People's Revolutionary Army (ERP) (El Salvador)"
ident 139  1 1 0 2 1 "South-West Africa People's Organization (SWAPO)" // liberation front now party
ident 238  0 1 0 2 0 "Corsican Separatists"
ident 45   1 0 0 1 1 "Ricardo Franco Front (Dissident FARC)"
ident 185  1 1 0 2 1 "Terra Lliure" // catalonian nationalist
ident 101  1 0 0 1 1 "Chukakuha (Middle Core Faction)"			// japan
ident 153  0 1 1 2 1 "Jammu and Kashmir Islamic Front"			// formed from pakistan
ident 217  2 0 4 3 1 "Jewish Defense League (JDL)"				// to united states, diaspora, ethnic, right wing
ident 145  3 0 0 1 1 "Recontras"						//rightwing, guerilla
ident 92   0 1 0 2 1 "Gurkha National Liberation Front (GNLF)"
ident 92   1 0 0 1 1 "Naxalites"						// maoists with guerilla units
ident 362  1 0 0 1 1 "Revolutionary Cells"					// to west germany, some obs. have country equal germany
ident 6    0 0 1 3 1 "Salafist Group for Preaching and Fighting (GSPC)"
ident `cc' 0 0 0 0 0 "Terrorists"						// equal to location
ident 98   1 0 0 1 1 "Prima Linea" // italy
ident 69   0 1 0 2 1 "Iparretarrak (IK)" // france
ident 177  0 0 0 0 2 "Revolutionary United Front (RUF)" // bandit federation, looting, Sierra Leone
ident 205  0 0 1 3 0 "Thai Islamic Militants"
ident 362  1 0 0 1 1 "Baader-Meinhof Group"				// to west germany, some obs. have country equal germany, check again
ident 175  0 1 0 2 1 "Kosovo Liberation Army (KLA)"			// to serbia montenegro due to time frame 
ident 174  0 1 0 2 1 "Movement of Democratic Forces of Casamance"
ident 69   1 0 0 1 1 "Action Directe"
ident 44   0 1 0 2 0 "Uighur Separatists"
ident 155  1 1 0 2 1 "Abu Nidal Organization (ANO)"
ident `cc' 4 0 0 4 1 "Animal Liberation Front (ALF)"			// equal to location
ident 155  0 1 0 2 1 "Black September"
ident 6    0 0 1 3 0 "Moslem Activists"
ident 51   3 0 0 1 1 "Omega-7"						// Cuban exiles, anticommunist
ident `cc' 1 0 0 1 0 "Left-Wing Terrorists"				// equal to location
ident `cc' 0 0 0 0 0 "Guerrillas"						// equal to location
ident 183  0 1 0 2 1 "Inkatha Freedom Party (IFP)"			// populist, Zulu nationalist party
ident 185  1 0 0 1 1 "Revolutionary Patriotic Anti-Fascist Front (FRAP)"
ident 155  1 1 0 2 1 "al-Fatah"						// borderline left wing
ident 185  1 1 0 2 1 "Free Galician People's Guerrilla Army"
ident 12   0 1 0 2 1 "Justice Commandos for the Armenian Genocide"
ident 162  1 0 0 1 1 "Popular Forces of April 25"
ident `cc' 2 0 0 1 0 "Right-Wing Extremists"				// equal to location
ident 130 1 0 0 1 1 "23rd of September Communist League"
ident 92  0 1 5 2 1 "Dishmish Regiment"					// Sikh organization
ident `cc' 0 0 1 3 0 "Islamic Resistance"					// equal to location
ident `cc' 0 1 0 2 0 "Tribal Group"					// equal to location
ident 196 0 1 0 2 1 "Brunswijk Jungle Commando"
ident 218 1 0 0 1 1 "Tupamaros (Uruguay)"
ident `cc' 0 0 0 0 0 "Gunmen"						// equal to location
ident 233 1 1 2 2 1 "Official Irish Republican Army (OIRA)"		// to northern ireland
ident 217 1 0 0 1 1 "Weather Underground, Weathermen" // usa
ident 61  1 0 0 1 1 "Armed Forces of National Resistance (FARN)"
ident 88  1 0 0 1 1 "Lorenzo Zelaya Revolutionary Front (LZRF)"
ident `cc' 4 0 0 4 1 "Earth Liberation Front (ELF)"			// equal to location
ident `cc' 0 0 1 3 0 "Muslims"						// equal to location
ident 34  0 1 0 2 1 "Party for the Liberation of the Hutu People (PALIPEHUTU)"
ident 61  1 0 0 1 1 "Popular Revolutionary Bloc (BPR)"			// armed wing is FPL
ident 213 0 0 0 3 2 "Allied Democratic Forces (ADF)" // Ugandan rebels, muslim sect w. ex-christian leader, grabbing resources 
ident 235 0 1 0 2 0 "Croatian Nationalists"				// to yugoslavia due to time frame
ident 92  0 1 0 2 1 "National Democratic Front of Bodoland (NDFB)"
ident 209 1 0 0 1 1 "Turkish People's Liberation Front (TPLF)(THKP-C)"
ident 118 0 1 0 2 1 "National Liberation Army (NLA) (Macedonia)"		// to macedonia, albanians
ident 185 0 1 0 2 1 "Canary Islands Independence Movement"		// to spain, based in algeria
ident 145 0 1 0 2 1 "Misurasata Indian Organization"			 
ident `cc' 0 0 1 3 0 "Muslim Rebels"					// equal to location
ident `cc' 0 0 0 0 0 "Paramilitaries"					// equal to location
ident 155 1 1 0 2 1 "Democratic Front for the Liberation of Palestine (DFLP)"
ident 83  1 0 0 1 1 "Rebel Armed Forces of Guatemala (FAR)"
ident `cc' 0 0 1 3 0 "Shiite Muslims"					// equal to location
ident 195 0 1 2 2 1 "Sudan People's Liberation Army (SPLA)"
ident 209 0 0 1 3 1 "Great Eastern Islamic Raiders Front (IBDA-C)"
ident 160 1 0 0 1 1 "April 6th Liberation Movement"			// philippines, anti-marcos urban guerillas
ident 19  2 0 1 1 1 "Bangladesh Nationalist Party (BNP)" // center-right, also nationalist
ident 138 0 0 5 3 0 "Buddhist Monks"
ident 92  1 0 0 1 1 "Maoist Communist Center (MCC)"
ident 216 0 1 0 2 1 "Meibion Glyndwr"
ident 98  1 0 0 1 1 "Armed Proletarian Nuclei (NAP)"
ident 69  0 1 0 2 1 "Breton Liberation Front (FLB)"
ident 233 0 1 2 2 1 "Real Irish Republican Army (RIRA)"			// to northern ireland
ident 45  2 0 0 1 1 "United Self Defense Units of Colombia (AUC)"
ident 217 1 1 0 2 1 "Black Liberation Army"				// ethnic/racial in us
ident 92  0 1 0 2 1 "Tripura National Volunteers (TNV)"
ident `cc' 0 1 0 2 0 "Tuaregs"						// equal to location
ident 157 0 1 0 2 1 "Bougainville Revolutionary Army (BRA)"
ident 209 1 0 0 1 1 "Turkish Communist Party/Marxist (TKP-ML)"
ident 59  1 0 0 1 1 "Alfaro Vive"
ident 92  1 0 0 1 1 "Communist Party of India - Maoist (CPI-M)"
ident 92  0 1 0 2 1 "National Liberation Front of Tripura (NLFT)"
ident 205 0 1 1 2 1 "Pattani United Liberation Organization (PULO)"	// Thailand, islamist
ident `cc' 2 0 0 1 0 "Vigilante Group"					// equal to location
ident 110 0 0 1 3 1 "Amal" // lebanon
ident 153 0 1 0 2 1 "Baloch Liberation Army (BLA)"			// to pakistan
ident 185 1 1 0 2 1 "Catalan Liberation Front (FAC)"
ident 110 1 1 0 2 1 "Lebanese National Resistance Front" // anti-Israel agenda, communists
ident 233 0 1 2 2 1 "Loyalist Volunteer Forces (LVF)"
ident 88  1 0 0 1 1 "Patriotic Morazanista Front (FPM)"
ident 69  0 1 0 2 1 "Caribbean Revolutionary Alliance (ARC)"		// to france
ident 69  1 0 0 1 1 "International Revolutionary Action Group (GARI)"
ident 222 1 0 0 1 1 "Red Flag (Venezuela)"
ident 110 0 1 0 2 1 "16 January Organization for the Liberation of Tripoli" // no clear info, anti-syria liberation war
ident `cc' 1 0 0 1 0 "Anarchists"						// equal to location
ident 88  1 0 0 1 1 "Cinchoneros Popular Liberation Movement"
ident 233 0 1 2 2 1 "Continuity Irish Republican Army (CIRA)"		// to northern ireland
ident `cc' 0 0 0 0 0 "Extremists"						// equal to location
ident 45  3 0 0 1 1 "Peasant Self-Defense Group (ACCU)"			// contra, paramilitary
ident 101 1 0 0 1 1 "Revolutionary Workers' Council (Kakurokyo)"
ident `cc' 0 0 0 0 0 "Strikers"						// equal to location
ident `cc' 0 1 0 2 0 "Arab Separatists"					// equal to location, all in iran
ident `cc' 3 0 0 1 0 "Counter-revolutionaries"				// equal to location
ident 145 2 0 0 1 1 "Ex-Somoza National Guard"
ident 130 1 0 0 1 1 "Zapatista National Liberation Army"
ident 83  1 0 0 1 1 "Guatemalan Labor Party (PGT)"
ident 153 0 2 1 2 1 "Jaish-e-Mohammad (JeM)"				// to pakistan, jihadist army, separatist!
ident 217 3 0 0 1 1 "National Front for the Liberation of Cuba (FLNC)"	// exile-Cuban terrorism in us
ident 26  1 1 0 1 1 "Tupac Katari Guerrilla Army (EGTK)"
ident `cc' 0 1 0 2 0 "Tutsi"						// equal to location
ident 110 0 0 0 0 0 "9 February"					// no info! attacks in Lebanon in 1988-89
ident 21  1 0 0 1 1 "Communist Combattant Cells (CCC) (Belgium)"
ident 138 0 1 5 2 1 "Democratic Karen Buddhist Army (DKBA)"
ident 63  1 1 0 2 1 "Eritrean Liberation Front"
ident 233 0 1 2 2 1 "Irish People's Liberation Organization (IPLO)"	// to northern ireland
ident 138 0 1 0 2 0 "Karen Insurgents"
ident 130 1 0 0 1 1 "Union of the People (UDP)"				// Mexican leftist group
ident 231 1 1 0 2 1 "Zimbabwe African Nationalist Union (ZANU)"
ident `cc' 0 0 0 0 0 "Anti-Government Guerrillas"				// equal to location
ident 185 2 2 0 2 1 "Anti-terrorist Liberation Group (GAL)" // right-wing, anti-separatist
ident 98  2 0 0 1 1 "Armed Revolutionary Nuclei (NAR)"
ident 163 0 1 0 2 1 "Independent Armed Revolutionary Commandos (CRIA)" // puerto-rican separatists
ident 92  0 1 5 2 1 "Khalistan Commando Force"
ident `cc' 0 0 0 0 0 "Students"						// equal to location
ident `cc' 0 0 0 0 0 "Armed People"					// equal to location
ident 141 1 0 0 1 1 "Communist Party of Nepal- Maoist (CPN-M)"
ident 8   0 1 0 2 1 "Front for the Liberation of the Enclave of Cabinda (FLEC)"
ident 97  2 1 4 2 0 "Israeli Settler"					// jewish, ethnic
ident 163 0 1 0 2 0 "Macheteros" // puerto rico
ident 349 1 1 0 2 1 "Polisario Front"					// to western sahara, debatable, left wing
ident 233 0 1 2 2 1 "Red Hand Defenders (RHD)"
ident 145 1 0 0 1 1 "Sandinistas"
ident `cc' 3 0 0 1 1 "Secret Anti-Communist Army (ESA)"			// equal to location
ident 213 0 1 0 2 1 "Uganda Freedom Movement (UFM)" // Buganda separatists
ident `cc' 0 0 0 0 0 "Anti-Government Group"				// equal to location
ident 11  2 0 0 1 1 "Argentine Anticommunist Alliance (AAA)"
ident `cc' 0 0 0 0 2 "Dacoits"						// bandits
ident 45  3 0 0 1 1 "Death to Kidnappers (MAS)" // contras
ident 94  1 0 0 1 1 "Forqan Group"					// Iran, marxist [though potentially islamist according to wikipaedia] 
ident 94  0 0 0 0 0 "Iranians"
ident `cc' 0 0 1 3 1 "Jemaah Islamiya (JI)"				// attacks in Indonesia and Philippines, national cells
ident 97  0 1 4 3 0 "Jewish Terrorists"
ident 147 0 1 0 2 1 "Movement for Emancipation of Niger Delta (MEND)"	// secessionist
ident `cc' 0 0 1 3 0 "Muslim Extremists"					// equal to location
ident 155 0 1 1 2 1 "Popular Resistance Committees"
ident 110 0 0 1 3 1 "Shaykh Subhi Al-Salih Forces"			// during lebanese civil war, guerilla
ident 153 0 0 1 3 1 "Sipah-e-Sahaba/Pakistan (SSP)" // pakistan
ident 83  1 0 0 1 1 "31 January People's Front (FP-31)"			// guatemala, leftist group
ident 95  0 0 1 3 1 "Ansar al-Islam"
ident `cc' 0 1 0 2 0 "Arabs"						// equal to location
ident 163 0 1 0 2 1 "Armed Revolutionary Independence Movement (MIRA)"
ident 19  1 1 0 2 1 "Awami League"
ident 155 0 1 1 2 1 "Black Panther Group (Palestinian)"	// israeli group with same name exists but not in GTD
ident 95  0 0 1 3 1 "Islamic State of Iraq (ISI)"
ident 98  2 0 0 1 1 "Italian Social Movement (MSI)"
ident 19  0 0 1 3 1 "Jama'atul Mujahideen Bangladesh (JMB)"		
ident 209 0 1 0 2 0 "Kurds"						// all older attacks against turkish and German citizens, to turkey
ident 153 0 0 1 3 1 "Lashkar-e-Jhangvi"
ident 130 1 0 0 1 1 "Popular Revolutionary Army"
ident `cc' 2 0 0 1 0 "Right-Wing Death Squad"				// equal to location
ident `cc' 2 0 0 1 0 "Right-Wing Group"					// equal to location
ident `cc' 0 1 0 2 0 "Serbian guerrillas"					// equal to location, debatable
ident 156 2 0 0 1 1 "20 December Movement (M-20)"			
ident 153 0 0 1 3 1 "Al-Mansoorian"					// to pakistan, could also be to india, sub organization of LeT
ident 69  1 0 0 1 1 "Coordination for Revolutionary Action(CAR)"
ident 217 2 0 4 3 1 "Jewish Armed Resistance"				// US: active in 1976-77 in us against soviet targets, two attacks in 1982 in Italy
ident 209 0 1 0 2 0 "Kurdish Militants" // to turkey, attacks in the 1990es, only against turkish and german citizens
ident `cc' 0 1 0 2 0 "Naga People"						// India and Myanmar, equal to location
ident 112 0 1 0 2 1 "National Patriotic Front of Liberia (NPFL)" // rebel group initiating civil war, originally ethnic roots
ident 92  1 1 0 2 1 "National Socialist Council of Nagaland"		// india, naga nationalists, maoist separatism
ident 95  0 0 1 3 1 "Tawhid and Jihad"
ident `cc' 0 1 0 2 0 "Tuareg Guerrillas"					// equal to location
ident 95  0 0 1 3 1 "Ansar al-Sunna"
ident `cc' 4 0 0 5 0 "Anti-Nuclear Group"					// equal to location
ident 45  1 0 0 1 0 "Colombian Guerrillas"
ident 93  0 1 0 2 0 "East Timorese Activists"				// to indonesia due to timeframe
ident 61  1 0 0 1 1 "February 28 Popular League (El Salvador)" // leftist, GS claims separatist
ident 93  0 1 0 2 1 "Free Papua Movement (OPM-Organisasi Papua Merdeka)"
ident 110 0 0 0 0 0 "Front for the Liberation of Lebanon from Foreigners" // unclear cover group, potentially christian or Izraeli secret service, not coded!
ident 92  0 1 5 2 1 "Khalistan Liberation Force"
ident `cc' 1 0 0 1 0 "Marxists"						// equal to location
ident 34  0 1 0 2 1 "National Council for Defense of Democracy (NCDD)" // burundi
ident 45  0 0 0 0 0 "Popular Militia (Colombia)"			// no info
ident 159 2 0 0 1 1 "Rodrigo Franco Command"
ident 213 0 1 0 2 1 "Uganda People's Army" // ethnic militia
ident 45  1 0 0 1 1 "Workers' Self-Defense Movement (MAO)"
ident 362 1 0 0 1 1 "2nd of June Movement"				// to west germany
ident 11  1 0 0 1 1 "Che Guevara Brigade"
ident 217 2 0 0 1 1 "Death Angels" // ratially motivated Zebra-murders in us, potentially related to the black Nation of Islam group but this is unclear
* 14 group total
ident 111 1 0 0 1 1 "Devrimici Halk Kurtulus Cephesi (DHKP/C)"
ident 130 1 0 0 1 1 "Institutional Revolutionary Party (PRI)"
ident 58  1 1 0 1 1 "Maximiliano Gomez Revolutionary Brigade"
ident 92  0 1 0 2 1 "Mizo National Front"
ident 182 0 0 1 3 1 "Mujahideen Youth Movement (MYM)"
ident 11  1 0 0 1 1 "People's Revolutionary Organization"
ident `cc' 0 0 1 3 0  "Sunni Muslims"
ident 61  2 0 0 1 1 "Union Guerrera Blanca (UGB)"
ident 99  2 0 0 1 0 "Young Patriots"
ident 6   0 0 1 3 1 "Al-Qa`ida in the Lands of the Islamic Maghreb (AQLIM)"
ident 78  1 0 0 1 0 "Anti-Authority Group (Greece)"
ident 51  2 0 0 1 1 "Coordination of the United Revolutionary Organization (CORU)" // cuban exile group, founded in Dominican Republic, moved between Costa Rica, Venezuela, US, etc.; still to Cuba since no other clearly defineable country of origin
ident 98  1 0 0 1 1 "Fighting Proletarian Squads"			// all in italy against german targets
ident 155 1 1 0 2 1 "Force 17" // palestine, fatah unit, mildly left
ident 217 1 0 0 1 1 "George Jackson Brigade"
ident 19  0 0 1 3 1 "Jamaat-E-Islami (Bangladesh)" // party with islamist anti-liberation roots, attacks 1991-2000
ident 138 0 1 0 2 1 "Kachin Independence Army (KIA)"
ident 209 0 1 0 2 1 "Kurdistan Freedom Hawks (TAK)"			// to turkey
ident `cc' 0 0 1 3 0 "Muslim Guerrillas"					// equal to location
ident `cc' 0 0 0 0 0 "Political Activists"				// equal to location
ident `cc' 0 0 0 0 0 "Political Group"					// equal to location
ident 61  1 0 0 1 1 "United Popular Action Front (FAPU)"		// left movement el salvador
ident `cc' 2 0 0 1 0 "White Extremists"
ident `cc' 0 0 0 0 0 "Youths"
ident 231 1 1 0 2 1 "Zimbabwe African People's Union"			// 
ident 92  0 1 0 2 1 "All Tripura Tiger Force (ATTF)"
ident 130 1 0 0 1 1 "Democratic Revolutionary Party"
ident 101 1 0 0 1 1 "East Asia Anti Japanese Armed Front" // criminal
ident 97  2 0 4 1 1 "Kach"						// jewish theocratic, far-right
ident 111 1 0 0 1 1 "Lesotho Liberation Army (LLA)" // anti-govt struggle
ident 110 1 1 0 2 1 "New Armenian Resistance"				// part of asala, to lebanon since asala has lebanese founders & members
ident 92  1 1 0 2 1 "People's Liberation Army (India)"			// ethnsep Manipur, guerilla
ident 93  1 1 0 2 1 "Revolutionary Front for an Independent East Timor (FRETILIN)"	// to indonesia due to timeframe
ident 78  1 0 0 1 1 "Revolutionary Nuclei"
// ident `cc' 0 0 1 3 1 "Abu Hafs al-Masri Brigades"			// islamist international group, not coded since origin unclear
ident 98  1 0 0 1 1 "Autonomy (Italy)"					// no info, supposedly leftist
ident 98  1 0 0 1 1 "Communist Fighting Unit"
ident 51  2 1 0 1 1 "Cuban Action Commandos"				// in us assigned to cuba
ident 153 0 1 1 2 1 "Harkat ul Ansar"					// to pakistan, could also be to india
ident `cc' 2 0 0 1 0 "Neo-Fascists"
ident `cc' 0 0 0 0 2 "Pirates"
ident 45  0 1 0 2 1 "Quintin Lame"
ident 168 1 1 0 2 1 "Rwanda Patriotic Front (RPF)"			// socialist nationalists
ident 138 0 1 0 2 1 "Shan State Progressive Party"			// political arm of the shan state army
ident 185 2 2 0 2 1 "Spanish Basque Battalion (BBE) (rightist)"	// right-wing paramilitary, mainly anti-separatist
ident `cc' 0 0 0 0 0 "Subversives"
ident 183 2 0 0 1 1 "White Wolves"
ident 78  1 0 0 1 1 "1 May"						// supp. leftist
ident 160 1 0 0 1 1 "Alex Boncayao Brigade (ABB)" // philippines
ident 94  0 0 0 0 0 "Anti-Iran Government Exiles"
ident `cc' 1 0 0 1 1 "Arab Communist Organization"			// based in lebanon and syria
ident 185 1 1 0 1 1 "Autonomous Anti-Capitalist Commandos (CAA)"
ident 110 0 1 1 3 1 "Committee of Solidarity with Arab and Middle East Political Prisoners (CSPPA)" // Lebanese citizens in France, arab nationalist/religious, Hezbollah ally
ident 92  0 1 0 2 1 "Dima Halao Daoga (DHD)"				// separatists in India
ident 65  0 0 0 0 0 "Ethopian Backed Rebels"
ident 4   0 0 1 3 1 "Hizb-I-Islami"
ident 185 1 0 0 1 1 "Iberian Liberation Movement (MIL)"
ident 238 0 1 0 2 1 "Indipendenza"
ident 98  1 0 0 1 1 "Informal Anarchist Federation"
ident 141 1 1 0 2 1 "Janatantrik Terai Mukti Morcha (JTMM)" // nepalese revolutionary separatists
ident 97  0 1 4 3 0 "Jewish Terror"
ident 95  1 1 0 2 1 "Kurdish Democratic Party-Iraq (KDP)"		// guerilla
ident `cc' 0 1 0 2 0 "Kurdish Dissidents"				// to location, attacks in western europe
ident `cc' 0 1 0 2 0 "Kurdish Separatists"				// to location, mostly in turkey but also in western europe
ident 92  0 1 1 3 0 "Long-time Muslim immigrants from Bangladesh"	// thus to india
ident 233 0 1 2 2 1 "Orange Volunteers (OV)"
ident 98  1 0 0 1 1 "Proletarian Patrols"
ident 233 0 1 2 2 1 "Red Hand Commandos"
ident 163 1 1 0 2 1 "Revolutionary Commandos of the People (CRP)" // puerto rico, anti-us
ident `cc' 1 0 0 1 1 "Revolutionary Workers Party"			// similar profile in el salvador and colombia, diff parties prob
ident `cc' 0 0 0 0 0 "Rival Activists"
ident 74  0 0 0 0 0 "Supporters of Ex-President Gamsakhurdial"		// hard to code, civil war-like situation
ident 65  1 1 0 1 1 "Tigray Peoples Liberation Front (TPLF)" // leftist, regional self-determination
ident 217 1 0 0 1 1 "United Freedom Front (UFF)"
ident 92  0 1 1 2 1 "Al-Umar Mujahideen"				// to india, rather than pakistan, kashmir
ident 12  0 1 0 2 0 "Armenian Guerrillas"
ident 92  0 1 5 3 1 "Babbar Khalsa International (BKI)" // sikh separatists, primary could also be religious
ident `cc' 0 0 0 0 2 "Bandits"
ident 92  0 1 5 3 1 "Bhinderanwale Tiger Force of Khalistan (BTHK)" // sikh separatists, primary could also be separatist
ident `cc' 4 1 0 2 0 "Black Nationalists" // predominantly us, but also rhodesia, south africa
ident 217 4 0 0 1 1 "Black Panthers" // us black supremacist, socialist revolution
ident 155 1 1 0 2 1 "Black September II" // palestinian, Fatah-splinter, 
ident 217 1 1 0 2 1 "Chicano Liberation Front"				// mexican marxist group, to us
ident `cc' 0 0 0 0 0 "Commandos"
ident 155 1 1 0 2 1 "Eagles of the Palestinan Revolution"		// palest wing of syrian baath party, to palestine,debatable
ident 95  0 1 1 3 0 "Iraqi Mujahideen"
ident 101 1 0 0 1 1 "Japanese Red Army (JRA)"
ident 51  1 1 0 1 1 "Luis Boitel Commandos" // marxist cubans in us
ident `cc' 0 0 0 0 2 "Mafia"						// all in italy
ident 153 0 1 0 2 1 "Mohajir National Movement" // kashmir
ident `cc' 0 0 0 0 0 "Ninjas"
ident 110 0 1 0 2 1 "Orly Organization"					// fraction of ASALA, to lebanon instead of armenia
ident 183 0 0 1 1 1 "People Against Gangsterism and Drugs (PAGAD)" // vigilantes
ident 11  1 0 0 1 1 "Peronist Armed Forces (FAP)"
ident 8   1 0 0 1 1 "Popular Movement for the Liberation of Angola" // ethnic separatists at formation, but attacks took place after independence, in the civil war against UNITA
ident 19  1 0 0 1 1 "Purbo Banglar Communist Party"
ident 160 0 0 0 0 1 "Reform of the Armed Forces Movement"		// philippines, military coups, against govts and corruption
ident 185 1 0 0 1 1 "Revolutionary Communist League (LCR) (Spain)"
ident `cc' 1 0 0 1 0 "Social Resistance"					// all in greece
ident 186 0 1 0 2 1 "Tamil Eelam Liberation Organization (TELO)" // indian-backed separatist, w/o strong political profile
ident 209 1 0 0 1 0 "Turkish Leftists"
ident 231 1 1 0 2 1 "Zimbabwe Patriotic Front"
ident 101 0 0 0 0 0 ")"							// encoding error, all of it in Japan
ident 4   0 1 0 2 0 "Afghan Guerrillas"
ident 60  0 0 1 3 1 "Al Jihad"
ident 153 1 0 0 1 1 "Al Zulfikar"
ident 185 2 1 0 2 1 "Anti-terrorism ETA (ATE)"
ident 155 0 1 0 2 1 "Arab Revolutionary Army"				// to palestine
ident 78  1 0 0 1 1 "Athens and Thessaloniki Arsonist Nuclei"
ident 101 0 0 5 3 1 "Aum Shinri Kyo"
ident 16  0 1 0 2 0 "Azerbaijan Guerrillas"
ident 26  2 0 0 1 1 "Bolivian Socialist Falange" // right-wing party
ident 69  0 2 0 2 1 "Francia"						// france, anti sep
ident 162 2 1 0 2 1 "Front For the Liberation of the Azores"
ident 209 2 0 0 1 1 "Grey Wolves"
ident `cc' 0 0 3 3 0 "Hindu Group"					// all in india
ident 153 0 0 1 3 1 "Jamaat-E-Islami (Pakistan)"
ident 153 0 1 1 3 1 "Jamiat ul-Mujahedin (JuM)" // separatist and religious
ident `cc' 1 0 0 1 0 "Maoist Guerrillas"
ident 95  0 0 1 3 1 "Mujahedeen Shura Council"
ident 110 1 1 0 2 1 "Ninth of June Organzation"  // fraction of ASALA, to lebanon instead of armenia
ident 163 0 1 0 2 1 "Organization of Volunteers for the Puerto Rican Revolution"
ident 43  0 0 0 0 0 "People's Fatherland Movement"			// no info
ident 45  1 0 0 1 1 "People's Revolutionary Army (ERP)" // small marxist guerilla organization in Colombia, groups with the same name exist in Argentina, El Salvador and Mexico, all coded differently
ident `cc' 0 0 0 0 0 "Rebels"
ident 78  1 0 0 1 0 "Revolutionary Struggle"
ident 182 0 1 0 2 1 "Somali Salvation Front (SSF)" // less leftist than ssdf, organized along ethnic lines
ident 142 0 1 0 2 0 "South Moluccans"					// to netherlands, debatable
ident 231 1 0 0 1 0 "Supporters of Joshua Nkomo"
ident `cc' 0 0 0 0 0 "Workers/Employees"
ident 4   0 0 1 3 0 "Afghan Mujahideen"
ident `cc' 0 0 0 0 0 "Anti-Government Demonstrators"
ident `cc' 1 0 0 1 0 "Anti-Monarchists"					// radical left in Japan, attack against Japanese Ambassador in Nepal
ident 11  1 0 0 1 1 "Argentine Liberation Front (FAL)"			// left-wing urban guerilla
ident 238 0 1 0 2 1 "Armata di Liberazione Naziunale (ALN)"
ident 12  0 1 0 2 0 "Armenians"
ident 153 0 1 0 2 0 "Baloch Nationalists"
ident 110 0 0 1 3 1 "Beirut Martyrs Battalion"
ident 78  1 0 0 1 1 "Black Star"
ident 92  0 1 0 2 1 "Bodo Liberation Tigers (BLT)"			// armed separatist group
ident 238 0 1 0 2 0 "Corsican Nationalists"
ident 53  0 1 0 2 1 "Cyprus Turkish People's Movement"
ident 186 0 1 0 2 1 "Eelam People's Revolutionary Liberation Front (EPRLF)"	// militant separatists, later party
ident 94  1 0 0 1 1 "Fedayeen Khalq (People's Commandos)"
ident 78  1 0 0 1 0 "Fighting Popular Rally"				// no info, supp. leftists
ident 185 0 0 0 0 0 "GAC"						// unidentified spanish organization, active 1970-1974
ident 81  0 1 0 2 1 "Guadeloupe Liberation Army"
ident 213 0 0 2 3 1 "Holy Spirit Movement"				// ugandan rebel group, army with spiritual practices
ident 6   0 0 1 3 1 "Islam Liberation Front"
ident 97  0 0 4 3 1 "Keshet"	// bombings in 1998 and 1999 by an ultra-orthodox Jewish group against secular targets
ident 145 0 1 0 2 1 "Kisan Indian Organization"				// indian rebels in nicaragua
ident 156 0 1 0 2 0 "Kuna Indians"
ident `cc' 0 1 0 2 0 "Kurdish Rebels"					// to location, iran and turkey
ident 30  1 0 2 1 1 "Landless Peasants' Movement (MST)"
ident 110 1 0 0 1 1 "Lebanese Armed Revolutionary Faction (LARF)"
ident 110 0 1 0 2 1 "Lebanese Liberation Front" // anti-syrian ethnic front
ident `cc' 1 0 0 1 0 "Left-Wing Extremists"
ident 61  2 0 0 1 1 "Maximiliano Hernandez Martinez Brigade"
ident `cc' 0 0 0 0 0 "Mob"
ident 88  1 0 0 1 1 "Morazanist Front for the Liberation of Honduras (FMLH)"
ident 159 1 0 0 1 1 "Movement of the Revolutionary Left (MIR) (Peru)"
ident 153 1 0 0 1 1 "Pakistani People's Party (PPP)"			// centre-left...
ident 155 1 1 0 2 1 "Palestine Liberation Front (PLF)"  //
ident 95  1 1 0 2 1 "Patriotic Union of Kurdistan (PUK)"		// mildly leftist
ident 45  1 0 0 1 1 "Pedro Leon Arboleda (PLA)"
ident 98  1 0 0 1 1 "Proletarian Fighting Patrol"
ident `cc' 0 0 0 0 0 "Protesters"
ident 113 0 0 0 0 0 "Qaddaffis"						// to libya
ident 145 3 0 0 1 1 "Recompras"			// Recontras, here nicaragua
ident 98  1 0 0 1 1 "Red Brigades Fighting Communist Party (BR-PCC)"
ident `cc' 1 0 0 1 1 "Red Guerrilla"					// no guerilla, all in spain italy
ident 98  1 0 0 1 1 "Revolutionary Action" // italy
ident 78  1 0 0 1 1 "Revolutionary Popular Left" // greece
ident 216 0 1 0 2 1 "Scottish National Liberation Army"
ident 51  2 0 0 1 1 "Secret Cuban Government"				// ...
ident 235 0 1 0 2 0 "Serbian Militants"					// Yugoslavia due to timeframe
ident 235 0 1 0 2 0 "Serbs" 
ident3 175 0 1 0 2 0 "Serbs" 1992					// yug/serbia split
ident 110 0 0 1 3 1 "Soldiers of Truth"			// lebanon based, Jund-al-Haq, extremist islam
ident 95  0 0 1 3 1 "Supreme Council for Islamic Revolution in Iraq (SCIRI)"
ident 69  4 0 0 4 1 "Survivors of Golfech"				// anti-nuclear group
ident 217 1 0 0 1 1 "Symbionese Liberation Army (SLA)"
ident 200 0 1 0 2 1 "Syrian Social Nationalist Party"			// in leb civil war, could also be to lebanon
ident 97  0 1 4 2 1 "Terror Against Terror"
ident 182 0 0 1 3 1 "Al-Shabaab"
ident 45  1 0 0 1 1 "America Battalion"					// related to M-19
ident 106 0 1 0 2 1 "Arab Revolution/Liberation Vanguard Organization"	// Kuwait, could be secular or muslim
ident 98  2 0 0 1 1 "Armed Falange"		// italian neo-nazi formation
ident 81  0 1 0 2 1 "Armed Group for the Liberation of Guadeloupe (GLAG)"
ident 69  1 0 0 1 1 "Armed Nucleus for Popular Autonomy"
ident 98  1 0 0 1 1 "Armed Proletarian Power"
ident 98  1 0 0 1 1 "Armed Proletarian Squads"
ident 69  0 1 0 2 1 "Basque Rectitudes" // to france
ident 185 0 1 0 2 0 "Basque Separatists" // to spain
ident 45  2 0 0 1 1 "Black Hand (Colombia)"				// supp. right wing
ident 98  0 0 0 0 0 "Black Order"					// no info
ident 69  0 1 0 2 0 "Breton Separatists"
ident 43  3 0 0 1 1 "Chilean Anti-Communist Alliance (ACHA)"
ident 185 2 0 0 1 1 "Commando Adolph Hitler"
ident 45  2 0 0 1 1 "Death to Bazuqueros"				// supp. right wing
ident 93  0 1 0 2 0 "E. Timorese Youths"
ident 362 1 0 0 1 1 "Extraparliamentary Opposition (APO)"
ident 155 1 1 0 2 1 "Fatah Uprising"					// borderline leftwing
ident 163 1 1 0 2 1 "Guerrilla Forces for Liberation"			// supp. left wing
ident 153 0 0 1 3 1 "Harkatul Jihad-e-Islami"
ident 69  1 0 0 1 1 "International Revolutionary Solidarity"
ident 95  0 0 0 0 0 "Iraqis"
ident 45  1 0 0 1 1 "Jaime Bateman Cayon Group (JBC)"
ident 195 0 1 1 2 1 "Janjaweed"	// ethnic, islamic, Sudan based, arab nationalism, tribes
ident 94  0 0 1 3 1 "Jundallah"
ident 195 0 0 1 3 1 "Justice and Equality Movement (JEM)"
ident `cc' 1 0 0 1 0 "Left-Wing Demonstrators"
ident 61  1 0 0 1 1 "Manuel Jose Arce Commando" // left-wing, fmln sympathizers
ident 209 1 0 0 1 1 "Marxist-Leninist Armed Propaganda Unit"
ident 217 1 0 0 1 1 "May 19 Communist Order"
ident 92  0 1 1 2 0 "Mujahideen Kashmir"				// could also be to pakistan
ident 53  0 1 0 2 1 "National Organization of Cypriot Fighters (EOKA)"
ident 11  2 0 0 1 1 "OAS-MRP"
ident `cc' 0 0 0 0 0 "Opposition Militants"
ident 65  0 1 0 2 1 "Oromo Liberation Front"
ident 155 0 1 0 2 1 "Palestinian Revolution Forces"
ident 138 0 0 0 0 0 "People's Army (Myanmar)"				// no info
ident 58  0 0 0 0 0 "Popular Liberation Resistance Force"		// no info
ident 163 0 1 0 2 1 "Puerto Rican Resistance Movement"
ident `cc' 0 0 0 0 0 "Radicals"
ident 182 0 1 0 2 1 "Rahanwein Resistance Army (RRA)" // autonomist
ident 233 0 1 2 2 1 "Republican Action Force"
ident 145 3 0 0 1 1 "Revolutionary Armed Forces of Nicaragua (FARN)"	// 
ident 156 1 0 0 1 1 "Revolutionary Front for National Liberation"	// left wing, but no specific info
ident 182 0 1 0 2 1 "Somali National Movement"
ident `cc' 0 0 0 0 0 "Supporters of Qadhafi"				// could be to UK
ident `cc' 0 0 0 0 0 "Taxi Drivers"
ident 101 0 0 0 0 0 "Tribal Battlefront"				// no info
ident `cc' 0 0 0 0 0 "Unemployed Persons"
ident 98  1 0 0 1 1 "Workers Brigade for Communism"
ident 217 2 0 5 1 1 "World Church of the Creator"			// white supremacy group with some christian traits
ident 69  0 0 0 0 0 "Youth Action Group"				// leftist
ident 183 2 0 0 1 1 "Afrikaner Resistance Movement (AWB)"			// down to 5 group_total
ident 136 0 0 1 3 1 "Al-Adl Wal Ihsane"
ident 173 0 0 1 3 1 "Al-Qa`ida in the Arabian Peninsula (AQAP)"		// all in saudi arabia
ident `cc' 0 1 0 2 1 "Albanian National Army (ANA)"			// group in macedonia & kosovo w. attacks there, to location
ident 92  0 1 5 3 1 "All India Sikh Students Federation (AISSF)" 

* few larger groups added or differently written after 2010 data update
ident `cc' 1 0 0 1 0 "Maoists"
ident `cc' 1 0 0 1 0 "Left-Wing Militants"
ident `cc' 0 0 0 0 0 "Student Radicals"
ident `cc' 0 1 0 2 1 "Jammu and Kashmir Liberation Front" // to location, uk founded, uk and india/pakistan based kashmiri nationalists
ident 147 1 1 0 2 1 "Movement for the Emancipation of the Niger Delta (MEND)" // mildly leftist
ident 153 0 0 1 3 1 "Tehrik-i-Taliban Pakistan (TTP)"
ident 217 2 0 0 1 1 "Ku Klux Klan"
ident 163 0 1 0 2 1 "Puerto Rican Nationalists"
ident 217 0 1 0 2 1 "Zebra killers"
ident 51  0 1 0 2 0 "Cuban Exiles"
ident 92  1 1 0 2 1 "National Socialist Council of Nagaland-Isak-Muivah (NSCN-IM)"
ident 217 2 0 0 1 1 "Aryan Republican Army"
ident 95  0 0 1 3 1 "Mahdi Army"
ident 78  1 0 0 1 1 "Conspiracy of Cells of Fire" // attacks in greece only, homonymous group in chile exists
ident 205 0 1 1 2 1 "Runda Kumpulan Kecil (RKK)"
ident 163 0 1 0 2 1 "Armed Commandos of Liberation" // puerto rican nationalists, homonymous groups in syria, portugal exist
ident 153 0 1 0 2 1 "Baloch Republican Army (BRA)"
ident 182 0 0 1 3 1 "Islamic Courts Union (ICU)"
ident 228 0 0 1 3 1 "Al-Qaida in Yemen"
ident 217 0 1 0 2 0 "Chicano Radicals"
ident1 159 1 0 0 1 1 "People's Revolutionary Command (CRP)" 159 // 2 groups, this is peru
ident1 163 1 1 0 1 1 "People's Revolutionary Command (CRP)" 163 // 2 groups, this is puerto rico
ident 92  2 0 0 1 1 "Ranbir Sena" // landlord militia
ident 155 0 1 0 2 1 "Eagles of the Palestinian Revolution"
ident 92  0 1 0 2 1 "People's Revolutionary Party of Kangleipak (PREPAK)"
ident 74  0 1 0 2 1 "South Ossetian Separatists" // all 2008 in war of indepedence from georgia/russian invasion, to georgia
ident 92  0 0 1 3 0 "Deccan Mujahideen" // claimed mumbai attacks, disputed
ident 92  1 1 0 2 1 "Kangleipak Communist Party (KCP)"
ident 92  0 1 0 2 1 "Karbi Longri North Cachar Liberation Front (KLNLF)"
ident 146 0 1 0 2 1 "Movement of Niger People for Justice (MNJ)" // north niger, goal: keeping uran resources in region
ident 92  1 1 0 2 1 "National Socialist Council of Nagaland-Khaplang (NSCN-K)"
ident 141 0 1 0 2 1 "Terai Army"
ident 217 2 0 0 1 1 "The Order (Silent Brotherhood)" // us right-wing
ident 217 0 0 0 0 0 "Up the IRS, Inc"
ident 141 1 0 0 1 1 "Young Communist League"
ident 167 0 1 1 2 1 "Caucasus Emirate"
ident 163 1 1 0 2 1 "Pedro Albizu Campos Revolutionary Forces" // puerto rican independence struggle
ident 217 0 1 0 2 1 "American Indian Movement"
ident 217 2 0 0 1 1 "Americans for a Competent Federal Judicial System" // us racist attacke
ident 217 2 0 0 1 1 "Aryan Nation"
ident `cc' 0 0 1 3 1 "Black Muslims"
ident 168 0 1 0 2 1 "Democratic Front for the Liberation of Rwanda (FDLR)" // to ruanda, could also be to congo
ident 92  0 0 1 3 0 "Indian Mujahideen"
ident 95  0 1 1 3 1 "Islamic Army in Iraq (al-Jaish al-Islami fi al-Iraq)"
ident 200 0 0 1 3 1 "Jund al-Sham for Tawhid and Jihad" // syrian based but somewhat intl group, recent attacks since 2006, trac claims it's ethnic-nationalist, which is unclear from secondary material
ident 92  2 1 0 2 1 "Kanglei Yawol Kanna Lup (KYKL)" // ethnic separatist vigilantes
ident 47  0 0 0 0 0 "Mayi Mayi" // local self-defence militia in Congolese war
ident 74  0 1 0 2 1 "Abkhazian Separatists"

*groups with 5 attacks
ident 182 0 1 1 3 1 "Al-Ittihaad al-Islami (AIAI)" // Somalia
ident `cc' 4 0 0 4 0 "Animal Rights Activists" 
ident 78  1 0 0 1 1 "Anti-State Justice" // Greece
ident 98  1 0 0 1 1 "Armed Communist Formations" // Italy
ident `cc' 0 1 0 2 0 "Armenian Group" // WEurope, US
ident 183 4 1 0 1 1 "Azania People's Organization (AZAPO)" // anti-apartheid, later party
ident 19  1 1 0 1 1 "Bangladesh Sarbahara Party" // outlawed maoist party
ident 205 1 1 1 2 1 "Barisan Revolusi Nasional (BRN)" // Thailand, Malay separatists, roots in islamic socialism
ident 92  0 1 0 2 1 "Black Widows" // India
ident 222 1 0 0 1 1 "Che Guevara Guerrillas" // Venezuela
ident `cc' 0 0 0 0 0 "Coca Farmers"
ident 69  1 0 0 1 1 "Communist Anti-Nuclear Front" // France
ident 98  1 0 0 1 1 "Communist Territorial Nuclei" // Italy
ident 78  1 0 0 1 1 "Conscientious Arsonists (CA)" // Greece
ident 235 0 1 0 2 0 "Croatian Freedom Fighters" // in US, to Yugoslavia due to time
ident `cc' 0 0 0 0 2 "Drug-Related Terrorists"
ident `cc' 0 1 5 3 1 "Druzes" // ethno-religious group in middle east/monotheistic [here lebanon & israel]
ident 98  0 1 0 2 1 "Ein Tyrol (One Tyrol)"
ident 65  1 0 0 1 1 "Ethiopian People's Revolutionary Party"
ident `cc' 0 0 0 0 0 "Farmers"
ident 155 0 1 0 2 1 "Fatah Hawks"
ident 78  1 0 0 1 1 "Fighting Guerrilla Formation" // Greece
ident 56  0 1 0 2 1 "Front for the Restoration of Unity and Democracy" // Djibouti
ident 185 2 0 0 1 1 "Fuerza Nueva" // Spain
ident 69  1 0 0 1 1 "Gracchus Babeuf" // France
ident 4   0 0 1 3 1 "Hezb-e Wahdat-e Islami-yi Afghanistan" // Afghanistan
ident 130 1 0 0 1 1 "Independent Peasants Union" // Mexico
replace gname = "Jewish Defense League (JDL)" if gname=="International Committee Against Nazism" // jewish far right group
ident 217 2 0 4 3 1 "Jewish Defense League (JDL)"				// us diaspora, far-right religious cionists
ident 217 0 1 1 2 1 "Jamaat-al-Fuqra" // pakistani separatist paramilitary group in us, mostly muslim african-americans
ident 143 1 1 0 2 1 "Kanak Socialist National Liberation Front" // new caledonia
ident 104 1 0 0 1 1 "Kenya African National Union (KANU)" // major political party in kenya
ident 78  1 0 0 1 1 "Khristos Kasimis" // greek anarchists
ident 138 0 0 0 0 2 "Khun Sa Guerrillas" // myanmar opium lord
ident 92  0 1 0 2 0 "Kuki tribesmen" // mongolian tribe in India
ident 209 0 1 0 2 0 "Kurdish Sympathizers" // to turkey
ident 83  2 0 0 1 1 "Mano Blanca" // guatemala
ident 69  1 0 0 1 1 "Meinhof-Puig-Antich Group" // France
ident 59  1 0 0 1 1 "Montoneros Patria Libre" // Ecuador
ident `cc' 0 0 1 3 0 "Muslim Demonstrators"
ident 47  0 1 0 2 1 "National Congress for the Defense of the People (CNDP)" // Dem. Congo rebel groups, nationalist/racist
replace gname = "November 17 Revolutionary Organization (N17RO)" if gname =="November 21 Organization" // Greece
ident 78  1 0 0 1 1 "November 17 Revolutionary Organization (N17RO)"
ident 65  0 1 0 2 1 "Ogaden National Liberation Front (ONLF)" // Ethiopia
ident `cc' 1 0 0 1 1 "Pan Africanist Congress (PAC)" // south africa plus tanzania faction
ident 159 1 0 0 1 1 "Patriotic Liberation Front" // Peru
ident 200 0 1 0 2 1 "Popular Front for the Liberation of Palestine, Gen Cmd (PFLP-GC)" // syrian based
ident 30  1 0 0 1 1 "Popular Revolutionary Vanguard (VPR)" // Brazil
ident 233 0 1 2 2 1 "Protestant Action Group" // Northern Irland
ident 163 0 1 0 2 1 "Puerto Rican Armed Resistance" // to puerto rico
ident 163 0 1 0 2 1 "Puerto Rican Revolutionary Movement" // to PR
ident 145 1 0 0 1 1 "Punitive Leftist Front" // nicaragua
ident `cc' 0 0 0 0 0 "Rebel Military Unit" // unidentified 
ident 75  1 0 0 1 1 "Red Cell" // germany
ident 11  1 0 0 1 1 "Revolutionary Armed Forces- Argentina (FAR-A)"
ident 217 1 0 0 1 1 "Revolutionary Force Seven" // us based latin american, most likely leftist
ident 155 1 0 1 1 1 "Revolutionary Organization of Socialist Moslems" // palestine based, split from plo 1974
ident `cc' 2 0 0 1 0 "Right Wing Vigilantes"
ident 92  0 0 0 0 0 "Rival caste" // to india
ident 136 0 0 1 3 1 "Salafia Jihadia" // morocco
ident 138 0 1 0 2 2 "Shan United Revolutionary Army" // myanmar, separatist + drugs
ident 185 2 2 0 2 1 "Spanish National Action" // anti-eta attacks, suspected govt. org.
ident 92  0 0 1 3 1 "Students Islamic Movement of India (SIMI)"
ident 195 0 1 0 2 1 "Sudanese People's Liberation Forces" // south sudan separatist
ident 141 1 0 0 1 1 "United Liberation Torchbearers Forces" // clandestine maoist group
ident 145 3 0 0 1 1 "United Nicaraguan Opposition" // nicaraguan guerillas, contras
ident 92  0 1 0 2 1 "United People's Democratic Solidarity (UPDS)"
ident 92  2 0 3 3 1 "Vishwa Hindu Parishad (VHP)" // right wing hindu international org India
ident 216 0 1 0 2 0 "Welsh Extremists"
ident 26  1 1 0 1 1 "Zarate Willka Armed Forces of Liberation" // bolivian indigenous anti-us
ident `cc' 0 0 0 0 0 "rioters"
* groups with four
ident 44  0 0 0 0 2 "14 K Triad" // criminal organization in china
ident 185 1 0 0 1 1 "1st of May Group" // anarchist anti-Franco spain
ident 88  1 0 0 1 1 "9 May People's Liberation Force" // honduras
ident `cc' 0 0 0 0 0 "Activists"
ident 92  0 1 0 2 1 "Adivasi National Liberation Army (ANLA)" // india mildly ethnic origins
ident 110 0 0 0 0 0 "Al-Faruo Battalion" // lebanon, unidentified
ident 92  0 1 1 2 1 "Al-Madina" // kashmiri islamic group
ident 83  3 0 0 1 1 "Anti-Communist Commando of the South" // guatemalan right-wing death squad
ident 186 3 0 0 1 1 "Anti-Communist Vigilante Group" // sri lanka
ident `cc' 0 0 0 0 0 "Anti-Government Rebels"
ident `cc' 1 0 0 1 1 "Anti-Imperialist International Brigades" // italy and indonesia
ident 110 1 0 0 1 1 "Arab Democratic Party" // lebanon
ident 155 0 1 1 2 1 "Arab Liberation Front (ALF)" // palestinian splinter group
ident 87  0 0 0 0 0 "Aristide supporters" // haiti
ident 98  1 0 0 1 1 "Armed Communist Nucleus" // all italian mini groups
ident 98  1 0 0 1 1 "Armed Fight for Communism"	
ident 98  1 0 0 1 1 "Armed Proletarian Groups for Communism"
ident 98  1 0 0 1 1 "Armed Struggle for Communism"
ident 98  1 0 0 1 1 "Armed Workers Squads"
ident 12  0 1 0 2 0 "Armenian militants" // armenia
ident 185 0 1 0 2 0 "Basque terrorists" // spain
ident 195 0 1 0 2 1 "Beja Congress" // east sudan militia + party
ident 217 2 0 0 1 1 "Black Afro Militant Movement" // us, miami, antiracist self-defense against police
ident 30  3 0 0 1 1 "Brazilian Anti-Communist Alliance (AAB)" // brazil
ident 36  1 0 0 1 1 "Cambodian People's Party (CPP)"
ident 87  0 0 0 0 1 "Cannibal Army" // haiti, w/o ideology, political struggle
ident 167 0 1 0 2 0 "Chechen rebels"
ident `cc' 0 0 2 3 0 "Christians"
ident 65  0 0 0 0 1 "Coalition for Unity and Democracy (CUD)" // ethiopian opposition party
ident 45  2 0 0 1 1 "Colombia Without Guerrillas" // paramilitary
ident 216 2 0 0 1 1 "Column 88" // neonazi paramilitary uk
ident 11  1 0 0 1 1 "11 Comite Argentino de Lucha Anti-Imperialisto" // argentina left
ident 45  2 0 0 1 1 "Commandos for A Popular alternative" // colombia paramilitary
ident 6   0 0 0 0 0 "Committee of Coordination" // Algeria unidentified
ident 217 0 0 2 3 1 "Covenant, Sword and the Arm of the Lord (CSA)" // christian sect us
ident 61  1 0 0 1 1 "Democratic Revolutionary Front (FDR)" // el salvador
ident 209 1 0 0 1 1 "Dev Yol"	// turkey
ident 45  2 0 0 1 1 "Dignity for Colombia" // paramilitary
ident 216 2 0 0 1 1 "Direct Action Against Drugs (DADD)" // uk paramilitary
ident 44  0 1 1 2 1 "Eastern Turkistan Islamic Movement (ETIM)" // muslim separatists in china
ident 65  1 1 0 2 1 "Eritrean Peoples Liberation Front" // eritrean separatists from ethiopia
ident `cc' 0 0 0 0 2 "Extortionists"
ident 110 0 0 0 0 0 "Forces of the Struggling Ranks" // lebanon unidentified
ident `cc' 0 0 0 0 2 "Gang"
ident 163 1 0 0 1 1 "Grupo Estrella" // puerto rico
ident 93  0 0 2 3 1 "Huria Kristen Batak Protestan (HKBP)" // protestant church indonesia
ident 147 1 1 0 2 1 "Ijaw militants" // anti-oil industry campaign in niger delta
ident `cc' 0 0 0 0 0 "Insurgents"
ident 95  0 0 0 0 0 "Iraqi Revolutionary Forces" // unidentified
ident 153 0 1 1 3 1 "Islambouli Brigades of al-Qa'ida" // pakistan, start says unlikely to having comitted all claimed attacks
ident 97  0 0 0 0 0 "Israeli Terrorist Group" // unidentified
ident 143 0 1 0 2 0 "Kanak Separatists" // new caledonia
ident 94  1 1 0 1 1 "Kurdish Democratic Party-Iran (KDP)" // iran socialist party
ident 217 3 0 0 1 1 "Latin America Anti-Communist Army (LAACA)" // us
ident 110 1 0 0 1 1 "Lebanese Socialist Revolutionary Organization" // lebanon
ident 43  1 0 0 1 1 "Milicias Rodriguistas" // chile
ident 145 3 0 0 1 1 "Miskito Indian Organization" // nicaragua, Linked to Contras
ident 147 0 1 0 2 0 "Modakeke Ethnics" // nigerian ethnic group involved in conflict
ident 138 0 1 0 2 0 "Mon Guerrillas" // New Mon State Insurgents, Myanmar, separatists
ident 205 0 0 1 3 1 "Mujahideen Islam Pattani" // thailand
ident 104 0 0 5 3 2 "Mungiki Sect" // kenya, animist criminal sect
ident 104 0 1 0 2 0 "Nandi Tribe" // kenyan tribe
ident 113 0 0 0 0 1 "National Front for the Salvation of Libya" // anti gaddafi opposition movement
ident 51  3 0 0 1 1 "National Integration Front (FIN)" // cuban anti-castro group
ident 213 0 0 0 0 1 "National Resistance Movement (NRM)" // ugandan political party
ident 218 0 0 0 0 0 "Nationalist Patriotic Alliance (APN)" // unidentified
ident 217 2 0 4 3 1 "New Jewish Defense League"	// us diaspora, debatable, ethnic, right wing
ident 69  2 0 0 1 1 "New Order- France" // far right movement
ident 217 4 0 0 5 1 "New Year's Gang" // one bombing opposing university role in vietnam war, us
ident 202 0 0 0 0 1 "People's Democratic Army" // tajikistan, military force, unidentified goals
ident 186 0 1 0 2 1 "People's Liberation Organization of Tamil Eelam" // sri lanka
ident 130 1 0 0 1 1 "People's Revolutionary Army (ERP) (Mexico)"	
ident 110 2 0 0 1 1 "Phalange" // lebanon right wing paramilitary, unofficially christian
ident 163 0 1 0 2 1 "Popular Liberation Army (Puerto Rico)" // independence from us
ident 78  1 0 0 1 0 "Popular Rage" // greece unidentified	
ident `cc' 0 1 0 2 0 "Pro-Palestinian Group" // unidentified
ident 163 1 0 0 1 1 "Provisional Coordinating Committee for the Defense of Labor" // puerto rico
ident 217 0 0 0 0 1 "Rajneeshees" // bioterrorist attack to promote own candidate in elections, us
ident 217 1 0 0 1 1 "Red Guerilla Family" // us anticapitalists
ident 69  2 1 0 2 1 "Resistenza Corsa" // france
ident 78  1 0 0 1 1 "Revolutionary Action of Liberation" // small leftist greece
ident 87  2 0 0 1 1 "Revolutionary Front for Hatian Advancement and Progress (FRAPH)" // far-right haiti paramilitary
ident 78  1 0 0 1 1 "Revolutionary Solidarity" // small leftist greece
ident 45  2 0 0 1 0 "Right-Wing Paramilitaries" // colombia
ident 75  1 0 0 1 1 "Robin Food" // germany, anti-nestle
ident 104 0 1 0 2 1 "Sabaot Land Defense Force (SLDF)" // kenya. militia, ethnicity based
ident 88  1 0 0 1 1 "Sandinist People's Army (EPS)" // honduras, govt army
ident 216 0 0 1 3 1 "Secret Organization of al-Qaida in Europe" // uk
ident 144 0 0 1 3 1 "September 11" // new zealand
ident 97  0 0 4 3 1 "Sicarii" // small jewish theocentric group
ident 186 0 1 0 2 1 "Sinhalese Militants" // sri lanka
ident 145 0 0 0 0 0 "Somozists" // nicaraguan pro-ex leader forces
ident 185 2 1 0 2 1 "Spanish Armed Group" // anti-basque anti-separatist, right spain
ident `cc' 0 0 0 0 0 "Student Demonstrators"
ident 49  1 0 0 1 0 "Student Front of the People" // costa rica unidentified
ident 98  0 1 0 2 1 "Sudtiroler Volkspartei-south tyrol people's party" // italy, mainstream regionalist party
ident 228 0 0 1 3 0 "Sympathizers of Al-Qa`ida Organization" // yemen
ident 155 0 1 0 2 1 "Tanzim" // Fatah-related guerilla arm, Palestine
replace gname="The Northern Alliance" if regexm(gname,"The Northern Alliance")==1
ident 4   0 0 0 0 1 "The Northern Alliance" // Afghanistan, anti-taliban, govt backed
ident 228 0 1 0 2 0 "Tribesmen Murad Tribe" // Yemen	
ident 222 1 0 0 1 1 "Tupamaro Revolutionary Movement" // venezuelan party
ident 209 0 1 1 2 1 "Turkish Hizballah"	// anti-pkk islamic
ident 213 0 0 0 0 0 "Ugandan Rebels" // in Uganda	
ident 42  0 0 0 0 1 "United Front for Democratic Change (FUC)" // chad, anti-govt rebels
ident 92  1 1 0 2 1 "United National Liberation Front (UNLF)" //	Manipur Peoples Army
ident `cc' 0 0 0 0 0 "Urban Guerrillas"
ident `cc' 0 0 0 0 0 "Villagers"
ident 231 0 0 0 0 0 "Zimbabwe Guerrillas" // unidentified
* groups with 3 attacks
ident 43  0 0 0 0 0 "14th of December Command" // chile	
ident 78  0 0 0 0 0  "7 April Libyan Organization" // greece unidentified
ident 4   0 1 0 2 0 "Afghan Rebels" // iran and afghanistan
ident `cc' 0 1 0 2 0 "Afghans"	// in Germany and Pakistan
ident 146 0 1 0 2 1 "Air and Azawak Liberation Front" // tuareg rebels
ident 92  0 0 1 3 1 "Al Jehad" // india
ident 153 0 1 1 2 1 "Al-Arifeen" // pakistan-kashmir
ident 173 0 0 1 3 1 "Al-Haramayn Brigades" // saudi arabia
ident 110 0 0 1 3 1 "Al-Sadr Brigades" // lebanon, anti-libya
ident 235 0 1 0 2 0 "Albanians"	// yugoslavia
ident 74  0 0 0 0 0 "Algeisk Wolves" // georgia group unidenitified
ident 217 3 0 0 1 1 "Anti-Castro Command"	// us exiles
ident 217 3 0 0 1 1 "Anti-Castro Group"	// us exiles
ident `cc' 3 0 0 1 0 "Anti-Environmentalist"	// unclear, rather right
ident `cc' 2 0 0 1 0 "Anti-Immigrant Activists" // to any country	
ident 75  1 0 0 1 1 "Anti-Imperialist Cell (AIZ)"
ident 94  0 0 0 0 0 "Anti-Revolutionary Agents" // iran
ident 78  1 0 0 1 1 "Anti-State Action" // greece
ident 98  2 0 0 1 0 "Anti-Zionist Commandos" // italy, 1976, unclear
ident 98  1 0 0 1 1 "Arab Revolutionary Cells"
ident 69  0 1 0 2 1 "Armata Corsa" // france
ident 98  1 0 0 1 1 "Armed Communist Struggle" // italy
ident 163 1 1 0 2 1 "Armed Forces of Popular Resistance (FARP)" // pueerto rico
ident 98  1 0 0 1 1 "Armed Nuclei for Territorial Counterpower" // italy
ident 98  1 0 0 1 1 "Armed Squads for Communism"  // italy
ident 359 0 1 0 2 0 "Armenian Nationalists" // su
ident 216 0 1 0 2 1 "Army for Freeing Scotland" // uk
ident 78  1 0 0 1 1 "Arsonists for Social Cohesion" // greece
ident 61  0 0 0 0 1 "Association of Demobilized Armed Forces" // el salvador
ident 43  1 0 0 1 1 "Autonomous Manuel Rodriguez Patriotic Front" // communist chile
ident 78  1 0 0 1 1 "Autonomous Resistance" // here greece
ident 94  0 1 0 2 0 "Autonomy-Seeking Arabs" // here iran
ident 185 2 1 0 2 1 "Basque Battalion" // spain, also france, anti-eta
ident 15  2 0 0 1 1 "Bavarian Liberation Army" // austria
ident 217 4 0 0 5 1 "Beaver 55" // us anti-war activists	
ident 93  0 1 0 2 1 "Besi Merah Putih Militia" // east timor pro-indonesia militia	
ident 359 0 0 0 0 1 "Black Berets" // KGB unit in SU, state terror, why listed?
ident 110 0 0 1 3 1 "Black Brigade" // lebanon, anti-lybia
ident 216 4 0 0 1 1 "Black Liberation Front" // uk, black nationalist militants, anti-capitalist, anti-racist
ident 217 1 0 0 1 1 "Black Revolutionary Assault Team" // us
ident 94  0 1 0 2 1 "Black Wednesday" // arabic autonomous in iran	
ident `cc' 0 0 0 0 0 "Blacks" // ? here south africa, anti-apartheid?
ident 183 2 0 0 1 1 "Boere Aanvals Troepe (BAT)" // racist south african
ident 216 0 1 2 2 1 "Catholic Reaction Force" // uk	
ident 69  2 0 0 1 1 "Charles Martel Group" // france racist
ident 185 0 0 0 0 0 "Christ Chaos" // unidentified spanish
ident 45  1 0 0 1 1 "Colombian Patriotic Resistance" // suspected eln, colombia	
ident 69  1 0 0 1 1 "Comite d'Action Viticole" // france, wine-grower guerillas
ident 69  0 0 0 0 0 "Commandos of France"	// france unidentified
ident 98  1 0 0 1 1 "Communist Group of Proletarian Internationalism" // italy
ident 30  2 0 0 1 1 "Communist Hunters Command (CCC)" // brazil
ident 141 1 0 0 1 1 "Communist Party of Nepal- Unified Marxist-Leninist (CPN-UML)" // nepal
ident 205 1 0 0 1 1 "Communist Party of Thailand"
ident `cc' 3 0 0 1 1 "Condor" // pinochet-led intl. anti-leftis alliance
ident 92  0 0 0 0 1 "Congress Party Activists" // india
ident 69  0 1 0 2 0 "Corsican Revolutionary Brigade"	// france, unknown
ident `cc' 0 1 0 2 0 "Croatians" // yugo and bosnia-herz.
ident 167 0 1 1 2 1 "Dagestani Shari'ah Jamaat"	 // russia
ident 45  2 0 0 1 1 "Death to Rustlers" // colombian paramilitary
ident 161 3 0 0 1 1 "December 13 Independent Group" // poland, anti-sowiet
ident 69  2 0 0 1 1 "Delta Group" // french in algeria
ident 60  0 0 0 0 0 "Egypt's Revolution" // conscription riot
ident 26  1 0 0 1 1 "Ejercito de Liberacion Nacional (Bolivia)"	
ident 217 4 0 0 4 1 "Enviromental Life Force" // green guerillas us
ident 76  0 0 0 0 1 "Farighan" // ghana, political strife
ident 155 1 1 0 2 1 "Fedayeen" // palestine separatists, secular, evtl. left?
ident 98  1 0 0 1 1 "Fire Group" // related to brigate rosse?
ident 60  0 0 1 3 1 "Forbid the Evil Group (Moslem Militants)"
ident 145 0 0 0 0 0 "Former Interior Ministry Officers" // nicaragua
ident `cc' 0 0 0 0 1 "Freedom Party" // pakistan and bangladesh
ident 56  0 1 0 2 1 "Front for the Liberation of the French Somali Coast" // djibouti
ident 163 0 1 0 2 1 "Front for the National Liberation of Puerto Rico" // puerto rico
ident 130 1 0 0 1 1 "Fuerzas Armadas Revolucionarias del Pueblo (FARP)" // mexico
ident 98  0 1 0 2 0 "German Speaking Separatists" // italy
ident 78  1 0 0 1 1 "Greek National Socialist Organization" // greece
ident 185 1 0 0 1 1 "Guerilla Party of the Galician Poor" // spain
ident 182 0 0 0 0 0 "Habr Gedir Clan" // somalian clan
ident `cc' 0 0 1 3 0 "Hanafi Muslims" // us
ident 153 0 0 1 3 1 "Harakat ul-Mujahidin (HuM)" // pakistan based
ident `cc' 4 0 0 4 0 "Human Rights Protesters"
ident 228 0 0 1 3 1 "Huthis" // Yemen,	Zaydi Rebels
ident 185 1 0 0 1 1 "Iberian Anarchist Federation" // spain
ident 209 2 0 0 1 1 "Idealist Association" // turkey right wing
ident 92  0 0 1 3 1 "Ikhwan-ul-Muslimeen" // muslim brotherhood, india
ident `cc' 1 0 0 1 1 "Internationalist Cells" // east germany
ident 219 0 0 1 3 1 "Islamic Jihad Group (IJG)" 
ident `cc' 0 0 1 3 0 "Islamic Mujahidin" // iraqi fighters but also from italy
ident 104 0 0 1 3 1 "Islamic Party of Kenya (IPK)" // kenya
ident 19  0 0 1 3 1 "Jadid Al-Qa`idah Bangladesh (JAQB)" // bangladesh
ident 4   0 0 1 3 1 "Jamiat-e Islami-yi Afghanistan"
ident 217 2 0 4 1 1 "Jewish Committee of Concern" // us
ident 92  1 0 0 1 1 "Jharkhand Liberation Tigers (JLT)" // maoists india
ident 213 0 0 0 0 0 "Karamojong Warriors" // uganda
ident `cc' 0 1 0 2 0 "Kurdish guerrillas" // turkey, iran
ident 45  1 0 0 1 1 "Latin American Anti-Fascist Command" // colombia
ident `cc' 1 0 0 1 0 "Left-Wing Workers" // turkey
ident 112 0 0 0 0 1 "Liberians United for Reconciliation and Democracy (LURD)" // militia in civil war, anti-govt
ident 113 0 0 0 0 0 "Libyan"
ident 113 0 0 0 0 0 "Libyan Commando Group" // unidentified
ident 97  2 1 4 1 1 "Likud Political Party" // israel
ident 141 0 1 0 2 1 "Madhesi Mukti Tigers (MMT)" // nepal
ident 92  0 0 1 3 1 "Mahaz-e-Inquilab" // india islamists
ident 83  1 0 0 1 1 "Mardoqueo Guardado Front" // guatemala
ident 11  1 0 0 1 1 "Mariano Moreno National Liberation Commando" // argentina
ident 104 1 0 0 1 0 "Maskini Liberation Front" // Kenya unidentified, maskini=poor
ident 95  0 1 0 2 1 "May 15 Organization for the Liberation of Palestine" // iraq-based (Start)
ident 45  0 0 0 0 2 "Medellin Drug Cartel" // colombia
ident 92  0 1 1 2 1 "Moslem Janbaz Force" // kashmir, india
ident 231 0 0 0 0 1 "Movement for Democratic Change (MDC)" // zimbabwe opposition party
ident `cc' 0 0 0 0 0 "Muslim Youth"
ident 42  0 0 0 0 1 "National Alliance (Chad)" // rebel group in power struggle
ident 61  2 0 0 1 0 "National Anti Communist Commando" // el salvador, unidentified
ident 186 2 1 0 2 1 "National Front Against Tigers (NFAT)" // sri lanka, anti-tamil
ident 34  0 1 0 2 1 "National Liberation Front (FNL) (Burundi)" // ethnic strife, burundi
ident 141 1 0 0 1 1 "National People's Movement Coordination Committee" // nepal party
ident 185 0 0 0 0 0 "National Revolution" // spain unidentified
ident 110 0 0 0 0 1 "National Revolutionary Command (Umar al-Mukhtar)" // lebanon, anti-us
ident 69  2 0 0 1 1 "Nationalist Intervention Group" // in france, potentially spaniards	
ident 26  1 0 0 1 1 "Nestor Paz Zamora Commission (CNPZ)" // bolivian
ident 147 0 1 0 2 1 "Niger Delta Vigilante (NDV)" // ethnic militant group, oil
ident 145 3 0 0 1 1 "Northern Diriangen Front (FND)" // nicaragua, recontras
ident `cc' 0 0 0 0 0 "Northern Terror Front" // dutch autonomes (anti-pope) & greek far right?
ident 78  1 0 0 1 1 "October-80"	// greece
ident 147 0 1 0 2 1 "Odua Peoples' Congress (OPC)" // ethnic militant group
ident 98  1 0 0 1 1 "Organized Comrades for Feminist Counter-Power" // italy
ident 98  1 0 0 1 1 "Organized Proletarian Communists" // italy
ident 156 0 0 0 0 1 "Panama Defense Force" // former military forces panama
ident 30  0 0 0 0 0 "Patria Nueva (New Country)" // brazil, unidentified
ident 98  1 0 0 1 1 "People's Liberation Movement" // italy
ident 59  1 0 0 1 1 "People's Revolutionary Militias (MRP)" // equador, anti-glob
ident 92  0 1 1 2 1 "People's United Liberation Front (PULF)" // islamist separatist india
ident `cc' 3 0 0 1 1 "Popular Anti-Communist Militias"
ident `cc' 0 0 0 0 0 "Pro-Iraqi Terrorists" // non
ident `cc' 0 0 0 0 0 "Pro-Kabul Provocateurs"
ident 209 0 0 0 0 0 "RYF"	// turkey
ident 61  0 0 0 0 0 "Raul Ernesto Cruz Leon, Salvadorian"
ident 98  1 0 0 1 1 "Red Flying Squad" // italy
ident 45  1 0 0 1 1 "Red Guard" // colombia
ident 142 4 0 0 1 1 "Revolutionary Anti-Racist Action" // dutch anti-racism group
ident 81  1 0 0 1 1 "Revolutionary Armed Organization" // guadeloupe
ident 49  1 0 0 1 1 "Revolutionary Commandos of Solidarity" // costa rica
ident 217 1 0 0 1 1 "Revolutionary Force 9" // us leftists
ident 162 1 0 0 1 0 "Revolutionary Internationalist Solidarity" // indeterminate anarchists
ident 130 1 0 0 1 1 "Revolutionary Student Front" // mexico
ident 130 1 0 0 1 1 "Revolutionary Worker Clandestine Union of the People Party (PROCUP)" //mexico
ident 26  1 0 0 1 1 "Revolutionary Workers Party of Bolivia (PRTB)" //bolivia
ident `cc' 2 0 0 1 0 "Right-Wing Militants" // japan, turkey
ident 146 0 1 0 2 1 "Saharan Revolutionary Armed Front (FARS)" // niger
ident 92  0 1 0 2 1 "Save Kashmir Movement" // india
ident 217 2 1 4 2 1 "Save Our Israel Land" // zionist, israel
ident 213 0 0 0 0 1 "Save Uganda Movement" // uganda opposition
ident `cc' 0 1 0 2 0 "Secessionists"
ident 217 2 0 0 1 1 "Secret Army Organization" // us
ident 101 2 0 0 1 1 "Seikijuku" //japan
ident 43  2 0 0 1 1 "September 11 Commandos" // chile
ident 235 0 1 0 2 0 "Serbian Nationalists" // yugoslavia
ident 97  0 1 4 2 0 "Settlers at Kfar Darom" // israel
ident 138 0 1 0 2 0 "Shan Insurgents" // myanmar
ident 138 0 1 0 2 1 "Shan State Army" // myanmar
ident 153 1 1 0 2 0 "Sindhi nationalists" // pakistan
ident 75  1 0 0 1 1 "Socialist Patients' Collective (SPK)" // germany
ident 6   0 0 0 0 0 "Soldiers of the Algerian Opposition" // algerian opposition
ident 183 4 0 0 1 1 "South African Liberation Support Cadre (SALSC)" // anti-apartheid
ident 195 0 0 0 0 1 "Sudan Alliance Forces" // militia
ident 195 0 1 0 2 1 "Sudan Liberation Movement" // militia
ident 78  0 0 0 0 0 "Suicide Squad" // greece
ident 60  0 0 1 3 1 "Takfir wal-Hijra (Excommunication and Exodus)" //egypt
ident 75  1 0 0 1 1 "Territorial Resistance Army" // germany
ident 93  0 1 0 2 0 "Timorese Students" // indonesia
ident 204 0 0 0 0 0 "Togolese Dissidents" // togo
ident 209 1 0 0 1 1 "Turkish Communist Workers Party" // turkey
ident `cc' 0 0 0 0 0 "Turks"
ident 19  0 0 1 3 1 "United Action Council" // bangladesh
ident 182 0 0 0 0 1 "United Somali Congress" // party&militia somalia
ident 217 2 0 0 1 1 "Vietnamese Organization to Exterminate Communists and Restore the Nation" // us
ident 75  1 0 0 1 1 "Waltraud Boock Group" // raf, germany
ident 167 0 1 0 2 1 "White Legion (Georgia)" // russia, abkhaz separatists
ident 98  1 0 0 1 1 "Worker Autonomy, Continuous Struggle" // italy
ident 78  0 0 0 0 0 "Yellow Organization of Air Force Officers" // unclear greece terror group
ident 94  1 1 0 2 1 "al-Ahwaz Arab People's Democratic Front" // iran arab separatists, operating from uk
ident 95  0 0 1 3 1 "1920 Revolution Brigades" // iraq
ident 209 0 1 0 2 1 "28 May Armenian Organization" // turkey
ident 185 0 0 0 0 0 "28th of December Group" // spain
ident 78  0 0 0 0 0 "4 August National Organization" // greece
ident 136 0 0 0 0 0 "Abd al-Krim Commandos" // to morocco, potentially separatist but unclear [AaK was anti-colonial fighter]
ident 45  0 0 0 0 0 "Abstentionist Brigades" // colombia
ident 142 2 0 0 1 1 "Actiefront Nationalistisch Nederland" // netherlands
ident 69  0 1 0 2 1 "Action Front for the Liberation of the Baltic Countries" // france
ident 228 0 0 1 3 1 "Adan Abyan Islamic Army (AAIA)" //yemen
ident 182 0 0 0 0 1 "Ahlu-sunah Wal-jamea (Somalia)" // somali militia
ident 155 0 1 0 2 1 "Ahrar Al-Jalil (Free People of the Galilee)" // palestine
ident `cc' 0 0 0 0 0 "Airport Protesters"
ident 92  0 0 5 3 1 "Akali Dal Party" // sikh party india
ident 98  0 1 0 2 1 "Al Borkan Liberation Organization" // italy anti-libya
ident 92  0 1 0 2 1 "Al Faran" // india/kashmir
ident 92  0 1 0 2 1 "Al Hadid" // india/kashmir
ident 92  0 1 1 2 1 "Al-Badr" // india/kashmir
ident 153 0 1 0 2 1 "Al-Nasireen Group" // pakistan/kashmir
ident 19  0 0 1 3 1 "Al-Qa'ida Network for Southwestern Khulna Division" // bangladesh
ident 200 0 1 0 2 1 "Al-Sa'iqa" // palestinian nationalist, created in Syria 
ident 228 0 1 0 2 1 "Al-Shabaab al-Mu'minin" // yemen, ethnic army
ident 26  0 0 0 0 2 "Alejo Calatayu" // bolivian narcoterror
ident 92  0 0 0 0 1 "All India Anna Dravida Munetra Kazgan Party" // indian party, mild center-left
ident 92  0 1 1 2 1 "Allah's Tigers" // india kashmir
ident 217 0 0 0 0 0 "Americans for Justice" // us, ?
ident 78  1 0 0 1 0 "Anarchist Faction" // november 19 faction, greece
ident 78  1 0 0 1 1 "Anarchist Solidarity" // greece
ident 145 0 0 0 0 2 "Andres Castro United Front" // post sandinista war army members, nicaragua
ident 98  1 0 0 1 1 "Angry Brigade (Italy)"
ident 216 1 0 0 1 1 "Angry Brigades" // anarchists uk
ident 216 4 0 0 4 0 "Animal Rights Militia" // uk
ident 153 0 0 1 3 1 "Ansar Wa Mohajir (Pakistan)"
ident 145 3 0 0 1 1 "Anti Communist Patriotic Front" // nicaragua
ident 98  1 0 0 1 1 "Anti Imperialistic Communist Revolutionaries" // italy
ident 69  0 1 0 2 1 "Anti-Armenian Organization" // france
ident 78  0 0 0 0 0 "Anti-Establishment Nucleus" // greece
ident 98  1 0 0 1 1 "Anti-Fascist Territorial Group" // italy
ident 98  1 0 0 1 1 "Anti-Imperialist Territorial Nuclei (NTA)" // italy
ident 209 0 2 0 2 1 "Anti-Kurdish Turks"
ident 101 0 0 0 4 0 "Anti-Narita Extremists" // anti-airport, japan
ident `cc' 0 0 0 0 0 "Anti-Socials"
ident 98  2 0 0 1 1 "Anti-Zionist Movement" // italian neonazis
ident 110 1 0 0 1 1 "Arab Socialist Baath Party" // syria based, here lebanon
ident 11  2 0 0 1 1 "Argentine National Organization Movement (MANO)" // argentine extreme right
ident 98  3 0 0 1 1 "Armed Commandos in the Fighting Army of Mario Zichieri" // anti-communists
ident 177 0 0 0 0 2 "Armed Forces Revolutionary Council (AFRC)" // rebel forces, sierra leone
ident 93  0 1 0 2 1 "Armed Forces for Liberation of East Timor (FALINTIL)" // indonesia
ident 98  1 0 0 1 1 "Armed Nuclei for Communism" // italy
ident 359 0 1 0 2 0 "Armenian Extremists" // separatists su
ident 118 0 1 0 2 1 "Army of the Republic of Ilirida" // macedonia
ident `cc' 0 0 0 0 0 "Arsonists"
ident `cc' 2 0 0 1 0 "Arya"
ident 98  2 0 0 1 1 "Aryan Brotherhood" // italy
ident `cc' 1 0 0 1 1 "Autonomen" // germanies
ident `cc' 0 0 0 0 0 "Autonomy Front" // unidentified netherlands
ident 97  2 1 0 1 1 "Avengers of the Infants" // israeli vigilantes
ident 92  0 0 0 0 1 "Bahujan Samaj Party" // party india
ident 19  1 0 0 1 1 "Bangladesh Road Transport Workers Federation" // bangladesh
ident `cc' 0 1 0 2 0 "Basque Militants" // spain or france
ident `cc' 0 1 0 2 0 "Basque guerrillas" // spain or france
ident 110 0 0 0 0 0 "Beirut Martyrs Forces Organization" // lebanon
ident 35  0 0 0 0 0 "Belarusian Liberation Army" //unidentified
ident 92  0 0 0 0 1 "Bharatiya Janata Party" // indian party
ident 217 0 0 0 0 0 "Black American Moslems"
ident 75  1 0 0 1 1 "Black Cells" // raf predecessor germany
ident 153 0 1 0 2 1 "Black December" // pakistan separatists anti-india
ident 45  2 0 0 1 1 "Black Flag (Bandera Negra)" // colombian vigilantes
ident 110 0 0 0 0 0 "Black Hand" // lebanon unknown
ident 110 0 0 0 0 0 "Black Lebanon" // lebanon unidentified
ident 97  0 1 0 2 1 "Black March" // palestinian
ident 69  1 0 0 1 1 "Black War" // france
ident 26  1 0 0 1 2 "Bolivian Luminous Path" // drug gang
ident `cc' 0 1 0 2 0 "Bosnian Serbs"
ident 153 0 0 1 3 0 "Brelvi Muslims" // here pakistan, indian sufis
ident 138 1 0 0 1 1 "Burma Communist Party" // myanmar, illegal
ident 45  0 0 0 0 2 "Cali Narcotics Cartel" // colombia
ident 36  2 0 0 1 1 "Cambodian Freedom Fighters (CFF)" // cambodia
ident 49  1 0 0 1 1 "Carlos Echeverria commando group" // costa rica
ident 88  2 0 0 1 1 "Central American Movement of Solidarity (MOSCA)"
ident 78  0 0 0 0 0 "Children of November" // unclear greek
ident 69  2 0 0 1 1 "Clandestini Corsi" // racist youth france
ident 45  2 0 0 1 0 "Cleansing Squad" // colombia
ident 186 0 1 0 2 1 "Colonel Karuna Faction" // separatist sri lanka
ident `cc' 0 0 0 0 0 "Columbia PM" // panama
ident 216 2 0 0 1 1 "Combat 18" // uk
ident 30  2 0 0 1 1 "Commando Delta" // brazil
ident 98  4 0 0 5 0 "Committee for Direct Action Against War" // italy, less known
ident 94  0 0 1 3 1 "Committee for the Safeguard of the Islamic Revolution" // iran
ident 98  1 0 0 1 1 "Communist Combat Unit" // italy
ident 98  1 0 0 1 1 "Communist Fighting Nuclei" // italy
ident 98  1 0 0 1 1 "Communist Front for Counterpower" // italy
ident 92  1 0 0 1 1 "Communist Party of India"
ident 92  1 0 0 1 1 "Communist Party of India- Marxist"
ident 92  1 0 0 1 1 "Communist Party of India- Marxist-Leninist"
ident 121 1 0 0 1 1 "Communist Party of Malaysia- Marxist-Leninist"
ident 98  1 0 0 1 1 "Communist Patrols for Counter Power" // italy
ident 98  1 0 0 1 1 "Communist Progress" // italy
ident 98  1 0 0 1 1 "Communists Fighting Imperialism and Armaments" // italy
ident 229 0 0 0 0 1 "Congolese National Movement- Lumumba (MNCL)" // DRC, zaire political party
ident 155 0 1 1 2 1 "Conqueror Army" // palestine
ident 217 1 0 0 1 1 "Continental Revolutionary Army" // us
ident 147 0 0 0 0 0 "Council for Popular Justice" // nigeria, political, unknown
ident 217 2 0 0 1 1 "Cuban Action" // us right wing
ident 216 4 0 0 4 1 "Dark Harvest" // uk green militants
ident 43  0 0 0 0 0 "Defenders of the Fatherland" // unidentified, chile
ident 146 0 1 0 2 1 "Democratic Front for Renewal (FDR)" // niger separatists
ident 63  0 1 0 2 1 "Democratic Movement for the Liberation of the Eritrean Kunamas (DMLEK)" // eritrea
ident 132 0 1 0 2 0 "Dnestr Republic Separatists" // moldova
ident 57  0 0 0 0 1 "Dominican Popular Movement (MPD)" // dominican party
ident 142 0 0 0 0 0 "Down with Lubbers" // anti-politician, netherlands
ident 6   0 0 1 3 1 "Draa El Mizan Seriat" // algerian islamists
ident 217 4 0 0 5 1 "East Coast Conspiracy to Save Lives" // anti-vietnam war
ident 147 0 1 0 2 1 "Egbesu Youths of the Bayelsa" // nigeria, oil conflict
ident 11  0 0 0 0 0 "Eva Peron Organization" // argentina, unclear
ident 110 0 0 1 3 1 "Fatah al Islam" // lebanon
ident 99  2 0 0 1 1 "Federation of Students and Scholars of Cote d'Ivoire (FESCI)" // ivory coast fascists
ident 98  1 0 0 1 1 "Fighters for Communism" // italy
ident 160 0 0 0 0 0 "Filipino Soldiers for the Country" // philippines unidentified
ident `cc' 0 0 0 0 0 "Former Govt. Troops" // nicaragua
ident 104 0 0 0 0 1 "Forum for the Restoration of Democracy-Kenya" // kenyan party
ident 130 1 0 0 1 1 "Francisco Villa People's Front" // mexico
ident 217 4 0 0 1 1 "Fred Hampton Unit of the People's Forces" // us
ident 45  1 0 0 1 1 "Free Fatherland" // colombian left
ident 110 0 0 0 0 0 "Free Nasserite Revolutionaries" // lebanon, unclear
ident 38  1 1 0 2 1 "Front de Liberation du Quebec (FLQ)" // canada
ident 8   0 1 0 2 1 "Front for the Liberation of Cabinda / Cabinda Armed Forces (FLEC-FAC)" // angola
ident 110 0 0 0 0 1 "Future movement (Lebanon)" // pol party
ident 217 4 0 0 4 1 "Gay Liberation Front" // us rights activists
ident 94  0 0 1 3 1 "Generation of Arab Fury" // iran organized backed kuwaiti extremists
ident 74  0 1 0 2 0 "Georgian Militants"
ident 74  0 1 0 2 0 "Georgian rebels"
ident 198 1 0 0 1 1 "Global Intifada" // sweden autonomous
ident 138 0 1 2 2 1 "God's Army" // myanmar christians
ident 104 0 0 0 0 0 "God's Oppressed Army" // kenya unclear
ident 78  1 0 0 1 1 "Greek Anarchists' Union"
ident 78  0 0 1 3 1 "Group for Martyred Isam as-Sartawi" // greece
ident 75  1 0 0 1 1 "Gruppe Haw Weg Den Scheiss" // german autonomen
ident 94  0 0 1 3 1 "Guardians of the Islamic Revolution" // iran
ident 94  0 0 1 3 1 "Guardsmen of Islam" // iran 
ident 83  1 0 0 1 1 "Guatemalan Communist Party"
ident 185 2 0 2 1 1 "Guerrillas of Christ the King" //spain
ident 156 0 0 0 0 0 "Gutierrez Gomez Resistance Group" // panama unclear
ident `cc' 0 0 1 3 1 "Hizb al-Tahrir al-Islami (HT)" // tajik, germany
ident `cc' 0 1 0 2 0 "Hutus Former Soldiers" // congo, kinshasa
ident 92  0 1 1 2 1 "Ikhwan Jammu and Kashmir" // pro govt militia
ident 110 0 1 0 2 1 "Independent Nasserite Movement" // lebanon pan-arab nationalist party
ident 168 0 1 0 2 0 "Inkotanyi" // rwanda, tutsi rebels
ident 98  1 0 0 1 1 "International Communist Group" // italy
ident 145 0 0 0 0 0 "International Mercenary Brigade" // nicaragua
ident 142 1 0 0 1 1 "Into the Blue Commando of the Revolutionary Cells" // anti-olympia
ident 94  0 0 0 0 0 "Iranian Extremists""
ident 95  0 0 1 3 1 "Iraq's Jihadist Leagues"
ident 95  1 0 0 1 1 "Iraqi Communists"
ident 95  0 0 0 0 1 "Iraqi Democratic Front" // pol. opposition
ident 95  0 0 1 3 1 "Iraqi Islamic Vanguards for National Salvation (IIVNS)" // resistance
ident 95  0 0 0 0 1 "Iraqi National Congress (INC)" // pol. opposition
ident 93  0 1 0 2 0 "Irian Jaya Rebels"
ident 93  0 1 0 2 0 "Irianese Tribesmen"
ident 123 0 1 1 2 1 "Islamic Arab Front of Azawad (FIAA)" // mali rebel group
ident 209 0 0 1 3 1 "Islamic Cause Organization" // turkey
ident `cc' 0 0 1 3 0 "Islamic Front" // in india
ident 209 0 0 1 3 1 "Islamic Movement Organization" // turkey
ident 219 0 0 1 3 1 "Islamic Movement of Uzbekistan (IMU)"
ident `cc' 0 0 1 3 0 "Islamic Revenge Organization" // in turkey
ident 4   0 0 1 3 1 "Ittehad-i-Islami" // afgh. 
ident 99  0 0 0 0 1 "Ivorian Popular Front" // pol. party
ident 95  0 0 1 3 1 "Jaish al-Ta'ifa al-Mansura" // iraq
ident `cc' 0 0 1 3 1 "Jamaa Al-Islamiya Al-Alamiya (World Islamist Group)" // unclear origin, in egypt
ident 100 1 0 0 1 1 "Jamaica Labor Party" // pol party
ident 69  0 0 0 0 0 "January 22"
ident `cc' 0 0 1 3 1 "Jaysh al-Muslimin (Army of the Muslims)" // neo-taliban, afghanistan, iraq
ident 92  0 1 0 2 1 "Jharkhand Tribal Forces" // india, separatists
ident 102 0 0 1 3 1 "Jordanian Islamic Resistance"
ident 102 0 0 0 0 0 "Jordanian Revolutionary and Military Committee (MOUAB)" // unclear origin
ident 45  0 0 0 0 0 "Jorge Eliecer Gaitan Nationalist Movement" // unidentified
ident 138 0 1 0 2 0 "Kachin Insurgents" // myanmar
ident 97  2 0 4 3 1 "Kahane Chai" // israeli racist, jewish religious
ident `cc' 0 1 0 2 0 "Kaka-Tribesmen" // turkey and pakistan
ident 153 0 1 0 2 0 "Kalpar Tribesmen" // pakistan
ident 177 0 1 0 2 0 "Kamajor Hunters" // sierra leone
ident 143 0 1 0 2 0 "Kanakas" // new caledonia
ident 92  0 1 0 2 1 "Karbi Longri National Liberation Front (KLNLF)" // indian separatists
ident 92  0 1 0 2 1 "Karbi National Volunteers (KNV)" // india
ident 138 0 1 0 2 1 "Karenni National Progressive Party" // myanmar
ident 101 1 0 0 1 1 "Katsuhisa Omori" // japan
ident 92  0 1 3 2 1 "Khalistan Zindabad (Long Live Khalistan)" // india
ident 92  0 1 0 2 1 "Khasi Students Union" // india
ident 36  0 0 0 0 2 "Khmer Bandits" // cambodia
ident 141 0 1 0 2 1 "Kirat Janabadi Workers Party" // nepal
ident `cc' 0 0 0 0 0 "Kolla Benjo Cruz Command" // unspecified, in bolivia
ident `cc' 0 1 0 2 0 "Koreans" // in China
ident 37  0 1 0 2 0 "Kotoko Tribal Group" // cameroon
ident 199 1 0 0 1 1 "Krause Group" // switzerland
ident 92  0 1 0 2 1 "Kuki Liberation Army (KLA)" // india
ident 92  0 1 0 2 1 "Kuki National Army (KNA)"
ident 92  0 1 0 2 1 "Kuki National Front (KNF)"
ident 92  0 1 0 2 1 "Kuki Revolutionary Army (KRA)"
ident `cc' 0 1 0 2 0 "Kurdish Protestors" // in western europe
ident 95  0 1 0 2 1 "Kurdistan Free Life Party" // iraq
ident 95  0 1 0 2 1 "Kurdistan National Union" // iraq
ident 153 0 0 1 3 1 "Lashkar-e-Omar" // pakistan
ident 101 1 0 0 1 1 "League of Communists" // japan
ident 175 0 1 0 2 1 "Liberation Army for Presevo, Medvedja and Bujanovac (Ushtria lirimtare e Preshevs, Medvegjs dhe Bujanocit - UCPMB)"
ident 113 0 0 0 0 0 "Libyan Students"
ident `cc' 0 0 0 0 0 "M-5" // in france
ident `cc' 0 0 0 0 0 "M-7" // in puerto rico
ident 217 2 1 4 1 1 "Maccabee Squad and the Shield of David" // us, politically extreme racist jewish group
ident `cc' 2 0 0 1 0 "Macoute sympathizers" // us-haiti
ident 141 0 1 0 2 1 "Madhesi Peoples Rights Forum (MPRF)" // nepal
ident 121 1 0 0 1 1 "Malaysian Communist Party" // malaysia
ident 43  1 0 0 1 1 "Manuel Gonzales Patriotic Front" // chile
ident 95  0 0 1 3 1 "Martyr Abu Ja'far Group" // iraqi opposition
ident 88  1 0 0 1 1 "Martyrs of La Talanguera" // honduras
ident 101 1 0 0 1 1 "Maruseido (Marxist Youth League)" // japan
ident 78  1 0 0 1 1 "May 98" // greece
ident `cc' 0 0 0 0 0 "Mercenaries"
ident 130 1 0 0 1 1 "Militant Peasants (NFI)" // mexico
ident `cc' 0 0 0 0 0 "Militants"
ident `cc' 0 0 0 0 0 "Miners"
ident 153 0 0 0 0 0 "Miscreants" // pakistan
ident 147 0 1 0 2 0 "Modakeke Ethnic Activists" // nigeria
ident 138 0 1 0 2 1 "Mong Thai Army (MTA)" // myanmar
ident 147 0 1 0 2 1 "Movement for Actualization of the Sovereign State of Biafra (MASSOB)" // nigeria
ident 42  0 0 0 0 1 "Movement for Democracy and Justice in Chad (MDJT)" // chad rebels
ident 94  0 0 1 3 1 "Movement of Islamic Action of Iraq" // iran
ident 222 1 0 0 1 1 "Movement of the Revolutionary Left (MIR) (Venezuela)" // venezuela
ident 137 0 0 0 0 0 "Mozambican Rebels"
ident 137 1 0 0 1 1 "Mozambique Liberation Front (FRELIMO)" // party mozambique
ident `cc' 0 0 1 3 0 "Mujahedeen Army" // iraq
ident 153 2 0 1 1 1 "Mutahida Majlis-e-Amal" // pakistan, ultra-conservative, theocratic
ident 104 0 0 0 0 1 "Mwakenya Dissident Movement" // kenyan opposition
ident 92  0 1 0 2 1 "Naga Students Federation" // india
ident 143 0 1 0 2 1 "National Committee Against Independence (CNCI)" // new caledonia
ident 217 4 0 0 1 1 "National Committee to Combat Fascism" // us black panther chapter
ident `cc' 0 0 0 0 1 "National Democratic Party" // cuba, bangladesh
ident 130 1 0 0 1 1 "National Independent Committee for Political Prisoners and Persecuted and Missing Persons" // mexico
ident 59  1 0 0 1 1 "National Liberation Army (Ecuador)"
ident 159 1 0 0 1 1 "National Liberation Army (Peru)"
ident 196 0 1 0 2 1 "National Liberation Union"
ident 45  1 0 0 1 1 "National Socialist Civic Workers Movement" // colombia
ident 36  0 0 0 0 1 "National United Front for an Independent, Neutral, Peaceful, and Cooperative Cambodia (FUNCINPEC)" // centre right party
ident 229 0 1 0 2 1 "Nationalist Integrationist Front (FNI)" // kongo rebels
ident 141 0 0 3 3 1 "Nepal Defense Army" // nepal
ident 98  2 0 0 1 1 "New Order" // italy
ident 98  1 0 0 1 1 "New Partisans Movement" // italy
ident 76  0 0 0 0 1 "New Patriotic Party (NPP)" // ghana party
ident 145 1 0 0 1 1 "Nicaraguan  Revolutionary Armed Force"
ident 145 0 0 0 0 0 "Nicaraguan Counter Revolutionaries (group unk)"
ident 147 0 1 0 2 1 "Niger Delta People's Volunteer Force (NDPVF)" // nigeria, oil
ident 61  2 0 0 1 1 "Organizacion Democratica Nacionalista (ORDEN)" // paramilitary el salvador
ident `cc' 4 0 0 5 1 "Organization for Preventing Spread of Nuclear Weapons" // germany and switzerland, left?
ident 155 0 1 1 2 1 "Organization of the Sons of Occupied Territories" // palestine based
ident `cc' 0 0 0 0 2 "Organized Crime"
ident 69  4 0 0 5 1 "Pacifist and Ecologist Committee" // anti-nuclear france
ident 110 0 1 0 2 0 "Palestinian/Lebanese nationalists"
ident `cc' 0 0 0 0 0 "Peasant protesters"
ident 186 0 0 0 0 1 "People's Alliance" // sri lankan party
ident 147 0 0 0 0 1 "People's Democratic Party (PDP)" // nigerian party
ident 92  1 1 0 2 1 "People's Liberation Army (PLA)" // indian separatists
ident 45  1 0 0 1 1 "People's Revolutionary Organization- Colombia (ORP)" // colombia
ident 69  0 0 0 0 1 "Pessach Group" // unclear orientation, anti-syria, pro-jewish & christian, in france
ident 161 0 0 0 0 0 "Polish"
ident 130 1 0 0 1 1 "Poor People's Party" // mexico
ident 155 0 1 1 2 1 "Popular Army Vanguards- Battalions of Return" // palestine
ident 43  2 0 0 1 1 "Popular Militia (Chile)"
ident 8   0 1 0 2 1 "Popular Movement for the Liberation of Cabinda" // angola
ident 78  1 0 0 1 1 "Popular Resistance (Laiki Antistasi)" // greece
ident 78  1 0 0 1 1 "Popular Resistance Sabotage Group" // greece
ident 45  1 0 0 1 1 "Popular Revolutionary Commandos" // colombia
ident 98  1 0 0 1 1 "Popular Revolutionary Movement (Italy)" // italy
ident `cc' 0 0 0 0 0 "Pro-Government Students"
ident 167 0 1 0 2 0 "Pro-Khasbulaton Rebels" // chechnya
ident `cc' 0 1 0 2 0 "Pro-Palestinian Immigrants" // in belgium
ident `cc' 0 0 0 0 2 "Professional Killers"
ident `cc' 1 0 0 1 1 "Proletarian Action Group" // italy, germany
ident 98  1 0 0 1 1 "Proletarian Combatants for Communism" // italy
ident 98  1 0 0 1 1 "Proletarian Nuclei for Communism" // italy
ident 21  1 0 0 1 1 "Proletarian Revolutionary Action Front (FRAP)" // belgium
ident 163 0 1 0 2 1 "Puerto Rican Liberation Front"
ident 59  1 0 0 1 1 "Puka Inti Maoist Communist Party" // ecuador
ident 217 0 0 0 0 0 "Quartermoon society" // unidetified
ident 92  2 0 3 1 1 "Rashtriya Swayamsevak Sangh" // india
ident 185 0 1 0 2 1 "Red Army for the Liberation of Catalonia" // spain
ident 43  1 0 0 1 1 "Red Dawn Front (Frente Amanecer Rojo)" // chile
ident 142 1 0 0 1 1 "Red Revolutionary Front" // netherlands
ident 63  0 1 0 2 1 "Red Sea Afar Democratic Organization (RSADO)" // eritrea
ident 217 0 1 0 2 1 "Republic of New Afrika" // us
ident 98  1 0 0 1 1 "Revolutionary Action Front" // italy
ident 110 0 1 0 2 1 "Revolutionary Action Organization of the Arab Resistance Front" // lebanon
ident 217 0 0 0 0 0 "Revolutionary Action Party" // us unclear
ident 78  1 0 0 1 1 "Revolutionary Anti-Capitalist Initiative" // greece
ident 83  1 0 0 1 1 "Revolutionary Armed Forces (FAR)" // guatemala
ident 98  1 0 0 1 1 "Revolutionary Communist Party" // italy
ident 186 0 1 0 2 1 "Revolutionary Eelam Organization (EROS)" // sri lanka
ident 217 0 0 0 0 0 "Revolutionary Force 26" // us unidentified
ident 75  1 0 0 1 1 "Revolutionary Peoples Army" // germany
ident 199 1 0 0 1 1 "Revolutionary Perspective" // anti-global.
ident 98  1 0 0 1 1 "Revolutionary Proletarian Initiative Nuclei (NIPR)" // italy
ident 155 0 1 0 2 1 "Revolutionary Security Apparatus" // palestine, fatah body
ident 159 1 0 0 1 1 "Revolutionary Vanguard" // peru marxist party
ident 61  1 0 0 1 1 "Revolutionary Voice of the People (VPR)"
ident `cc' 2 0 2 3 0 "Right Wing Christian extremists"
ident `cc' 2 0 0 1 0 "Right-Wing Gunmen"
ident `cc' 2 0 0 1 0 "Right-Wing Rebel Military Group"
ident `cc' 2 0 0 1 0 "Right-wing Terrorists"
ident 202 0 0 1 3 1 "Rizvon Sadirov Group" // tajikistan
ident 75  1 0 0 1 1 "Rote Zora" // germany
ident 213 0 1 0 2 0 "Rwenzururu Rebels" // uganda
ident `cc' 0 0 0 0 0 "SYS"
ident 61  1 0 0 1 0 "Salvadoran Guerrillas" // el salvador
ident 205 0 1 1 2 1 "Sanidila Secessionist Movement" // thailand
ident 216 1 1 0 2 1 "Saor Eire (Irish Republican Group)" // uk
ident 92  0 0 0 0 0 "Scooter Borne terrorists" // india
ident 216 0 1 0 2 1 "Scottish Socialist Republican League" // uk
ident 217 2 0 0 1 1 "Secret Organization Zero" // us
ident 101 2 0 0 1 1 "Sekihotai" // japan
ident `cc' 0 1 0 2 0 "Serbian irregulars"
ident `cc' 0 1 0 2 0 "Serbian rebels"
ident 92  0 1 5 3 0 "Shahid Khalsa Force" // india, khalistan, sikh secessionism, unclear
ident 153 0 0 1 3 1 "Sipah-I-Mohammed" // pakistan
ident 69  1 0 0 1 1 "Solidarist Resistance Movement" // france maoists
ident 78  1 0 0 1 1 "Solidarity with imprisoned members of Action Directe (AD)" // greece
ident 182 0 0 0 0 1 "Somali National Alliance" // somali military
ident 217 2 0 0 1 1 "Sons of Liberty" // us
ident 216 0 1 0 2 1 "South Londonderry Volunteers (SLV)" // uk, northern ireland
ident 130 1 0 0 1 1 "Southern Sierra Peasant Organization" // mexico
ident 6   0 0 1 3 1 "Squadrons of Terror (Katibat El Ahoual)" // algeria
ident 159 1 0 0 1 1 "Struggle Against Misery and Exploitation of Peasants" // peru
ident 217 1 0 0 1 1 "Students for a Democratic Society" // us
ident 92  1 0 0 1 1 "Supporters of leftist Gana-Oikya Front" // india
ident 196 0 1 0 2 0 "Surinamese Amerindians" // suriname
ident 185 1 0 0 1 1 "Syndicalist Action Groups"
ident `cc' 0 0 0 0 0 "Syrians"
ident 92  0 1 0 2 1 "Tamil Liberation Army" // india
ident 186 0 1 0 2 1 "Tamil Makkal Viduthalai Pulikal (TMVP)" // sri lanka
ident 92  0 1 0 2 1 "Tamil Nadu Liberation Army" // india
ident 153 0 0 1 3 1 "Tehreek-e-Nafaz-e-Shariat-e-Mohammadi (TNSM)" // pakistan
ident 92  0 1 1 2 1 "Tehrik al-Mojahedin" // india
ident 141 0 1 0 2 1 "Terai Cobra" // nepal
ident 110 0 0 0 0 0 "The Eradication of Evil" // lebanon
replace gname ="The Front for the Liberation of the Cabinda Enclave" if regexm(gname,"The Front for the Liberation of the Cabinda Enclave") 
ident 8   0 1 0 2 1 "The Front for the Liberation of the Cabinda Enclave" // angola
ident 217 2 0 0 1 1 "The Order II (Bruder Schweigen Strike Force II)" // us
ident 217 0 0 0 0 0 "The Scorpion" // us
ident 25  0 0 0 0 0 "The United Revolutionary Front of Bhutan" // bhutan unclear
ident 93  0 1 0 2 0 "Timorese guerrillas" // indonesia
ident 58  0 0 0 0 0 "Tony El Pelou Band" // dominican rep.
ident `cc' 0 1 0 2 0 "Tribal Separatists"
ident 110 0 0 1 3 1 "Tripoli Martyrs Battalion" // lebanon
ident 44  0 1 1 2 1 "Turkestan Islamic Party" // china
ident 209 0 1 0 2 0 "Turkish separatists (probably Kurds)"
ident 98  0 1 0 2 0 "Tyrol Separatists" // italy
ident 92  0 1 1 2 0 "U/I Islamic Separatists" // india
ident 155 0 1 1 2 1 "Umar al-Mukhtar Martyr Forces" // palestine
ident 197 0 0 0 0 1 "Umbane People's Liberation Army (Swaziland)" // military wing of opposition party
ident `cc' 1 0 0 1 0 "Union members"
ident 42  0 0 0 0 1 "Union of Forces for Democracy and Development (UFDD)" // chad rebels
ident 183 4 0 0 1 1 "United Democratic Front (UDF)" // south africa, anti-apartheid coalition
ident 112 0 0 0 0 1 "United Liberation Movement for Democracy in Liberia (ULIMO)" // liberian rebels
ident 186 0 0 0 0 1 "United National Party" // sri lanka
ident 88  1 0 0 1 1 "United Revolutionary Front" // honduras
ident 142 0 0 0 0 0 "Universal Liberation Front" // netherlands
ident 217 0 0 0 0 0 "Universal Proutist Revolutionary Federation" // unclear
ident 220 2 0 0 1 1 "Vanuatu Mobile Force (VMF)" // vanuatu
ident 217 0 0 0 0 0 "Vietnamese Refugees" // us
ident 138 0 0 0 0 1 "Vigorous Burmese Student Warriors" // anti-govt
ident `cc' 0 0 0 0 0 "White Mercenaries"
ident 98  1 0 0 1 1 "Worker Counterpower" // italy
ident 98  1 0 0 1 1 "Workers' Organization for Communism" // italy
ident 145 0 1 0 2 1 "Yatama" // nicaragua indigenous party
ident `cc' 0 0 0 0 0 "Yemenis"
ident 110 0 0 1 3 1 "Youths of Ali Movement" // lebanon
ident 403 0 1 0 2 1 "Zimbabwe People's Army (ZIPA)" // rhodesia
ident 153 0 0 1 3 1 "al-Intiqami al-Pakistani" // pakistan
ident `cc' 0 0 0 0 0 "combat territory groups"
ident `cc' 0 0 0 0 0 "pro-iranian terrorists"
ident `cc' 0 0 0 0 0 "pro-pakistani militants"
ident `cc' 0 0 0 0 0 "unidentified men but 2 detained as tried to flee"
ident `cc' 1 0 0 1 0 "unknown leftists opposed to summit"

* Groups with only 1 incident, ordered by no. killed
ident 42  0 1 0 2 0 "Dissident Military Mmbrs of Northern Tribal Group" // chad
ident 167 0 1 1 2 1 "The 29th Division" // russia
ident 65  0 1 0 2 1 "Issa and Gurgura Liberation Front" // ethiopia, later somali party
ident 60  0 0 1 3 1 "Al-Qa`ida in Levant and Egypt" // egypt
ident 104 0 1 0 2 0 "Toposa and Dongiro Tribes" // kenya
ident 147 0 1 0 2 0 "Effiat ethnic roup or Jbibio Peoples" // nigeria
ident 95  0 0 1 3 1 "Sunni Supporters" // iraqi group
ident 8   0 0 0 0 0 "Angolan Defense Force" // angola
ident 65  0 1 0 2 0 "Amhara tribal group" // ethiopia
ident 95  0 1 0 2 0 "Anti Kurdish Workers Party Iraq nationals" // iraq
ident 167 0 1 1 2 1 "Black Widows (Chechen)" // russia
ident 110 2 0 2 1 1 "Revolutionary Christians of the Cedars" // lebanon, ultra-right christian
ident 50  0 1 0 2 0 "Croatian Militia" // croatia
ident 95  0 1 0 2 1 "Iraqi Liberation Army" // iraqi kurds
ident 208 0 0 0 0 1 "Tunisian Armed Resistance" // tunisia, anti-govt
ident 42  0 0 0 0 0 "Coup Plotters Against the Government" //chad
ident 146 0 1 0 2 1 "Popular Front for the Liberation of the Sahara" // niger, tuaregs
ident 104 0 1 0 2 0  "Sabaot tribesmen" // kenya
ident 110 0 1 0 2 0 "Ahmad Jibril" // lebanon, palestine separatist
ident 229 0 1 0 2 0 "Banyamulenge rebels" // congo, drc, zaire
ident 92  0 1 0 2 0 "Kuki Tribal Militants" // india
ident 83  0 0 0 0 0 "Peasant Militants" // guatemala
ident 168 0 0 0 0 0 "Unidentified Infiltrators" // rwanda
ident 8   0 0 0 0 0 "Angola Rebels" // angola
ident `cc' 0 0 1 3 0 "Jihadist Soldiers" // iraq
ident 95  0 0 1 3 1 "Jund al-Sahabah Group" // iraq
ident 160 0 0 0 0 0 "Angels" // philippines
ident `cc' 0 0 0 0 0 "Anti-government rioters"
ident 183 0 0 0 0 1 "South African Commandos" // south africa, army
ident 229 0 0 0 0 1 "Congolese Liberation Party (PLC)" // drc opposition party
ident 213 0 0 0 0 1 "Ugandan People's Democratic Army" // rebel army
ident 11  1 0 0 1 1 "Popular Resistance Front (FPR)" // argentina
ident 110 0 0 0 0 0 "Revolutionary Liberation Cells against Syrian Impe" // lebanon
ident 95  0 0 1 3 1 "Armed Vanguards of a Second Mohammed Army" // iraq
ident 186 2 0 0 1 1 "Flying Eagles (Vigilante Group)" // sri lanka
ident 110 0 0 1 3 0 "Khalid ibn Walid" // lebanon, name of Muhammad's companion
ident 222 0 0 0 0 2 "Venezuela Cartel" // venezuela drugs
ident 186 0 1 0 2 0 "Sinhalese Insurgents" // sri lanka
ident .   0 0 1 0 0 "Ansar Allah" // unsolved case
ident 110 0 0 1 3 1 "Islamic Unification Movement" // lebanese
ident 149 0 0 0 0 0 "North Korean involvement commandos" // in n.korea
ident `cc' 0 1 0 2 0 "Zulu Militants"
ident 168 0 1 0 2 0 "Rastas" // rwanda militia
ident 42  0 0 0 0 1 "Committee for a National Drive for Peace and Democracy" // chad rebels
ident 4   0 0 0 0 0 "Kabul Government Agents" // afghanistan
ident 159 3 0 0 1 0 "Peru's Anti-Terrorist Command" // unidentified
ident 42  0 1 0 2 1 "Union of Chadian Forces (UFNT)"
ident 74  0 1 0 2 0 "Abkhazian guerrillas" // georgia
ident 47  0 0 0 0 0 "Congolese Armed Patriotic Group" // congo brazzaville
ident 95  0 0 0 0 1 "Diyala Salvation Council" // iraq
ident 200 0 0 1 3 1 "Islamic Movement for Change" // syria
ident 167 0 1 1 2 1 "Riyad us-Saliheyn Martyrs' Brigade" // russia
ident 4   0 1 0 2 0 "Shinwari Tribe"
ident 195 0 0 0 0 1 "Sudanese Alliance Forces" // sudan
ident 6   0 0 1 3 1 "Tayeb Al-Afghani's Islamist Group" // algeria
ident 92  0 1 1 2 1 "United Jihad Council" // india
ident 61  3 0 0 1 0 "Bloque Anti-Guerrillero de Oriente (BAGO)" // el salvador
ident 209 0 1 0 2 0 "Hamawand Tribe" // kurdish tribe in turkey
ident 113 2 1 0 1 1 "Islamic Legion" // lybian pan-arab supremacist
ident 147 0 1 0 2 1 "Movement for the Actualization of the Sovereign State of Biafra (MASSOB)" // nigeria
ident 147 0 1 0 2 1 "The Joint Revolutionary Council" // nigeria
ident 147 0 0 0 0 1 "United Front for Nigeria's Liberation (UFNL)" // nigerian opposition
ident `cc' 0 0 0 0 0 "Attempted Coup"
ident 147 0 1 0 2 0 "Hauso Ethnic Group" // nigeria
ident `cc' 0 0 0 0 0 "Vilcashuaman Mil. Detachment" // peru
ident 229 0 1 0 2 0 "Zairian Dissidents" // mozambique
ident 229 0 1 0 2 1 "Bunda Dia Kongo (BDK)" // drc
ident `cc' 0 1 0 2 0 "Faqra Tribal Group" // here yemen, tribe of same name in pakistan exists
ident `cc' 0 1 0 2 0 "Foibe tribe" // unclear tribe in cameroon
ident 94  0 0 1 3 1 "Jihadi Movement of the Sunna People of Iran" // iran
ident `cc' 0 0 0 0 0 "Pakistani trained terrorists" // here india
ident 153 0 1 0 2 1 "Baluchistan National Army" // pakistan sep.
ident `cc' 2 0 0 1 0 "Black African Vigilantes"
ident 45  3 0 0 1 1 "Commander Luciano Varela Antiguerrilla Group" // in colombia, unclear
ident 167 0 1 1 2 1 "Doka Umarov's group" // chechen
ident 6   0 0 1 3 1 "Movement of the Islamic State (MEI)" //algerian civil war
ident 60  0 0 0 0 0 "Organization for the oppresed in Egypt's Prisons" // egypt, unidentified
ident 209 0 1 0 2 0 "Soskan tribe" // tribal kurdish violence in turkey
ident 167 0 1 0 2 1 "Checheno-Ingush Guerrilla Movement"
ident `cc' 2 0 0 1 0 "Extremist Nat'list Group"
ident 147 0 1 0 2 0 "Itsekiri" // nigeria
ident 147 0 1 0 2 0 "Katap Ethic Group" // tribe in nigeria
ident `cc' 0 0 0 0 0 "Rival clan"
ident `cc' 0 0 0 0 0 "U/I Private army of wral politician"
ident `cc' 0 1 0 2 0 "Ujjan Tribe" // ujjain, indian region, origin of a punjabi tribe? attack in pakistan
ident 45  3 0 0 1 1 "Civil Association for Peace in Colombia, Asocipaz" // colmbia, anti-marxist local self-defense
ident `cc' 0 0 1 3 0 "Moslem opponents of Gemayel"
ident 93  0 1 0 2 1 "National Council of Maubere Resistance" // east timor
ident 182 0 0 0 0 0 "Sa'ad Militia" // somalia
ident 153 0 0 0 0 0 "Tanzeem Ittehad - I - Ulema Qabail (Tiuq)Tribesmen" // pakistan, local ruling party
ident `cc' 0 1 0 2 0 "Tribal guerrillas" // india
ident 92  0 1 0 2 1 "Al-Shuda Brigade" // india kashmir, less known
ident 153 0 0 1 3 1 "Ansarul Islam (Pakistan)"
ident 138 0 1 1 2 1 "Arakan Rohingy Islamic Front"
ident 94  0 1 0 2 1 "Arbav Martyrs of Khuzestan" // iran
ident `cc' 0 0 2 3 0 "Evangelical Christians"
ident 130 0 0 0 0 2 "Gulf Cartel" // mexico, drugs
ident `cc' 0 1 0 2 0 "Kurdish Oppositionists"
ident 119 1 0 0 1 1 "Militant Movement for Madagascan Socialism (MMSM)"
ident `cc' 0 0 1 3 0 "Mujahedeen Group"
ident `cc' 1 0 0 1 1 "People's Guerrilla Front" // more than one
ident `cc' 0 0 0 0 0 "Supporters Opposition Leader Etienne Tshisekedi"
ident 4   0 0 0 0 0 "Afghan Merceneries"
ident `cc' 0 1 0 2 0 "Banya Tribe"
ident 21  0 0 0 0 0 "Crazy Brabant Killers" // unclear, belgian
ident `cc' 0 0 0 0 0 "Habi's Er'roub seriat" // algeria
ident 45  2 0 0 1 1 "Macetos (Paramilitary Group)" // colombia
ident 4   0 0 0 0 0 "Rival Afghan Group"
ident 4   0 0 0 0 0 "Afghan Agents"
ident `cc' 0 1 0 2 0 "Anti Turkish Group" // attack in australia
ident 92  0 1 5 3 1 "Babbar Khalsa" // sikh nationalists, secessionists
ident 45  2 0 0 1 1 "Colombian Revolution"
ident 83  2 0 0 1 1 "Death Squad of Organization Zero (Organizacion Cero)" // guatemala paramilitary
ident `cc' 2 0 0 1 1 "Extreme Right Commando Brigade" // here El Salvador, 61
ident `cc' 0 0 0 0 0 "Local Residents"
ident 92  1 0 0 1 1 "Maoist Farm Laborers Struggle Committee (MXSS)" // india
ident 61  2 0 0 1 1 "National Republican Alliance Party" // el salvador right wing
ident 209 0 1 0 2 1 "The Unit of the Chemical Weapons Martyrs" // kurds turkey
ident 160 0 1 0 2 0 "Tulawie Clan" // philippines, ethnic-nationalist
ident 19  1 0 0 1 1 "United Students Forum" // bangladesh, anti-right
ident 138 0 1 0 2 1 "United Wa State Army" // myanmar
ident `cc' 0 0 0 0 0 "unk masked raiders"
ident 183 0 1 0 2 0 "Xhosa Tribal Workers" // south africa
ident 110 0 0 0 0 1 "14 March Coalition" // lebanon
ident 92  0 1 0 2 1 "Achik National Volunteer Council (ANVC)" // india
ident 155 0 1 1 2 1 "al-Nadir" // palestine
ident `cc' 0 1 0 2 0 "Dnester region guerrilas" // here to Moldova
ident 6   0 0 1 3 1 "Ed'daoua Es'salafia Lilqadha" // algeria
ident 60  0 0 0 0 0 "Egyptians" // in philippines
ident 110 0 0 1 3 1 "Faithful Resistance" // lebanon
ident 153 0 0 1 3 1 "Fedayeen Imam Mahdi" // pakistan
ident 160 1 0 0 1 1 "Filipino Communists"
ident 110 0 0 2 3 1 "Free Revolutionaries Movement-The Giants" // lebanon
ident 160 0 0 2 3 1 "God our Father Cult"
ident `cc' 0 0 0 0 0 "Gun runners"
ident `cc' 0 0 0 0 0 "Islamic Companies"
ident 182 0 1 0 2 0 "Matan Abdulle" // somali clan leader
ident 167 0 1 1 2 1 "Mujahedeen of the Lechi Dudayev subunit" // russia, chechnya
ident 153 0 0 0 0 0 "Pakistan Muslim League (PML)" // pakistani party
ident 217 0 0 2 3 1 "People's Temple" // us pentecoastal church
ident 213 0 0 0 0 1 "Popular Resistance Army (PRA)" // uganda, rebel group
ident `cc' 0 0 0 0 0 "Relatives of Dead Cop"
ident `cc' 0 0 0 0 2 "Smugglers and Elephant Poachers"
ident 104 2 0 0 1 1 "Sungu Sungu" // vigilante group
ident `cc' 0 1 0 2 0 "Tribal Clash"
ident 112 0 1 0 2 0 "U/I Liberians"
ident 173 1 0 0 1 1 "Union of the Peoples of the Arabian Peninsula" // socialist saudi
ident `cc' 0 0 0 0 0 "Armed Subversives"
ident 123 0 0 0 0 0 "Black Malian Group"
ident 72  0 0 0 0 1 "Convention of Liberal Reformers (CLR)" // gabon party
ident `cc' 0 1 0 2 0 "Dioulas tribal group" // here senegal, west-african tribe in several countries
ident 88  2 0 0 1 1 "Elements Police Cobra Squadron" // honduras, counter-terrorists
ident 159 2 1 0 1 1 "Etnocacerista Movement" // peru
ident 74  0 0 0 0 0 "Georgian Sabotage Group" // in georgia
ident 217 0 0 0 0 1 "Hector Rio De Brigade" // haiti from us, anti-govt
ident 92  0 1 0 2 1 "Jatav Caste" // india
ident 217 1 0 0 1 1 "Jonathan Jackson Brigade"
ident 130 0 1 0 2 1 "Justice Army for Defenseless Peoples" // mexico, pro-indigenous
ident 92  0 1 0 2 1 "Kamtapur Liberation Organization (KLO)" // here india
ident 104 0 1 0 2 0 "Kisii Activists" // kenyan tribe
ident 93  0 0 1 3 1 "Komando Jihad (Indonesian)"
ident 209 1 1 0 2 0 "Kurdish Marxist Separatists"
ident 110 0 0 2 3 1 "Lebanese Free Will Movement" // pentecoastal
ident 92  1 0 0 1 1 "Mazdoor Kisan Sangram Samiti (MKSS)"
ident 92  0 1 0 2 0 "Meitei extremists"
ident 130 1 0 0 1 1 "Movement for Triqui Unification and Struggle" // mexico
ident 137 2 0 0 1 1 "Mozambique Rightest Rebels"
ident `cc' 2 0 0 1 0 "nationalist students"
ident `cc' 0 0 0 0 0 "Rival peasant band"
ident 69  4 0 0 4 1 "S. O. S. France" // anti-racists
ident 160 2 0 2 3 1 "Sagrado Corazon Fanatic Group" // philippines, christian cult known tadtad, vigilante, antileft
ident 182 0 0 0 0 0 "U/I  Somali Militiamen"
ident 112 0 0 0 0 0 "U/I Liberian Gunmen"
ident 213 0 0 0 0 1 "UNLF (Uganda National Liberation Front)"
ident 147 0 0 1 3 1 "Al-Sunna wal Jamma" // nigeria, extremist islam
ident 362 0 0 0 0 1 "Anti-American Arab Liberation Front" // attack on us soldiers in west germany, potentially by lybian government
ident 113 0 0 0 0 0 "Arab Commando Cells" // in lebanon, likely sponsored by lybia, formed for one attack only
ident  .  0 1 0 2 1 "Arab Steadfastness Front" // in protest to egypt's stance on israel, nationality, by libya, syria, algeria, south yemen, plo, country of origin cannot be identified
ident `cc' 0 1 0 2 0 "Arab Struggle"
ident 167 0 1 0 2 1 "Armed Forces of the Chechen Republic of Ichkeria"
ident 19  1 0 0 1 1 "Bangladesh Communist Party"
ident  92 0 0 0 0 0 "Bhumi Uchched Pratirodh Committee (BUPC)" // india, land eviction resistance, multi-party, anti-industry, attacking the ruling marxist party
ident 160 0 0 0 0 2 "Bodyguards of Muslim Warlord Governor Tupay Loong" // philippines
ident 95  0 0 1 3 1 "Brigades of Iman Hassan-al-Basri" // iraq
ident 41  0 0 0 0 1 "Central African National Liberation Movement" // pol. opposition
ident 186 0 1 0 2 1 "Citizens Volunteer Force" // sri lanka, anti-tamil army
ident 97  2 1 4 2 1 "Gilad Shalhevet Brigades" // izrael, extremist anti-palestinian
ident 153 0 0 1 3 1 "Harakat ul-Mujahidin Al-Almi" // pakistan
ident 155 0 1 1 2 1 "Hizballah Palestine"
ident 160 0 0 5 3 1 "H-World/Heavenly Group" // Philippines religious cult
ident 228 0 0 1 3 1 "Islamic Jihad Organization (Yemen)"
ident 101 1 0 0 1 1 "Japan Socialist Youth League of the Revolutionary Workers' Association"
ident 97  0 1 1 3 1 "Jerusalem Groups Hebrew (Qvutzot Yerushalayim)" // fatah- and jihad-close, unknown group
ident 36  3 0 0 1 1 "Kampuchean Peoples National Liberation Army" // KPLNF, KPLNAF, anti-communists 
ident 149 0 0 0 0 0 "Kim Pyongnil Supporters" // half brother of Kim Jong-il
ident 110 0 0 0 0 0 "Lebanese Resistance Group"
ident `cc' 0 1 0 2 0 "Maasai"
ident 141 0 0 0 0 1 "Nepali Congress Party (NC)"
ident 160 0 0 0 0 2 "Pentagon Kidnap Group" // philippines, criminal
ident 147 0 2 0 2 0 "People's Liberation Front of Niger" // unidentified, resource struggle, nigeria oil
ident 145 1 0 0 1 1 "People's Military Organization (OMP)" // attack group of the socialist party, nicaragua
ident 110 2 0 0 1 0 "Right Wing Lebanese Militiamen"
ident 95  0 0 1 3 1 "Salafi Abu-Bakr al-Siddiq Army" // salafist group in iraq
ident 110 1 0 0 1 1 "Socialist Labor Party of Lebanon" // lebanon
ident 182 0 0 0 0 2 "Somali Gang"
ident `cc' 0 0 0 0 0 "Supporters of opposing candidate Abdu Sakurtan"
ident `cc' 0 0 0 0 0 "The Great Serpent" // unclear
ident `cc' 0 0 2 3 0 "Trinitarians"
ident `cc' 0 0 2 3 0 "U/I Catholic Traditionalists"
ident `cc' 0 0 0 0 0 "Abu Hassan" // unidentified
ident 75  1 0 0 1 1 "Action Group for the Destruction of the Police State" // germany
ident 95  0 0 1 3 1 "al-Da'wah Party" // iraq
ident 153 0 0 0 0 1 "Al-Nawaz" // pakistani, anti-us, pro-Sharif
ident `cc' 3 0 0 1 0 "Anti-Communist rebels"
ident `cc' 2 0 0 1 1 "Anti-Marxist Commando" // here spain, unclear
ident `cc' 0 0 0 0 0 "Antonio"
ident 11  3 0 0 1 1 "Argentine Anti-Communist Alliance"
ident `cc' 0 0 1 3 1 "Armed Islamic Movement" // here algeria
ident 95  2 0 1 3 1 "Badr Brigades" // iraqi party plus milita, right-wing, islamist
ident 92  0 1 3 2 1 "Bengali Tiger Force (BTF)"
ident 36  0 1 0 2 0 "Cambodian guerrillas"
ident 61  1 0 0 1 1 "Central American Revolutionary Workers Party (PRTC)" // el salvador, party, with guerillas
ident 45  2 0 0 1 0 "Cleansing Hand (La Mano Que Limpia)" // colombia, unclear
ident `cc' 0 0 0 0 2 "Condor Plan Criminals"
ident 69  0 1 0 2 1 "Cuncolta Naziunalista" // corse
ident 110 0 0 1 3 1 "Dawn Forces" // lebanon
ident `cc' 2 0 0 1 0 "Death to Drug Traffickers" // unidentified, most likely vigilante
ident `cc' 0 0 0 0 0 "Dissidents linked to Zanga" // in zimbabwe, unclear
ident 132 0 1 0 2 0 "Dnestr Rebels"
ident 145 0 0 0 0 0 "El Mico Rebel Gray" // nicaragua, rebel bandits after disarmament
ident 160 1 0 0 1 1 "First May Movement" // philippines
ident 16  0 0 1 3 1 "Forest Brothers" // azerb. wahabists
ident 181 0 1 2 2 1 "Guadalcanal Liberation Army" // solomon islands, ethnic strife, liberation theology
ident 155 0 1 1 2 0 "Intifada Martyrs"
ident 202 0 0 1 3 1 "Islamic Revival Movement" // radical islam in tajikistan
ident `cc' 0 0 1 3 0 "Islamic Tendency" // fundamentalists, here in somalia
ident 92  0 1 5 3 1 "Jarnail Khalsa" // sikh political secessionist movement, trac claims them marxist, unclear
ident `cc' 0 0 1 3 1 "Jihad Islamic League Front" // here algeria
ident 6   0 0 1 3 1 "Kamal Boulander Group" // algeria, jihadists
ident 92  0 1 5 3 1 "Karamyit Singh" // babbar khalsa
ident 104 0 0 0 0 0 "Kenyan rebels from Uganda"
ident 209 0 1 1 2 1 "Kurdish Islamic Unity Party" // turkey, potentially pkk alias
ident 93  0 0 1 3 1 "Laskar Jihad" // indonesia, maluku militia
ident 97  1 0 0 1 0 "Lavalas Supporters" // leftist political party in haiti
ident 138 0 0 0 0 1 "League for National Democracy" // anti-junta party myanmar
ident 113 0 0 0 0 0 "Libya was behind incident"
ident 157 0 1 0 2 0 "Lufa Tribesmen" // papua
ident 4   0 0 1 3 1 "Mahaz-e-Milli Islami Afghanistan" // islamic party
ident 182 0 1 0 2 0 "Majerten clansmen"
ident `cc' 0 0 0 0 0 "Malitia-Pro Govt"
ident 110 0 0 1 3 0 "Martyr Ali Nasir group" // lebanon, unclear!
ident 97  0 1 0 2 1 "Masad Agents" // israel
ident `cc' 0 0 0 0 0 "Militia Members"
ident 94  0 0 0 0 1 "National Movement of Iranian Resistance" // iran, anti-islamic republic movement
ident 121 0 1 0 2 1 "National Revolutionary Front" // malaysia
ident 4   0 0 1 3 1 "Organization of Soldiers of the Levant" // afghanistan, intl
ident 30  0 1 0 2 0 "Pareci Indians" // in brazil
ident 209 1 0 0 1 1 "People's Liberation Army" // turkey, far-left armed underground, many similar named groups, all differentiated
ident 78  1 0 0 1 1 "People's Resistance Organized Army" // greece
ident 159 0 0 0 0 0 "Peruvian Rebels"
ident 235 3 0 0 1 1 "Portuguese Anti-Communist Movement"
ident 217 2 0 0 1 1 "Posse Comitatus"
ident 47  0 0 0 0 0 "Presidential Movement (MP) Militiamen" // congo brazzaville, kabila-supporters
ident `cc' 0 0 0 0 0 "Rival Parts"
ident 92  0 1 3 2 1 "Saffron Tigers" // india, hindu extremist
ident `cc' 2 0 0 1 0 "Scheutzen group" // schuetzen, right-wing, here italy
ident 130 1 1 0 1 1 "State Council of Indian and Peasant Organization" // peasant and pro-autonomy indians, mexico
ident 110 0 1 0 2 1 "Tanyus Shanin Armed Unit" // lebanon, armenian cause
ident 155 0 1 1 3 1 "The Islamic Revolution to Liberate Palestine" // palestine
ident 217 1 0 0 1 1 "Tribal Thumb"
ident 209 0 0 1 3 1 "Turkish Islamic Commandos"
ident `cc' 0 0 0 0 0 "U/I Snipers"
ident 213 0 0 2 3 1 "Uganda Democratic Christian Army (UDCA)"
ident 44  0 1 0 2 1 "Uighur Liberation Organization" // china based
ident 110 0 0 1 3 1 "Usbat al-Ansar (League of Partisans)" // lebanon religious
ident 216 2 0 0 1 1 "White Wolves (UK)"
ident 110 1 0 0 1 1 "Yazbik Revolutionary Organization" // lebanon, Yazbek was the founder of communist party in Lebanon
ident `cc' 1 0 0 1 0 "Young Pioneers"
 
* New groups from update
ident 11  2 1 0 2 1 "2 April Group" // argentina falkland war
ident 11  1 0 0 1 1 "Comite Argentino de Lucha Anti-Imperialisto" // argentina
ident 216 0 0 1 3 1 "Abu Hafs al-Masri Brigades" // uk? existence disputed!

* Coded all groups with at least 2 attacks or at least 2 killed

// Generate imputed identities (not used in paper):
replace identified = 3 if rel_iden==. & (regexm(gname,"Islam")==1 | regexm(gname,"Jihad") ==1 | regexm(gname,"Martyr") ==1 | ///
				regexm(gname,"Al-Qa`ida")==1 | regexm(gname,"Mujah")==1 | regexm(gname,"Moslem")==1 | regexm(gname,"Sunni") ==1 )
replace identified = 3 if rel_iden==. & (regexm(gname,"Christ")==1)
replace identified = 3 if rel_iden==. & (regexm(gname,"Jew")==1)
replace identified = 3 if sepeth_iden==. & ( regexm(gname,"Tribe")==1 | regexm(gname,"ribal")==1| regexm(gname,"tribe")==1 | ///
                    regexm(gname,"eparatist")==1 | regexm(gname,"Jew")==1 | regexm(gname,"ecessionist")==1 | ///
                    regexm(gname,"ationalist")==1 | regexm(gname,"thnic")==1 | regexm(gname,"ndependence")==1)
replace identified = 3 if pol_iden==. & ((regexm(gname,"ommunis")==1 & regexm(gname,"nti")==0) | regexm(gname,"eft-wing")==1 | ///
				regexm(gname,"eftist") ==1 | regexm(gname,"narchist")==1 | regexm(gname,"Left")==1 | regexm(gname,"arxist")==1 | ///
				regexm(gname,"roletarian")==1 | regexm(gname,"rolitarian")==1 | regexm(gname,"Labor")==1 | regexm(gname,"Lenin")==1 | /// 
				regexm(gname,"ocialist")==1 | (regexm(gname,"Revolutionary")==1 & regexm(gname,"Nationalist")==0)| ///
                    regexm(gname,"uclei")==1)  
replace identified = 3 if pol_iden==. & (regexm(gname,"ight-wing")==1 | regexm(gname,"ight-Wing")==1 | regexm(gname,"kin-head")==1| ///
                    regexm(gname,"kinhead")==1 | regexm(gname,"Gestapo")==1 | regexm(gname,"ight wing") | regexm(gname,"Nazi")==1)

// Impute religious identity to small groups (not used in the paper):
replace rel_iden   = 1 if rel_iden==. & (regexm(gname,"Islam")==1 | regexm(gname,"Jihad") ==1 | regexm(gname,"Martyr") ==1 | ///
				regexm(gname,"Al-Qa`ida")==1 | regexm(gname,"Mujah")==1 | regexm(gname,"Moslem")==1 | regexm(gname,"Sunni") ==1)
replace rel_iden = 2 if rel_iden==. & (regexm(gname,"Christ")==1)
replace rel_iden = 4 if rel_iden==. & (regexm(gname,"Jew")==1)

// Impute separatist identity to small groups (not used in the paper):
replace sepeth_iden = 1 if sepeth_iden==. & ( regexm(gname,"Tribe")==1 | regexm(gname,"ribal")==1| regexm(gname,"tribe")==1 | ///
                    regexm(gname,"eparatist")==1 | regexm(gname,"Jew")==1 | regexm(gname,"ecessionist")==1 | ///
                    regexm(gname,"ationalist")==1 | regexm(gname,"thnic")==1 | regexm(gname,"ndependence")==1)

// Impute political identity to small groups (not used in the paper):
replace pol_iden = 1 if pol_iden==. & ((regexm(gname,"ommunis")==1 & regexm(gname,"nti")==0) | regexm(gname,"eft-wing")==1 | ///
				regexm(gname,"eftist") ==1 | regexm(gname,"narchist")==1 | regexm(gname,"Left")==1 | regexm(gname,"arxist")==1 | ///
				regexm(gname,"roletarian")==1 | regexm(gname,"rolitarian")==1 | regexm(gname,"Labor")==1 | regexm(gname,"Lenin")==1 | /// 
				regexm(gname,"ocialist")==1 | (regexm(gname,"Revolutionary")==1 & regexm(gname,"Nationalist")==0)| ///
                    regexm(gname,"uclei")==1)  
replace pol_iden = 2 if pol_iden==. & (regexm(gname,"ight-wing")==1 | regexm(gname,"ight-Wing")==1 | regexm(gname,"kin-head")==1| ///
                    regexm(gname,"kinhead")==1 | regexm(gname,"Gestapo")==1 | regexm(gname,"ight wing") | regexm(gname,"Nazi")==1)

// Additional adjustments:

*before 1994 no info on WB and Gaza, reallocate Palestine to Israel
replace origin = 216 if origin == 155 & iyear<1994


// Imputations
local 1 "gname" 
local 2 "origin" 

// match Unknown and Other equal to country of location if country and target nationality are equal OR target nationality missing
generate conv = 1 if (`1' == "Unknown" | `1' == "Other") & (`cc' == natlty1 | natlty1==.) & `2' == .  
replace `2' = `cc' if (`1' == "Unknown" | `1' == "Other") & (`cc' == natlty1 | natlty1==.) & `2' == .  

// Serbia and Serbia & Montenegro:
replace origin = 175 if origin==1001 | origin==1003 & identified==1

// match other groups left equal to country if all attacks of a group occur in the same country 
duplicates tag `1' `cc', generate(z) 	
replace z = z+1

replace conv = 1  if z == group_total  & `2' == .
replace `2' = `cc' if z == group_total  & `2' == .
drop z

cap drop if country==1000 // weirdly erroneous data

* Dealing with Al Qaida:
replace `2' = `cc' if 	`1'=="Al-Qa`ida" &   ///
			(`cc'==182 | `cc'==95 | `cc'==153 | `cc'==136 | `cc'==4 | `cc'==173 | `cc'==228)
// For Somalia, Iraq, Pakistan, Morocco, Afghanistan, Saudi Arabia, Yemen replace Al'Qaida attacks to local groups

replace `2' = 9999 if (`1'=="Al-Qa`ida" | `1'=="Abu Hafs al-Masri Brigades") & `2'==. 
// tag Al'Qaida attacks of global scale - not included in analysis

log close coding
