/**
  * Klasse BinTree zur Umsetzung des ADT Binärbaum entsprechend der Vorgaben
  * des KC Informatik für die gymnasiale Oberstufe in Niedersachsen
 * @author Landesnetzwerk Informatik Niedersachsen, Carsten Rohe
 * @version 0.8_20200429
 */
public class BinTreeZMZ
{
  private BinTreeZMZ left, right;
  private ZeichenketteMitZahl data;
 
  /**
 * Ein leerer Baum wird erzeugt.
 * Der Baum besitzt keine Teilbäume. Die Wurzel besitzt keinen Inhalt.
 */
  public BinTreeZMZ()
  {
    left = null;
    right = null;
    data = null;
  }
 
  /**
   * Ein Baum mit dem übergebenen Inhalt als Wert der Wurzel wird erzeugt.
   * Der Baum besitzt keine Teilbäume.
   * @param d Der Inhalt für die Wurzel des neuen Baums.
   */
  public BinTreeZMZ(ZeichenketteMitZahl d)
  {
    data = d;
    left = null;
    right = null;
  }
  
  /**
   * Es wird überprüft, ob die Wurzel des Baums einen Inhalt besitzt.
   * @return Wenn die Wurzel des Baums einen Inhaltswert besitzt, wird der Wert true zurückgegeben, sonst der Wert false.
   */
  public boolean hasItem()
  {
    // 
    if(data != null)
      return true;
    // else
    return false;
  }

  /**
   * Die Operation gibt den Inhaltswert der Wurzel des Baums zurück.
   * @return Der Inhaltswert der Wurzel.
   */
  public ZeichenketteMitZahl getItem()
  {
    return data;
  }
  
  /**
  * Die Wurzel des Baums erhält den übergebenen Inhalt als Wert.
  * @param d Der neue Inhaltswert für die Wurzel.
  */
  public void setItem(ZeichenketteMitZahl d)
  {
    data = d;
  }

  /**
   * Die Operation löscht den Inhaltswert der Wurzel des Baums.
   */
  public void deleteItem()
  {
    data = null;
  }

  /**
   * Die Operation prüft, ob die Wurzel des Baums ein Blatt ist, d.h. ob der Baum keine Teilbäume besitzt.
   * @return Wenn der Baum keine Teilbäume besitzt, wird der Wert true zurückgegeben, sonst der Wert false.
   */
  public boolean isLeaf()
  {
    return (left == null && right == null);
  }

  /**
   * Die Operation prüft, ob der Baum einen linken Teilbaum besitzt.
   * @return Wenn der Baum einen linken Teilbaum besitzt, wird der Wert true zurückgegeben, sonst der Wert false.
   */  
  public boolean hasLeft()
  {
    return (left != null);
  }
  
  /**
  * Die Operation gibt den linken Teilbaum zurück.
  * Der Teilbaum wird dabei nicht entfernt.
  * @return Der linke Teilbaum.
  */
  public BinTreeZMZ getLeft()
  {
    // 
    return left;
  }
  
  /**
  * Der übergebene Baum wird als linker Teilbaum gesetzt.
  * @param b Der Baum, der als linker Teilbaum gesetzt werden soll.
  */
  public void setLeft(BinTreeZMZ b)
  {

    left = b;
  }
  
  /**
   * Die Operation löscht den linken Teilbaum.
   */
  public void deleteLeft()
  {
    left = null;
  }

  /**
   * Die Operation prüft, ob der Baum einen rechten Teilbaum besitzt.
   * @return Wenn der Baum einen rechten Teilbaum besitzt, wird der Wert true zurückgegeben, sonst der Wert false.
   */  
  public boolean hasRight()
  {
    return (right != null);
  }
  
  /**
   * Die Operation gibt den linken Teilbaum zurück.
   * Der Teilbaum wird dabei nicht entfernt.
   * @return Der linke Teilbaum.
   */
  public BinTreeZMZ getRight()
  {
    return right;
  }
  
  /**
  * Der übergebene Baum wird als rechter Teilbaum gesetzt.
  * @param b Der Baum, der als rechter Teilbaum gesetzt werden soll.
  */
  public void setRight(BinTreeZMZ b)
  {
    right = b;
  }
  
  /**
   * Die Operation löscht den rechten Teilbaum.
   */
  public void deleteRight()
  {
    right = null;
  }
}// Ende der Klasse BinTree