import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import mk.nds.adt.*; //alternativ kann die beiliegende Klasse BinTree vom Typ Zeichenkette verwendet werden


/**
 *
 * Beschreibung: Vorlage zu Huffman-Implementierungen
 *
 * @version 1.0 vom 02.10.2024
 * @author Ylva Brandt 
 */

public class VorlageHuffman extends JFrame {
  // Anfang Attribute
  BinTree hufbaum = new BinTree();
  String beispielCode = "00000010101100101110111110000010111101010011110010110001001010000110111001011"; 
  private JButton bDecodiere = new JButton();
  private JTextField jTextFieldText = new JTextField();
  private JButton bCodiere = new JButton();
  private JLabel lText = new JLabel();
  private JTextField jTextFieldCode = new JTextField();
  private JLabel lCode = new JLabel();
  // Ende Attribute
  
  public VorlageHuffman() { 
    // Frame-Initialisierung
    super();
    setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);
    int frameWidth = 582; 
    int frameHeight = 300;
    setSize(frameWidth, frameHeight);
    Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
    int x = (d.width - getSize().width) / 2;
    int y = (d.height - getSize().height) / 2;
    setLocation(x, y);
    setTitle("Huffman");
    setResizable(false);
    Container cp = getContentPane();
    cp.setLayout(null);
    // Anfang Komponenten
    lCode.setBounds(12, 162, 62, 20);
    lCode.setText("Code:");
    cp.add(lCode);
    jTextFieldCode.setBounds(80, 160, 465, 33);
    cp.add(jTextFieldCode);
    lText.setBounds(8, 24, 57, 25);
    lText.setText("Text:");
    cp.add(lText);
    bCodiere.setBounds(376, 81, 91, 25);
    bCodiere.setText("codiere");
    bCodiere.setMargin(new Insets(2, 2, 2, 2));
    bCodiere.addActionListener(new ActionListener() { 
      public void actionPerformed(ActionEvent evt) { 
        bCodiere_ActionPerformed(evt);
      }
    });
    cp.add(bCodiere);
    jTextFieldText.setBounds(80, 24, 465, 33);
    cp.add(jTextFieldText);
    bDecodiere.setBounds(163, 82, 91, 25);
    bDecodiere.setText("decodiere");
    bDecodiere.setMargin(new Insets(2, 2, 2, 2));
    bDecodiere.addActionListener(new ActionListener() { 
      public void actionPerformed(ActionEvent evt) { 
        bDecodiere_ActionPerformed(evt);
      }
    });
    cp.add(bDecodiere);
    
    // Ende Komponenten
    
    setVisible(true);

    hufbaum.setItem("");      
    hufbaum.setLeft(new BinTree(""));
    hufbaum.setRight(new BinTree(""));
    hufbaum.getLeft().setLeft(new BinTree(""));
    hufbaum.getLeft().setRight(new BinTree("I "));
    hufbaum.getRight().setLeft(new BinTree("E"));
    hufbaum.getRight().setRight(new BinTree("S"));
    hufbaum.getLeft().getLeft().setLeft(new BinTree(""));
    hufbaum.getLeft().getLeft().setRight(new BinTree("O"));
    hufbaum.getLeft().getRight().setLeft(new BinTree("I"));
    hufbaum.getLeft().getRight().setRight(new BinTree(" "));
    hufbaum.getLeft().getLeft().getLeft().setLeft(new BinTree(""));
    hufbaum.getLeft().getLeft().getLeft().setRight(new BinTree(""));
    hufbaum.getLeft().getLeft().getLeft().getLeft().setLeft(new BinTree("W"));
    hufbaum.getLeft().getLeft().getLeft().getLeft().setRight(new BinTree("N"));
    hufbaum.getLeft().getLeft().getLeft().getRight().setLeft(new BinTree("V"));
    hufbaum.getLeft().getLeft().getLeft().getRight().setRight(new BinTree("L"));
    
  } // end of public 
  
  // Anfang Methoden
  
  public static void main(String[] args) {
    new VorlageHuffman();
     
  } // end of main
  
  //zu Aufgabe 1
  public void bDecodiere_ActionPerformed(ActionEvent evt) {
    String eingabe = jTextFieldCode.getText();
    String text = decodiere(eingabe, hufbaum);
    jTextFieldText.setText(text);
  } 
  
  public String decodiere(String hufcode, BinTree baum){
     return "";//hier muss implementiert werden
  }

  //zu Aufgabe 2
  public void bCodiere_ActionPerformed(ActionEvent evt) {
    String eingabe = jTextFieldText.getText();
    String code = codiere(eingabe, hufbaum);
    jTextFieldCode.setText(code);
  }
  
  public String codiere(String text, BinTree baum){
    return ""; //hier muss implementiert werden
  }
  


} // end of class VorlageHuffman
