import de.bezier.data.sql.*;

public class DBManagerProcSQLite{

  /** der Name der SQLite-Datenbank */
  private String dbName = "schule_erweitert";
  
  /** ein Objekt für die Kommunikation mit der SQLite-Datenbank */
  SQLite db;
  
 
  /** erzeugt ein DBManagerSQLite-Objekt für die Datenbank schule_erweitert und stellt eine Verbindung zur Datenbank her
  * @param papplet der aufrufende Sketch, der Aufruf kann entsprechend mit "this" erfolgen
  */
  public DBManagerProcSQLite(PApplet papplet) {
    // öffnen der Datenbank
    db = new SQLite(papplet, dbName + ".db" );  
    println("verbunden: " + db.connect()); 
    /* //Ausgabe von Testdaten
    String[] tabellennamen = db.getTableNames();
    println("" + tabellennamen.length);
    for(int i = 0; i < tabellennamen.length; i++){
      println(tabellennamen[i]);
    }
    println("Konstruktor Ende");*/
  }
      
  /** erzeugt ein DBManagerSQLite-Objekt für die angegebene Datenbank und stellt eine Verbindung zur Datenbank her
  * @param papplet der aufrufende Sketch, der Aufruf kann entsprechend mit "this" erfolgen
  */
  public DBManagerProcSQLite(PApplet papplet, String dbName) {
    this.dbName = dbName;
    // öffnen der Datenbank
    db = new SQLite(papplet, dbName + ".db" );  
  }
  
  
  /**
  * führt die übergebene SQL-Anfrage aus
  * @param sqlAnfrage Die SQL-Anfrage, die ausgeführt werden soll, als Zeichenkette.
  * @return Das Ergebnis der SQL-Anfrage als zweidimensionale Reihung vom Typ Zeichenkette. Die oberste Zeile der Reihung enthält die Überschriften der Spalten. Danach folgt pro Datensatz eine Zeile mit den entsprechenden Werten. 
   * Diese werden unabhängig von den Datentypen der Datenbank als Zeichenkette gespeichert.</br>
   * Schlägt der Versuch die SQL-Anfrage zu stellen fehl, enthält die zweidimensionale Reihung nur ein Feld mit dem Inhalt "Fehler".</br>
   * Der erste Index der Reihung gibt die Zeile an, der zweite die Spalte.
  */    
  public String[][] sqlAnfrageAusfuehren(String sqlAnfrage){
    //Rückgabe vorbereiten
    String[][] ergebnis = new String[1][1];
    ergebnis[0][0] = "Fehler";
    try{
      if (db.connect()) {
      
      //Das Ergebnis kommt als Java-Objekt vom Typ ResultSet, das im Objekt db verwaltet wird, zurück. Der Inhalt wird in die zweidimensionale Reihung übertragen und dies dann zurückgegeben.
      db.query(sqlAnfrage);
      println("Anfrage ausgeführt");      
      //zunaechst muss die Groesse der benoetigten Zeilen und Spalten in der Reihung bestimmt werden. 
      int spalten  = db.getColumnNames().length;
      int zeilen = 1;
      while(db.next()){
        zeilen++;
      }
      ergebnis = new String[zeilen][spalten];
                
      //Da das Resultset in Verbindung mit SQLite nur einmal durchlaufen werden kann, muss
      // die Anfrage hier nocheinmal gestellt werden, um ein neues Resultset zu erhalten, 
      // das nun in die Reihung uebertragen werden kann.
      db.query(sqlAnfrage);
                  
      //die erste Zeile mit den Spaltennamen füllen  
      String[] spaltennamen = db.getColumnNames();
      int zeilenzaehler = 0;  
      for (int i = 0; i < spalten; i++) {
        ergebnis[0][i] = spaltennamen[i];
      } // end of for
      zeilenzaehler++;
      
      //die Datensaetze uebertragen
      while (db.next()) {
        for(int i = 1; i <= spalten; i++){
          ergebnis[zeilenzaehler][i-1] = db.getString(i);
        }
        zeilenzaehler++; 
      } // end of while
     } 
    }catch(Exception e){
      e.printStackTrace();
    }
    return ergebnis; 
  }
  
  /**
  * führt die übergebene SQL-Einfüge-Anweisung aus
  * @param sql Die SQL-Anweisung, die ausgeführt werden soll, als Zeichenkette.
  * 
  */   
  public void datensatzEinfuegen(String sql){
    try{
      if (db.connect()) {
        //Die SQL-Anweisung zum Einfügen wird ausgeführt.    
        db.execute(sql);
      }
    }catch(Exception e){
       e.printStackTrace();
    }  
  } 
  
  /**
  * führt die übergebene SQL-Update-Anweisung aus
  * @param sql Die SQL-Anweisung, die ausgeführt werden soll, als Zeichenkette
  */  
  public void datensatzAendern(String sql){
   try{
      if (db.connect()) {
        //Die SQL-Anweisung zum Ändern wird ausgeführt.    
        db.execute(sql);
      }
    }catch(Exception e){
       e.printStackTrace();
    }    
   }
 
   /**
  * führt die übergebene SQL-Lösch-Anweisung aus
  * @param sql Die SQL-Anweisung, die ausgeführt werden soll, als Zeichenkette
  */  
   public void datensatzLoeschen(String sql){
    try{
      if (db.connect()) {
        //Die SQL-Anweisung zum Löschen wird ausgeführt.    
        db.execute(sql);
      }
    }catch(Exception e){
       e.printStackTrace();
    }  
   }
  
} 
