import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;

/**
 *
 * Beschreibung
 *
 * @version 2.0 vom 02.02.2024
 * @author Ylva Brandt
 * 
 */

public class SucheGebDatum extends JFrame {
  // Anfang Attribute
  //Dialogelemente, die mithilfe des Objektinspektors und des Designformulars erzeugt wurden
  private JLabel lName = new JLabel();
  private JLabel lVorname = new JLabel();
  private JTextField tfName = new JTextField();
  private JTextField tfVorname = new JTextField();
  private JButton bSucheGeburtstag = new JButton();
  private JLabel lGeburtstag = new JLabel();
  private JLabel lAusgabe = new JLabel();
  //Ein Objekt von der Hilfsklasse DBManagerSQLite erzeugen
  private DBManagerSQLite myDBManager = new DBManagerSQLite();
  // Ende Attribute
  
  //Dieser Konstruktor wird automatisch erstellt und gefüllt
  public SucheGebDatum() { 
    // Frame-Initialisierung
    super();
    setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);
    int frameWidth = 341; 
    int frameHeight = 300;
    setSize(frameWidth, frameHeight);
    Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
    int x = (d.width - getSize().width) / 2;
    int y = (d.height - getSize().height) / 2;
    setLocation(x, y);
    setTitle("SucheGebDatum");
    setResizable(false);
    Container cp = getContentPane();
    cp.setLayout(null);
    // Anfang Komponenten
    lAusgabe.setBounds(96, 192, 185, 25);
    lAusgabe.setText("");
    lAusgabe.setBackground(Color.WHITE);
    lAusgabe.setOpaque(true);
    lAusgabe.setFont(new Font("Dialog", Font.BOLD, 12));
    cp.add(lAusgabe);
    lGeburtstag.setBounds(8, 192, 86, 20);
    lGeburtstag.setText("Geburtstag:");
    lGeburtstag.setFont(new Font("Dialog", Font.BOLD, 12));
    cp.add(lGeburtstag);
    bSucheGeburtstag.setBounds(88, 120, 193, 33);
    bSucheGeburtstag.setText("suche Geburtstag");
    bSucheGeburtstag.setMargin(new Insets(2, 2, 2, 2));
    bSucheGeburtstag.addActionListener(new ActionListener() { 
      public void actionPerformed(ActionEvent evt) { 
        bSucheGeburtstag_ActionPerformed(evt);
      }
    });
    bSucheGeburtstag.setFont(new Font("Dialog", Font.BOLD, 12));
    cp.add(bSucheGeburtstag);
    tfVorname.setBounds(88, 72, 193, 25);
    tfVorname.setFont(new Font("Dialog", Font.PLAIN, 12));
    tfVorname.setEnabled(true);
    cp.add(tfVorname);
    tfName.setBounds(88, 32, 193, 25);
    tfName.setFont(new Font("Dialog", Font.PLAIN, 12));
    cp.add(tfName);
    lVorname.setBounds(8, 72, 78, 20);
    lVorname.setText("Vorname:");
    lVorname.setFont(new Font("Dialog", Font.BOLD, 12));
    cp.add(lVorname);
    lName.setBounds(8, 32, 78, 20);
    lName.setText("Name:");
    lName.setFont(new Font("Dialog", Font.BOLD, 12));
    cp.add(lName);
    
    // Ende Komponenten
    
    setVisible(true);
  } // end of public SucheGebDatum
  
  // Anfang Methoden
  //Diese Methode wird automatisch erstellt und gefüllt
  public static void main(String[] args) {
    new SucheGebDatum();
  } // end of main
  
  //Diese Methode wird ausgeführt, wenn der Button angeklickt wird.
  public void bSucheGeburtstag_ActionPerformed(ActionEvent evt) {
    //Textfelder Auslesen
        String name = tfName.getText();
        String vorname = tfVorname.getText();
        
        // SQL-Abfrage als Zeichenkette zusammenstellen
        String sql = "select Geburtstag from schueler where Name = '" + name +
                "' and Vorname = '" + vorname + "';";
        
        //SQL-Abfrage an Datenbank schicken. Das Ergebnis kommt als zweidimensionale Reihung zurueck
        String[][] ergebnis = myDBManager.sqlAnfrageAusfuehren(sql);
        
        //Wenn das Ergebnis zwei Zeilen enthaelt, steht in der zweiten Zeile das Geburtsdatum und wird ausgegeben.
        if(ergebnis.length > 1)
            lAusgabe.setText(ergebnis[1][0]);
        else{ 
            //Wenn das Ergebnis nur eine Zeile enthaelt, ist entweder ein Fehler aufgetreten oder der Schueler wurde nicht gefunden.
            if(ergebnis.length == 1){
                if(ergebnis[0][0].equals("Fehler")) lAusgabe.setText("Es ist ein Fehler aufgetreten.");
                else{
                   lAusgabe.setText("Diese Person gibt es in der Datenbank nicht!");
          }
            }          
        }
    
  } // end of bSucheGeburtstag_ActionPerformed

  // Ende Methoden
} // end of class SucheGebDatum
