import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;

/**
 *
 * Beschreibung
 *
 * @version 1.0 vom 26.01.2024
 * @author Ylva Brandt
 */

public class Nachhilfe extends JFrame {
  // Anfang Attribute
  private JLabel lFach = new JLabel();
  private JLabel lWohnort = new JLabel();
  private JComboBox<String> jComboBoxFach = new JComboBox<String>();
  private DefaultComboBoxModel<String> jComboBoxFachModel = new DefaultComboBoxModel<String>();
  private JComboBox<String> jComboBoxOrt = new JComboBox<String>();
  private DefaultComboBoxModel<String> jComboBoxOrtModel = new DefaultComboBoxModel<String>();
  private JButton bSucheNachhilfe = new JButton();
  private JTextArea jTextAreaAusgabe = new JTextArea("");
  private JScrollPane jTextAreaAusgabeScrollPane = new JScrollPane(jTextAreaAusgabe);
  //In der Reihung fachkurezl sind die Kürzel der einzelnen Fächer enthalten, wie sie in den Kursnummern in der Datenbank verwendet werden.
  //Der Index stimmt mit dem Index des Faches in der JComboBoxFach überein.
  private String[] fachkuerzel = {"ma", "dt", "en", "l", "e", "f", "ru", "bi", "ch", "ph", "i", "wn", "re", "po", "ge", "ek", "mu", "ku"};
  //Instanz der Hilfsklasse DBManagerSQLite für die Datenbank schule.db
  private DBManagerSQLite myDBManager = new DBManagerSQLite("schule");
  // Ende Attribute
  
  public Nachhilfe() { 
    // Frame-Initialisierung
    super();
    setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);
    int frameWidth = 537; 
    int frameHeight = 402;
    setSize(frameWidth, frameHeight);
    Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
    int x = (d.width - getSize().width) / 2;
    int y = (d.height - getSize().height) / 2;
    setLocation(x, y);
    setTitle("Nachhilfe");
    setResizable(false);
    Container cp = getContentPane();
    cp.setLayout(null);
    // Anfang Komponenten
    jTextAreaAusgabeScrollPane.setBounds(16, 192, 481, 137);
    cp.add(jTextAreaAusgabeScrollPane);
    bSucheNachhilfe.setBounds(16, 120, 233, 49);
    bSucheNachhilfe.setText("suche Nachhilfe");
    bSucheNachhilfe.setMargin(new Insets(2, 2, 2, 2));
    bSucheNachhilfe.addActionListener(new ActionListener() { 
      public void actionPerformed(ActionEvent evt) { 
        bSucheNachhilfe_ActionPerformed(evt);
      }
    });
    cp.add(bSucheNachhilfe);
    jComboBoxOrt.setModel(jComboBoxOrtModel);
    jComboBoxOrt.setBounds(95, 80, 150, 20);
    jComboBoxOrtModel.addElement("Mausdorf");
    jComboBoxOrtModel.addElement("Altenfelde");
    jComboBoxOrtModel.addElement("Runingen");
    jComboBoxOrtModel.addElement("Kirschdorf");
    jComboBoxOrtModel.addElement("Drachenwiese");
    cp.add(jComboBoxOrt);
    jComboBoxFach.setModel(jComboBoxFachModel);
    jComboBoxFach.setBounds(95, 38, 150, 20);
    jComboBoxFachModel.addElement("Mathematik");
    jComboBoxFachModel.addElement("Deutsch");
    jComboBoxFachModel.addElement("Englisch");
    jComboBoxFachModel.addElement("Latein");
    jComboBoxFachModel.addElement("Spanisch");
    jComboBoxFachModel.addElement("Franzoesisch");
    jComboBoxFachModel.addElement("Russisch");
    jComboBoxFachModel.addElement("Biologie");
    jComboBoxFachModel.addElement("Chemie");
    jComboBoxFachModel.addElement("Physik");
    jComboBoxFachModel.addElement("Informatik");
    jComboBoxFachModel.addElement("Werte und Normen");
    jComboBoxFachModel.addElement("Religion");
    jComboBoxFachModel.addElement("Politik");
    jComboBoxFachModel.addElement("Geschichte");
    jComboBoxFachModel.addElement("Erdkunde");
    jComboBoxFachModel.addElement("Musik");
    jComboBoxFachModel.addElement("Kunst");
    cp.add(jComboBoxFach);
    lWohnort.setBounds(16, 79, 70, 20);
    lWohnort.setText("Wohnort:");
    cp.add(lWohnort);
    lFach.setBounds(16, 37, 70, 20);
    lFach.setText("Fach:");
    cp.add(lFach);
    
    // Ende Komponenten
    
    setVisible(true);
  }
  
  // Anfang Methoden
  
  public static void main(String[] args) {
    new Nachhilfe();
    
  }
  public void bSucheNachhilfe_ActionPerformed(ActionEvent evt) {
    //Da die Fächer in der Datenbank nur mit Kürzeln in den Kursnummern zu finden sind, wird dem Fach über die Reihung fachkuerzel das passende Kürzel für die SQL-Abfrage zu geordnet
    String fach = fachkuerzel[jComboBoxFach.getSelectedIndex()];
    //In ortsteil wird der bei Wohnort ausgewählte Ortsteilgespeichert
    String ortsteil = jComboBoxOrt.getSelectedItem().toString(); 
    
    //In sql wir die SQL-Anfrage zusammengebaut. Es werden jene Schüler ausgewählt, die im gleichen Wohnort wohnen und in dem ausgewählten Fach einen 
    //Punktedurchschnitt von mehr als 10 Punkten haben. Die Schüler werden nach Punktedurchschnitt sortiert, begonnen mit dem besten.
    String sql = "select schueler.ID_nummer, Vorname, Name, avg(punkte) from schueler, hatkurs, kurse where schueler.id_nummer = hatkurs.id_nummer and "
    + "kurse.kursnummer = hatkurs.kursnummer and kurse.kursnummer like '" + fach + "%' "
    + "and schueler.Ortsteil = '" + ortsteil  + "' "
    + "group by schueler.id_nummer having avg(punkte) > 10 order by avg(punkte) desc;";
    
    //ausführen der SQL-Anfrage
    String ergebnis[][] = myDBManager.sqlAnfrageAusfuehren(sql);
    
    //Wenn geeignete Schüler gefunden wurden, werden sie mit Vorname, Nachname und Punktedurchschnitt (gerundet auf ganze Punkte) angezeigt.    
    String ausgabe = "Folgende Schülerinnen und Schüler könnten dir Nachhilfe geben.\nSie wohnen ebenfalls in " + ortsteil + ":\n";
    if(ergebnis.length > 1){
      for(int i = 1; i < ergebnis.length; i++){
        ausgabe = ausgabe + ergebnis[i][1] + " " + ergebnis[i][2] + " mit Punktedurchschnitt " + Math.round(Float.parseFloat(ergebnis[i][3])) + "\n";
      }
    }
    //Wenn keine geeigneten Schüler gefunden wurden. Wird mitgeteilt, ob ein Fehler aufgetreten ist oder es keine geeigneten Schüler gibt. Es kann dann ggf. in einem anderen Stadtteil gesucht werden.
    else{
      if(ergebnis[0][0].equals("Fehler")) ausgabe = "Es ist ein Fehler aufgetreten.";
      else {
        ausgabe = "Es gibt in deinem Wohnort keinen Schüler, \nder dir Nachhilfe im Fach " + jComboBoxFach.getSelectedItem().toString() + " geben kann. \nProbiere es in einem anderen Wohnort.";
      } // end of if-else
    }
    jTextAreaAusgabe.setText(ausgabe);  
  }

  // Ende Methoden
}
