import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;

/**
 *
 * Beschreibung
 *
 * @version 1.0 vom 26.01.2024
 * @author Ylva Brandt
 */

public class Lernteams extends JFrame {
  // Anfang Attribute
  private JLabel lKurs = new JLabel();
  private JLabel lTeamgroesse = new JLabel();
  private JTextField jTextFieldKurs = new JTextField();
  private JRadioButton rb2 = new JRadioButton();
  private JRadioButton rb3 = new JRadioButton();
  private JRadioButton rb4 = new JRadioButton();
  private ButtonGroup buttonGroup1 = new ButtonGroup();
  private JLabel lZusammensetzung = new JLabel();
  private JRadioButton rbhomogen = new JRadioButton();
  private JRadioButton rbheterogen = new JRadioButton();
  private ButtonGroup buttonGroup2 = new ButtonGroup();
  private JButton bBildeTeams = new JButton();
  private JTextArea jTextAreaAusgabe = new JTextArea("");
  private JScrollPane jTextAreaAusgabeScrollPane = new JScrollPane(jTextAreaAusgabe);
  
  //Variable für die Bezeichnung des Kurses, wird über ein Textfeld eingegeben
  private String kurs = "";
    
  //Variable für die Gruppengröße, wird über Radiobuttons eingegeben
  private int anzahlSchueler = 2;
    
  //Variable für die Art der Gruppen, es wird zwischen homogen und heterogen unterschieden, Eingabe erfolgt über Radiobuttons
  private boolean homogen = true;
    
  //Objekt der Klasse DBManagerSQLite für die Kommunikation mit der Datenbank
  private DBManagerSQLite myDBManager = new DBManagerSQLite("schule");
  // Ende Attribute
  
  public Lernteams() { 
    // Frame-Initialisierung
    super();
    setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);
    int frameWidth = 754; 
    int frameHeight = 373;
    setSize(frameWidth, frameHeight);
    Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
    int x = (d.width - getSize().width) / 2;
    int y = (d.height - getSize().height) / 2;
    setLocation(x, y);
    setTitle("Lernteams");
    setResizable(false);
    Container cp = getContentPane();
    cp.setLayout(null);
    // Anfang Komponenten
    jTextAreaAusgabeScrollPane.setBounds(20, 167, 704, 156);
    cp.add(jTextAreaAusgabeScrollPane);
    bBildeTeams.setBounds(20, 119, 147, 33);
    bBildeTeams.setText("bilde Teams");
    bBildeTeams.setMargin(new Insets(2, 2, 2, 2));
    bBildeTeams.addActionListener(new ActionListener() { 
      public void actionPerformed(ActionEvent evt) { 
        bBildeTeams_ActionPerformed(evt);
      }
    });
    cp.add(bBildeTeams);
    rbheterogen.setBounds(280, 82, 140, 20);
    rbheterogen.setOpaque(false);
    rbheterogen.setText("leistungsheterogen");
    buttonGroup2.add(rbheterogen);
    cp.add(rbheterogen);
    rbhomogen.setBounds(280, 56, 132, 20);
    rbhomogen.setOpaque(false);
    rbhomogen.setText("leistungshomogen");
    buttonGroup2.add(rbhomogen);
    rbhomogen.setSelected(true);
    cp.add(rbhomogen);
    lZusammensetzung.setBounds(280, 29, 116, 20);
    lZusammensetzung.setText("Zusammensetzung:");
    cp.add(lZusammensetzung);
    rb4.setBounds(140, 85, 52, 20);
    rb4.setOpaque(false);
    rb4.setText("4");
    buttonGroup1.add(rb4);
    rb4.setSelected(true);
    cp.add(rb4);
    rb3.setBounds(80, 85, 52, 20);
    rb3.setOpaque(false);
    rb3.setText("3");
    buttonGroup1.add(rb3);
    cp.add(rb3);
    rb2.setBounds(20, 85, 52, 20);
    rb2.setOpaque(false);
    rb2.setText("2");
    buttonGroup1.add(rb2);
    cp.add(rb2);
    jTextFieldKurs.setBounds(113, 28, 150, 28);
    jTextFieldKurs.setText("Dt 13L");
    cp.add(jTextFieldKurs);
    lTeamgroesse.setBounds(20, 61, 110, 20);
    lTeamgroesse.setText("Teamgröße:");
    cp.add(lTeamgroesse);
    lKurs.setBounds(20, 30, 86, 20);
    lKurs.setText("Kurs:");
    cp.add(lKurs);
    
    // Ende Komponenten
    
    setVisible(true);
  }
  
  // Anfang Methoden
  
  public static void main(String[] args) {
    new Lernteams();
  }
  public String buttonGroup1_getSelectedRadioButtonLabel() {
    for (java.util.Enumeration<AbstractButton> e = buttonGroup1.getElements(); e.hasMoreElements();) {
      AbstractButton b = e.nextElement();
      if (b.isSelected()) return b.getText();
    }
    return "";
  }

  public String buttonGroup2_getSelectedRadioButtonLabel() {
    for (java.util.Enumeration<AbstractButton> e = buttonGroup2.getElements(); e.hasMoreElements();) {
      AbstractButton b = e.nextElement();
      if (b.isSelected()) return b.getText();
    }
    return "";
  }

  public void bBildeTeams_ActionPerformed(ActionEvent evt) {
    //Auslesen des Kursnamens auf dem Textfeld
      kurs = jTextFieldKurs.getText();
      
      //je nachdem welche Radiobutton ausgewählt wurde, wird 2, 3 oder 4 als Gruppengröße abgespeichert
      if(rb2.isSelected()) anzahlSchueler = 2;
      else if(rb3.isSelected()) anzahlSchueler = 3;
      else anzahlSchueler = 4;
      
      //je nachdem welche Radiobutton für die Art der Gruppenbildung ausgewählt wurde, wird homigen auf true oder false gesetzt
      if(rbhomogen.isSelected())homogen = true;
      else homogen = false;
      
      //zusammenbauen der Datenbankabfrage. Nur der Kursname wird variabel festgelegt
      //die Schüler werden nach Leistungs sortiert, um das zusammensetzen der Teams zuerleichtern
      String sql = "select Vorname, Name, Punkte from schueler, hatkurs "
              + "where schueler.id_nummer = hatkurs.id_nummer and kursnummer = '" 
              + kurs + "' order by Punkte";
      
      //ausführen der Datenbankabfrage
      String[][] ergebnis = myDBManager.sqlAnfrageAusfuehren(sql);
      
      //Die Gruppenzusammensetzung wird nach und nach in der Variable ausgabe gespeichert
      String ausgabe = "";
      //jedes Team erhält eine Nummer
      int teamzaehler = 1;
      //wenn die Rückgabe der Datenbank mehr als eine Zeile enthält, wurden Schüler zu dem Kurs gefunden und es kann mit der Gruppenbildung begonnen werden
      if(ergebnis.length > 1){
          if(homogen){
            ausgabe = "Es können folgende homogene Teams gebildet werden:";
            //um homogene Teams zu erhalten, wird die nach Leistungs sortierte Liste einfach der Reihe nach durchgegangen            
            //die äußere Schleife zählt die Teams ab
            for(int i = 1; i < ergebnis.length; i= i+anzahlSchueler){
                  ausgabe = ausgabe + "\n Team " + teamzaehler + ": ";
                  teamzaehler++;
                  //die innere Schleife zählt die Schüler pro Team ab
                  //wenn für das letzte Team nicht mehr ausreichend Schüler vorhanden sind, ist das Team entsprechend kleiner
                  for(int j = 0; j < anzahlSchueler; j++ ){
                      if((i+j)< ergebnis.length){
                          ausgabe = ausgabe + ergebnis[i+j][0] + " " + ergebnis[i+j][1] + " (" + ergebnis[i+j][2]+" Punkte), "; 
                      }
                      
                  }
            }
          }else{//in diesem Fall werden heterogene Gruppen gebildet
              ausgabe = "Es können folgende heterogene Teams gebildet werden:";
              //um heterogene Gruppen zu bilden wird die Liste in so viele Teile geteilt, wie es Schüler pro Gruppe geben soll
              //bei drei Gruppenmitgliedern enthielte die erste Teilliste die leistungsschwächsten, die zweite die Schüler im Mittelfeld und die dritte die leistungsstärksten
              //aus jeder Liste wird dann für die Team 1 der erste, für Teams 2 der zweite Schüler genommen usw. 
              //Dieser Algorithmus lässt sich für eine bessere Durchmischung auf jeden Fall noch verbessern, 
              for(int i = 1; i <= ((ergebnis.length-1)/anzahlSchueler); i++){
                  ausgabe = ausgabe + "\n Team " + teamzaehler + ": ";
                  teamzaehler++;
                  int abstand = (ergebnis.length-1) / anzahlSchueler;
                  for(int j = 0; j < anzahlSchueler; j++ ){
                      if((i+(j*abstand))< ergebnis.length){
                          ausgabe = ausgabe + ergebnis[i+(j*abstand)][0] + " " + ergebnis[i+(j*abstand)][1] + " (" + ergebnis[i+(j*abstand)][2]+" Punkte), "; 
                      }
                      
                  }
              }
              //Ist zum Schluss nur ein Schüler übrig, wird es ans letzte Team angehängt
              //sind noch zwei oder drei Schüler übrig, bilden sie eine eigene Gruppe
              if(((teamzaehler-1)*anzahlSchueler) < ergebnis.length-1){
                  int rest = (ergebnis.length-1) % anzahlSchueler;
                  if(rest == 1) ausgabe = ausgabe + ergebnis[ergebnis.length-1][0] + " " + ergebnis[ergebnis.length-1][1] + " (" + ergebnis[ergebnis.length-1][2] + " Punkte)";
                  if(rest == 2){
                      ausgabe = ausgabe + "\n Team " + (teamzaehler) + ": ";
                      ausgabe = ausgabe + ergebnis[ergebnis.length-2][0] + " " + ergebnis[ergebnis.length-2][1] + " (" + ergebnis[ergebnis.length-2][2] + " Punkte), ";
                      ausgabe = ausgabe + ergebnis[ergebnis.length-1][0] + " " + ergebnis[ergebnis.length-1][1] + " (" + ergebnis[ergebnis.length-1][2] + " Punkte)";
                  }
                  if(rest == 3){
                      ausgabe = ausgabe + "\n Team " + (teamzaehler) + ": ";
                      ausgabe = ausgabe + ergebnis[ergebnis.length-3][0] + " " + ergebnis[ergebnis.length-3][1] + " (" + ergebnis[ergebnis.length-3][2] + " Punkte), ";
                      ausgabe = ausgabe + ergebnis[ergebnis.length-2][0] + " " + ergebnis[ergebnis.length-2][1] + " (" + ergebnis[ergebnis.length-2][2] + " Punkte), ";
                      ausgabe = ausgabe + ergebnis[ergebnis.length-1][0] + " " + ergebnis[ergebnis.length-1][1] + " (" + ergebnis[ergebnis.length-1][2] + " Punkte)";
                      
                  }
              }
          }
      }else{
          //steht an Stelle 0|0 "Fehler", ist beim Ausführen der SQL-Anweisung ein Fehler aufgetreten
          if(ergebnis[0][0].equals("Fehler")){
              ausgabe = "Es ist ein Fehler aufgetreten.";
          }else{//wenn keine Schüler gefunden wurden, wurde der Name vermutlich falsch geschrieben bzw. gibt es den Kurs nicht
              ausgabe = "Für diesen Kurs sind keine Schüler in der Datenbank vorhanden. \n"
                      + "Bitte überprüfen Sie den Namen des Kurses ";
          }
      }
      //der Text wird auf der Benutzeroberfläche ausgegeben
      jTextAreaAusgabe.setText(ausgabe);
    
  }

  // Ende Methoden
}
