import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;

/**
 *
 * Beschreibung
 *
 * @version 1.0 vom 26.01.2024
 * @author Ylva Brandt
 */

public class DatingPortal extends JFrame {
  // Anfang Attribute
  private JLabel lDating = new JLabel();
  private JLabel lName = new JLabel();
  private JTextField jTextFieldName = new JTextField();
  private JLabel lGeschlecht = new JLabel();
  private ButtonGroup buttonGroup1 = new ButtonGroup();
  private JRadioButton rbWeiblich = new JRadioButton();
  private JRadioButton rbMaennlich = new JRadioButton();
  private JLabel lSexuelleOrientierung1 = new JLabel();
  private ButtonGroup buttonGroup2 = new ButtonGroup();
  private JRadioButton rbHomosexuell = new JRadioButton();
  private JRadioButton rbHeterosexuell = new JRadioButton();
  private JLabel lNotendurchschnitt = new JLabel();
  private JSlider jSliderNotenschnitt = new JSlider();
  private JLabel lGeburtstdatum = new JLabel();
  private JSpinner jSpinnerTag = new JSpinner();
  private SpinnerNumberModel jSpinnerTagModel = new SpinnerNumberModel(1, 1, 31, 1);
  private JSpinner jSpinnerMonat = new JSpinner();
  private SpinnerNumberModel jSpinnerMonatModel = new SpinnerNumberModel(1, 1, 12, 1);
  private JLabel lTag = new JLabel();
  private JLabel lMonat = new JLabel();
  private JSpinner jSpinnerJahr = new JSpinner();
  private SpinnerNumberModel jSpinnerJahrModel = new SpinnerNumberModel(2006, 1925, 2025, 1);
  private JLabel lJahr = new JLabel();
  private JLabel lLieblingsfach1 = new JLabel();
  private JComboBox<String> jComboBoxFach = new JComboBox<String>();
  private DefaultComboBoxModel<String> jComboBoxFachModel = new DefaultComboBoxModel<String>();
  private JButton bDatenschutzbestimmungen = new JButton();
  private JButton bSuchePartner = new JButton();
  private JTextArea jTextAreaAusgabe = new JTextArea("");
  private JScrollPane jTextAreaAusgabeScrollPane = new JScrollPane(jTextAreaAusgabe);
  
  //selbst erstellte Variablen
  
  //Es wird ein Objekt der beiliegenden Klasse DBManager benoetigt, das die Kommunikation mit der Datenbank uebernimmt.
  //als Parameter wird der Name der Datenbank uebergeben
  //private DBManager myDBManager = new DBManager();  
  private DBManagerSQLite myDBManager = new DBManagerSQLite();  
  
  //Hier wird sich gemerkt, ob der Anwender die Datenschutzbestimmungen schon akzeptiert hat.
  private boolean dsAkzeptiert = false;
  
  //Hier wird der Name des Anwenders gespeichert.
  String name = "";
  
  //Hier werden die weiteren Angaben des Anwenders fuer die spaetere sql-Anfrage gespeichert. Fuer den Beginn werden Standardwerte unabhaengig von den Startwerten der Benutzeroberflaeche gewaehlt.
  String geschlecht = "w";
  String orientierung = "heterosexuell";
  int notendurchschnitt = 8;
  String gebDatum = "20000101";
  String lieblingsfach = "Mathematik";
  
  //Da der Partner maximal zwei Jahr aelter oder juenger sein soll, koennen hier schon die entsprechenden Datumsgrenzen gespeichet werden.
  String gebDatumMin = "19980101";         
  String gebDatumMax = "20020101";
  // Ende Attribute
  
  public DatingPortal() { 
    // Frame-Initialisierung
    super();
    setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);
    int frameWidth = 908; 
    int frameHeight = 739;
    setSize(frameWidth, frameHeight);
    Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
    int x = (d.width - getSize().width) / 2;
    int y = (d.height - getSize().height) / 2;
    setLocation(x, y);
    setTitle("DatingPortal");
    setResizable(false);
    Container cp = getContentPane();
    cp.setLayout(null);
    // Anfang Komponenten
    jTextAreaAusgabeScrollPane.setBounds(40, 403, 824, 276);
    cp.add(jTextAreaAusgabeScrollPane);
    bSuchePartner.setBounds(263, 352, 227, 33);
    bSuchePartner.setText("suche Partner / Partnerin");
    bSuchePartner.setMargin(new Insets(2, 2, 2, 2));
    bSuchePartner.addActionListener(new ActionListener() { 
      public void actionPerformed(ActionEvent evt) { 
        bSuchePartner_ActionPerformed(evt);
      }
    });
    bSuchePartner.setEnabled(false);
    cp.add(bSuchePartner);
    bDatenschutzbestimmungen.setBounds(41, 352, 203, 33);
    bDatenschutzbestimmungen.setText("Datenschutzbestimmungen");
    bDatenschutzbestimmungen.setMargin(new Insets(2, 2, 2, 2));
    bDatenschutzbestimmungen.addActionListener(new ActionListener() { 
      public void actionPerformed(ActionEvent evt) { 
        bDatenschutzbestimmungen_ActionPerformed(evt);
      }
    });
    cp.add(bDatenschutzbestimmungen);
    jComboBoxFach.setModel(jComboBoxFachModel);
    jComboBoxFach.setBounds(533, 260, 238, 36);
    jComboBoxFachModel.addElement("Mathematik");
    jComboBoxFachModel.addElement("Deutsch");
    jComboBoxFachModel.addElement("Englisch");
    jComboBoxFachModel.addElement("Latein");
    jComboBoxFachModel.addElement("Spanisch");
    jComboBoxFachModel.addElement("Franzoesisch");
    jComboBoxFachModel.addElement("Russisch");
    jComboBoxFachModel.addElement("Biologie");
    jComboBoxFachModel.addElement("Chemie");
    jComboBoxFachModel.addElement("Physik");
    jComboBoxFachModel.addElement("Informatik");
    jComboBoxFachModel.addElement("Werte und Normen");
    jComboBoxFachModel.addElement("Religion");
    jComboBoxFachModel.addElement("Politik");
    jComboBoxFachModel.addElement("Geschichte");
    jComboBoxFachModel.addElement("Erdkunde");
    jComboBoxFachModel.addElement("Musik");
    jComboBoxFachModel.addElement("Kunst");
    cp.add(jComboBoxFach);
    lLieblingsfach1.setBounds(533, 223, 110, 20);
    lLieblingsfach1.setText("Lieblingsfach:");
    cp.add(lLieblingsfach1);
    lJahr.setBounds(670, 127, 86, 20);
    lJahr.setText("Jahr:");
    cp.add(lJahr);
    jSpinnerJahr.setBounds(671, 162, 78, 24);
    jSpinnerJahr.setValue(2006);
    jSpinnerJahr.setModel(jSpinnerJahrModel);
    cp.add(jSpinnerJahr);
    lMonat.setBounds(598, 128, 62, 20);
    lMonat.setText("Monat:");
    cp.add(lMonat);
    lTag.setBounds(533, 129, 46, 20);
    lTag.setText("Tag:");
    cp.add(lTag);
    jSpinnerMonat.setBounds(602, 161, 46, 24);
    jSpinnerMonat.setValue(1);
    jSpinnerMonat.setModel(jSpinnerMonatModel);
    cp.add(jSpinnerMonat);
    jSpinnerTag.setBounds(533, 160, 46, 24);
    jSpinnerTag.setValue(1);
    jSpinnerTag.setModel(jSpinnerTagModel);
    cp.add(jSpinnerTag);
    lGeburtstdatum.setBounds(533, 99, 110, 20);
    lGeburtstdatum.setText("Geburtstdatum:");
    cp.add(lGeburtstdatum);
    jSliderNotenschnitt.setBounds(185, 260, 302, 70);
    jSliderNotenschnitt.setMinorTickSpacing(1);
    jSliderNotenschnitt.setMajorTickSpacing(5);
    jSliderNotenschnitt.setPaintTicks(true);
    jSliderNotenschnitt.setPaintLabels(true);
    jSliderNotenschnitt.setMaximum(15);
    jSliderNotenschnitt.setSnapToTicks(true);
    jSliderNotenschnitt.setValue(7);
    cp.add(jSliderNotenschnitt);
    lNotendurchschnitt.setBounds(40, 272, 137, 33);
    lNotendurchschnitt.setText("Notendurchschnitt:");
    cp.add(lNotendurchschnitt);
    rbHeterosexuell.setBounds(187, 224, 100, 20);
    rbHeterosexuell.setOpaque(false);
    rbHeterosexuell.setText("heterosexuell");
    buttonGroup2.add(rbHeterosexuell);
    cp.add(rbHeterosexuell);
    rbHomosexuell.setBounds(304, 224, 100, 20);
    rbHomosexuell.setOpaque(false);
    rbHomosexuell.setText("homosexuell:");
    buttonGroup2.add(rbHomosexuell);
    cp.add(rbHomosexuell);
    lSexuelleOrientierung1.setBounds(40, 218, 153, 33);
    lSexuelleOrientierung1.setText("sexuelle Orientierung:");
    cp.add(lSexuelleOrientierung1);
    rbMaennlich.setBounds(304, 170, 100, 20);
    rbMaennlich.setOpaque(false);
    rbMaennlich.setText("männlich");
    buttonGroup1.add(rbMaennlich);
    cp.add(rbMaennlich);
    rbWeiblich.setBounds(187, 170, 100, 20);
    rbWeiblich.setOpaque(false);
    rbWeiblich.setText("weiblich");
    buttonGroup1.add(rbWeiblich);
    cp.add(rbWeiblich);
    lGeschlecht.setBounds(40, 166, 113, 33);
    lGeschlecht.setText("Geschlecht:");
    cp.add(lGeschlecht);
    jTextFieldName.setBounds(128, 96, 233, 33);
    cp.add(jTextFieldName);
    lName.setBounds(40, 96, 81, 33);
    lName.setText("Name:");
    cp.add(lName);
    lDating.setBounds(144, 24, 569, 41);
    lDating.setText("Dating-Portal des Gymnasiums Liebelei");
    lDating.setFont(new Font("Dialog", Font.BOLD, 16));
    lDating.setForeground(Color.MAGENTA);
    lDating.setHorizontalTextPosition(SwingConstants.CENTER);
    lDating.setHorizontalAlignment(SwingConstants.CENTER);
    cp.add(lDating);
    
    // Ende Komponenten
    
    setVisible(true);
  }
  
  // Anfang Methoden
  
  public static void main(String[] args) {
    new DatingPortal();
  }
  
  //Die beiden folgenden Methoden werden fuer eine ButtonGroup automatisch erzeugt, um die Beschriftung des ausgewaehlten RadioButtons abfragen zu koennen.
  public String buttonGroup1_getSelectedRadioButtonLabel() {
    for (java.util.Enumeration<AbstractButton> e = buttonGroup1.getElements(); e.hasMoreElements();) {
      AbstractButton b = e.nextElement();
      if (b.isSelected()) return b.getText();
    }
    return "";
  }

  public String buttonGroup2_getSelectedRadioButtonLabel() {
    for (java.util.Enumeration<AbstractButton> e = buttonGroup2.getElements(); e.hasMoreElements();) {
      AbstractButton b = e.nextElement();
      if (b.isSelected()) return b.getText();
    }
    return "";
  }

  public void bDatenschutzbestimmungen_ActionPerformed(ActionEvent evt) {
    if(bDatenschutzbestimmungen.getText().equals("Datenschutzbestimmungen")){
    jTextAreaAusgabe.setText("Datenschutzbestimmungen \n\n Welche Daten verarbeiten wir? \n Um unser Dating-Portal nutzen zu können, benötigen wir die wahrheitsgemäße Angabe Ihres Geschlechts,\n Ihrer sexuellen Orientierung, Ihres Geburtsdatums, Ihrers Lieblingsfachs und Ihres Notendurchschnitts. \n Die Angabe des Namens ist optional.\n\n Was passiert mit den Daten? \n Die erhobenen Daten werden ausschließlich für die Suche nach Ihrem perfekten Partner in unserer Datenbank verwendet. \n Die Verarbeitung erfolgt auf unserem Server in Musterstadt, Deutschland. \n Die Daten werden nicht an Dritte weitergegeben. Die Daten werden nicht ueber die Dauer Ihrer Sitzung hinaus gespeichert.\n\n Wer ist der Datenschutzbeauftragte?\n Bei Fragen zum Thema Datenschutz wenden Sie sich bitte an unseren Datenschutzbeauftragten Herrn Datafix (mail@datafix.org).");
      if(!dsAkzeptiert)bDatenschutzbestimmungen.setText("Akzeptieren");
    } else{ //Wenn der Button als mit "Akzeptieren" beschriftet ist.
    bSuchePartner.setEnabled(true);
    dsAkzeptiert = true;
    bDatenschutzbestimmungen.setText("Datenschutzbestimmungen");  
    } 
    
  }

  public void bSuchePartner_ActionPerformed(ActionEvent evt) {
     werteAuslesen(); //speichern der Benutzereingaben in den passenden Variablen, siehe unten
    String sql = sqlAnfrageBauen();  //erstellen der SQL-Anfrage, siehe unten 
    
    //hier wird die SQL-Anfrage an das DBManager-Objekt uebergeben. Das Ergebnis wird als zweidimensionale Reihung von Zeichenketten zurueck gegeben. Die oberste Zeile enthaelt die Spaltenueberschriften.
    //sql = "select * from hatkurs where punkte = 13";
    String[][] erg = myDBManager.sqlAnfrageAusfuehren(sql); 
    
    
    //Nun wird das Ergebnis fuer den Anwender ausgegeben.
    //falls beim Versuch die sql-Anfrage auszufuehren ein Fehler aufgetreten ist, steht an der Position 0|0 "Fehler". Diese Information wird an den Anwender weitergegeben.
    if(erg[0][0].equals("Fehler"))  
      jTextAreaAusgabe.setText("Es ist ein Fehler aufgetreten");
    else{
      String ausgabe = antwortBauen(erg); //hier wird das Abfrageergebnis als Text aufbereitet, siehe unten
      //Dieser Code kann verwendet werden, wenn alle Felder der zweidimensionalen Reihung systematisch ausgegeben werden sollen.
      /*for (int i = 0; i< erg.length ; i++) {
        for(int j = 0; j < erg[0].length; j++){
          ausgabe = ausgabe + erg[i][j] + " ";
        }
        ausgabe = ausgabe + "\n";
      } // end of for*/
      //Der Ausgabetext wird an die TextArea uebergeben, um ihn anzuzeigen
      jTextAreaAusgabe.setText(ausgabe);  
    }
    
  }
  
  //Diese Methode uebernimmt das Auslesen der Benutzereingabe.
  private void werteAuslesen(){
    //Der Name aus dem Textfeld wird in der Variablen name gespeichert.
    name = jTextFieldName.getText();      
    
    //je nachdem welcher Radiobutton fuer das Geschlecht ausgewaehlt ist, wird "w" fuer weiblich oder "m" fuer maennlich in der Variablen geschlecht gespeichert.
    if(rbWeiblich.isSelected()){
      geschlecht = "w";
    }else {
      geschlecht = "m";
    } // end of if-else
    
    //je nachdem welcher Radiobutton fuer die sexuelle Orientierung ausgewaehlt ist, wird "heterosexuell" bzw. "homosexuell" in der Variablen gespeichert. Da dies der Beschriftund der Radiobuttons entspricht, kann hier die vom JavaEditor zur Verfuegung gestellte Methode buttonGroupOrientierunetSelectedRadioButtonLabel() verwendet werden.
    orientierung = buttonGroup2_getSelectedRadioButtonLabel(); 
    
    //der Wert der am Schieberegler eingestellt ist, wird in der Variablen notendurchschnitt gespeichert
    notendurchschnitt = jSliderNotenschnitt.getValue();
    
    //Das Geburtstdatum soll gleich passend fuer die Datenbank in der Form JJJJMMTT gespeichert werden. Bei einstelligen Tag- bzw. Monatsangaben muss daher noch eine 0 vor der Ziffer ergaenzt werden.  Mit getValue liefern die jSpinner ein Object. Um an den Wert als Zeichenkette zu kommen, muss noch ein toString() angehaengt werden.
    String tag = "";
    String monat = "";
    if(Integer.parseInt(jSpinnerMonat.getValue().toString()) < 10) monat = "0";
    monat = monat + jSpinnerMonat.getValue();
    if(Integer.parseInt(jSpinnerTag.getValue().toString()) < 10) tag = "0";
    tag = tag + jSpinnerTag.getValue();
    
    //Die Variable gebDatum speichert das Geburtstdatum des Anwenders. 
    gebDatum = "" + jSpinnerJahr.getValue() + monat + tag;
    
    //In gebDatumMin bzw. gebDatumMax werden schon die passenden Datumsgrenzen fuer den Partner berechnet, der hoechstens zwei Jahre juenger oder aelter sein soll. Da man mit Zeichenketten nicht rechnen kann, muss das Jahr dazu zunaechst in einen Integer umgewandelt werden.
    gebDatumMin = (Integer.parseInt(jSpinnerJahr.getValue().toString()) - 2) +"-"+ monat +"-"+ tag;
    gebDatumMax = (Integer.parseInt(jSpinnerJahr.getValue().toString()) + 2) +"-"+ monat +"-"+ tag;
    
    //Auch die Combobox liefert das ausgewaehlte Element zunaechst als Object. Mit toString() erhaelt man die Angabe des Fachs als Zeichenkette.
    lieblingsfach = jComboBoxFach.getSelectedItem().toString();
    
    //nur fuer einen schnellen Test
    //System.out.println(lieblingsfach + jComboBoxLFach.getSelectedItem().toString() + "\n" + gebDatum);
  }
  
  //Der Partner soll die folgenden Kriterien erfuellen: Übereinstimmende sexuelle Orientierung und das passende Geschlecht. Das gleiche Lieblingsfach, maximal zwei Jahre juenger oder aelter und der Notendurchschnitt darf um maximal zwei Punkte nach oben oder unten abweichen. Dies wird in der folgenden Methode als sql-Anfrage formuliert.
  private String sqlAnfrageBauen(){
  String sql = "select Vorname, Name, Geburtstag from schueler, hatkurs where schueler.ID_nummer = hatkurs.ID_nummer and ";
    
    if(orientierung == "heterosexuell"){
       if (geschlecht == "w") sql = sql + "geschlecht = 'm' and Sexualitaet = 'heterosexuell' and ";
       else sql = sql + "geschlecht = 'w' and Sexualitaet = 'heterosexuell' and ";
    }else{
       if(geschlecht == "w") sql = sql + "geschlecht = 'w' and Sexualitaet = 'homosexuell' and ";
      else sql = sql + "geschlecht = 'm' and Sexualitaet = 'homosexuell' and ";
    }
    sql = sql + "lieblingsfach = '" + lieblingsfach + "' and ";
    sql = sql + "Geburtstag >= '" + gebDatumMin + "' and ";
    sql = sql + "Geburtstag <= '" + gebDatumMax + "' ";
    sql = sql + "group by schueler.ID_nummer having avg(punkte) > " +  (notendurchschnitt - 2) + " and avg(punkte) < " + (notendurchschnitt + 2);
    System.out.println(sql);
    return sql;
  }  
  
  /*Bei der Erzeugung des Antworttextes werden drei Faelle unterschieden, von denen nur einer eintreten kann.
   1. Fall: Die Ergebnisliste enthaelt nur die Spaltenueberschriften, aber keine Werte. Dann gibt es nur eine Zeile und es wurde kein Partner gefunden.
  2. Fall: Es wurde genau ein Partner gefunden. Dann gibt es zwei Zeilen in der Reihung.
  3. Fall: Es wurden mehrere passende Partner gefunden. Dann gibt es mehr als zwei Zeilen in der Reihung.
  Da die Attribute hinter select in der Reihenfolge Vorname, Name, Geburtstag abgefragt wurden, befindet sich an Spaltenindex 0
  der Vorname an Spaltenindex 1 der Name und an Spaltenindex 2 das Geburtsdatum. Hier koennen natuerlich nach belieben in der SQL-anfrage mehr Attribute angefordert und hier dann ausgegeben werden.
  */
   private String antwortBauen(String[][] dbErgebnis){
  
    String antwort = "Hallo " + name + ", ";
    if(dbErgebnis.length == 1) antwort = antwort + "leider haben wir keinen geeigneten Partner fuer dich gefunden.";
    
    if(dbErgebnis.length == 2) antwort = antwort + "der perfekte Partner oder die perfekte Partnerin für dich wäre " + dbErgebnis[1][0] + " " + dbErgebnis[1][1] + ", geboren am " + dbErgebnis[1][2] + ".";
    if(dbErgebnis.length > 2){
       antwort = antwort + "perfekte Partner oder Partnerinnen für dich wären \n";
       for (int i = 1; i < dbErgebnis.length; i++ ) {
          antwort = antwort + dbErgebnis[i][0] + " " + dbErgebnis[i][1] + ", geboren am " + dbErgebnis[i][2]; 
          if(!(i == dbErgebnis.length -1)) antwort = antwort + " \noder ";
          else antwort = antwort + ".";
       } // end of for
    }
    return antwort;
      
    }
  // Ende Methoden
}
