/**
 * Beschreibung: Vorlage zu Aufgabe 3 zur Huffman-Codierung inklusive Erstellung des Huffman-Baums
 * @version 1.0 vom 02.10.2025
 * @author Ylva Brandt
 */

import static javax.swing.JOptionPane.*;

BinTreeZMZ hufbaum = new BinTreeZMZ();

public void setup() {
  size(400, 320);
  background(230);
}

public void draw() {
}

public void keyTyped() {
  //Hinweis: Es muss zunächst ein Text codiert werden, bevor er decodiert werden kann
  if (key == 'c') {
    String text = showInputDialog("Welcher Text soll codiert werden?");
    hufbaum = erzeugeHuffman(text);
    println(codiere(text, hufbaum));
  }

  if (key == 'd') {
    String text = showInputDialog("Welcher Huffman-Code soll decodiert werden?");
    println(decodiere(text, hufbaum));
  }
}

//angepasste Lösung zu Aufgabe 1 (decodieren)
public String decodiere(String hufcode, BinTreeZMZ baum) {
  if (baum.isEmpty()) return "Fehler, der Huffman-Baum ist leer";
  String text = "";
  int zaehler = 0;
  while (zaehler < hufcode.length()) {
    BinTreeZMZ hilf = baum;
    while (!hilf.isLeaf()) {
      if (zaehler < hufcode.length()) {
        if (hufcode.charAt(zaehler) == '0')
          hilf = hilf.getLeft();
        else
          hilf = hilf.getRight();
        zaehler ++;
      } else break;
    }
    println(zaehler + " " + hilf.getItem().getZeichen());
    if (!hilf.isEmpty()) text = text + hilf.getItem().getZeichen();
    println(text + "\n --------------");
  }
  return text;
}

//angepasste Lösung zu Aufgabe 2 (codieren)
public String codiere(String text, BinTreeZMZ baum) {
  if (baum.isEmpty()) return "Fehler, der Huffman-Baum ist leer";
  String code = "";
  for (int i = 0; i < text.length(); i++) {
    BinTreeZMZ hilf = baum;
    char zeichen = text.charAt(i);
    while (!hilf.isLeaf()) {
      BinTreeZMZ left = hilf.getLeft();
      if (!left.isEmpty() && left.getItem().getZeichenkette().contains("" + zeichen)) { //Auf die erste Bedingung kann verzichtet werden, wenn man aufgrund der Konstruktion eines Huffman-Baums davon ausgeht, dass Knoten, die keine Blätter sind, immer zwei Kinder mit Inhalt haben
        code = code + "0";
        hilf = hilf.getLeft();
      } else {
        BinTreeZMZ right = hilf.getRight();
        if (!right.isEmpty() && right.getItem().getZeichenkette().contains("" + zeichen)) {
          code = code + "1";
          hilf = hilf.getRight();
        } else return "Fehler, es wurde ein Zeichen verwendet, das nicht im Baum enthalten ist";
      }
    }
  }
  return code;
}

public BinTreeZMZ erzeugeHuffman(String text) {
  //mögliches Vorgehen:
  //1. Zeichen im Text zählen


  //2. sortierte Reihung mit Blättern erstellen (Blätter = Objekte der Klasse BintTreeZMZ ohne Kinder, Inhalt ist jeweils ein Buchstaben mit der entsprechenden Anzahl

  //3. Huffman-Baum erzeugen, es werden jeweils die ersten zwei Teilbäume mit den kleinsten Wurzeln zu einem neuen Baum verbunden
  //die beiden Teilbäume werden entfernt und der neue Baum sortiert eingefügt

  return null;
}
