/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.util;

public class Num {
    public static final double DBL_EPSILON = 2.220446049250313E-16;
    public static final int DBL_MAX_EXP = 1024;
    public static final int DBL_MIN_EXP = -1021;
    public static final int DBL_MAX_10_EXP = 308;
    public static final int DBL_DIG = 15;
    public static final double EBASE = Math.E;
    public static final double RAC2 = 1.4142135623730951;
    public static final double IRAC2 = 0.7071067811865476;
    public static final double LN2 = 0.6931471805599453;
    public static final double ILN2 = 1.4426950408889634;
    public static final double MAXINTDOUBLE = 9.007199254740992E15;
    public static final double MAXTWOEXP = 64.0;
    public static final double[] TWOEXP = new double[]{1.0, 2.0, 4.0, 8.0, 16.0, 32.0, 64.0, 128.0, 256.0, 512.0, 1024.0, 2048.0, 4096.0, 8192.0, 16384.0, 32768.0, 65536.0, 131072.0, 262144.0, 524288.0, 1048576.0, 2097152.0, 4194304.0, 8388608.0, 1.6777216E7, 3.3554432E7, 6.7108864E7, 1.34217728E8, 2.68435456E8, 5.36870912E8, 1.073741824E9, 2.147483648E9, 4.294967296E9, 8.589934592E9, 1.7179869184E10, 3.4359738368E10, 6.8719476736E10, 1.37438953472E11, 2.74877906944E11, 5.49755813888E11, 1.099511627776E12, 2.199023255552E12, 4.398046511104E12, 8.796093022208E12, 1.7592186044416E13, 3.5184372088832E13, 7.0368744177664E13, 1.40737488355328E14, 2.81474976710656E14, 5.62949953421312E14, 1.125899906842624E15, 2.251799813685248E15, 4.503599627370496E15, 9.007199254740992E15, 1.8014398509481984E16, 3.602879701896397E16, 7.205759403792794E16, 1.4411518807585587E17, 2.8823037615171174E17, 5.764607523034235E17, 1.152921504606847E18, 2.305843009213694E18, 4.611686018427388E18, 9.223372036854776E18, 1.8446744073709552E19};

    private Num() {
    }

    public static double log2(double d) {
        return 1.4426950408889634 * Math.log(d);
    }

    public static double factorial(int n) {
        double d = 1.0;
        for (int i = 1; i <= n; ++i) {
            d *= (double)i;
        }
        return d;
    }

    public static double lnFactorial(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("LnFactorialle: n negative");
        }
        if (n == 0 || n == 1) {
            return 0.0;
        }
        if (n <= 14) {
            long l = 1L;
            long l2 = 1L;
            for (int i = 2; i <= n; ++i) {
                l *= ++l2;
            }
            return Math.log(l);
        }
        double d = n + 1;
        double d2 = 1.0 / (d * d);
        double d3 = ((-(5.95238095238E-4 * d2) + 7.936500793651E-4) * d2 - 0.0027777777777778) * d2 + 0.083333333333333;
        d3 = (d - 0.5) * Math.log(d) - d + 0.91893853320467 + d3 / d;
        return d3;
    }

    public static double lnGamma(double d) {
        double d2;
        double d3;
        double d4 = Math.log(Math.sqrt(Math.PI * 2));
        double[] dArray = new double[]{0.5285430369822346, 0.5498764461214141, 0.02073980061613665, -5.691677042154384E-4, 2.324587210400169E-5, -1.13060758570393E-6, 6.065653098948E-8, -3.4628435777E-9, 2.0624998806E-10, -1.266351116E-11, 7.9531007E-13, -5.082077E-14, 3.29187E-15, -2.1556E-16, 1.424E-17, -9.5E-19};
        if (d <= 0.0) {
            throw new IllegalArgumentException("lnGamma");
        }
        if (d > 18.0) {
            double d5 = d > 4.503599627370496E15 ? 0.0 : 1.0 / (d * d);
            double d6 = ((-(5.95238095238E-4 * d5) + 7.936500793651E-4) * d5 - 0.0027777777777778) * d5 + 0.083333333333333;
            d6 = (d - 0.5) * Math.log(d) - d + d4 + d6 / d;
            return d6;
        }
        if (d > 4.0) {
            int n = (int)d;
            d3 = d - (double)n;
            d2 = 1.0;
            for (int i = 3; i < n; ++i) {
                d2 *= d3 + (double)i;
            }
            d2 = Math.log(d2);
        } else {
            if (d <= 0.0) {
                return Double.MAX_VALUE;
            }
            if (d < 3.0) {
                int n = (int)d;
                d3 = d - (double)n;
                d2 = 1.0;
                for (int i = 2; i >= n; --i) {
                    d2 *= d3 + (double)i;
                }
                d2 = -Math.log(d2);
            } else {
                d3 = d - 3.0;
                d2 = 0.0;
            }
        }
        d3 = Num.evalCheby(dArray, 15, 2.0 * d3 - 1.0);
        return d3 + 0.9574186990510627 + d2;
    }

    public static double combination(int n, int n2) {
        if (n2 == 0 || n2 == n) {
            return 1.0;
        }
        if (n2 < 0) {
            System.err.println("combination:   s < 0");
        }
        if (n2 > n) {
            System.err.println("combination:   s > n");
        }
        if (n2 > n / 2) {
            n2 = n - n2;
        }
        if (n2 <= 15) {
            double d = 1.0;
            int n3 = n - n2;
            for (int i = 1; i <= n2; ++i) {
                d *= (double)(n3 + i) / (double)i;
            }
            return d;
        }
        double d = Num.lnFactorial(n) - Num.lnFactorial(n2) - Num.lnFactorial(n - n2);
        return Math.exp(d);
    }

    public static double[][] calcMatStirling(int n, int n2) {
        int n3;
        int n4;
        double[][] dArray = new double[n + 1][n2 + 1];
        for (n4 = 0; n4 <= n; ++n4) {
            for (n3 = 0; n3 <= n2; ++n3) {
                dArray[n4][n3] = 0.0;
            }
        }
        dArray[0][0] = 1.0;
        for (n3 = 1; n3 <= n2; ++n3) {
            int n5;
            dArray[0][n3] = 0.0;
            if (n3 <= n) {
                n5 = n3 - 1;
                dArray[n3][n3] = 1.0;
            } else {
                n5 = n;
            }
            for (n4 = 1; n4 <= n5; ++n4) {
                dArray[n4][n3] = (double)n4 * dArray[n4][n3 - 1] + dArray[n4 - 1][n3 - 1];
            }
        }
        return dArray;
    }

    public static double volumeSphere(double d, int n) {
        int n2 = (int)d;
        double d2 = n;
        if (d < 0.0) {
            throw new IllegalArgumentException("volumeSphere:   p < 0");
        }
        if (Math.abs(d - (double)n2) <= 4.440892098500626E-16) {
            switch (n2) {
                case 0: {
                    return TWOEXP[n];
                }
                case 1: {
                    return TWOEXP[n] / Num.factorial(n);
                }
                case 2: {
                    if (n % 2 == 0) {
                        return Math.pow(Math.PI, d2 / 2.0) / Num.factorial(n / 2);
                    }
                    int n3 = (n + 1) / 2;
                    return Math.pow(Math.PI, (double)n3 - 1.0) * Num.factorial(n3) * TWOEXP[2 * n3] / Num.factorial(2 * n3);
                }
            }
        }
        double d3 = d2 * (0.6931471805599453 + Num.lnGamma(1.0 + 1.0 / d)) - Num.lnGamma(1.0 + d2 / d);
        return Math.exp(d3);
    }

    public static double evalCheby(double[] dArray, int n, double d) {
        double d2 = 0.0;
        if (Math.abs(d) > 1.0) {
            System.err.println("Chebychev polynomial evaluated at x outside [-1, 1]");
        }
        double d3 = 2.0 * d;
        double d4 = 0.0;
        double d5 = 0.0;
        for (int i = n; i >= 0; --i) {
            d2 = d5;
            d5 = d4;
            d4 = d3 * d5 - d2 + dArray[i];
        }
        return (d4 - d2) / 2.0;
    }

    public static double besselK025(double d) {
        double[] dArray = new double[]{3.2177591145E10, 2.09933633952E12, 1.6281990144E13, 3.461195759616E13, 2.664028962816E13, 7.901666082816E12, 7.55914244096E11};
        double[] dArray2 = new double[]{7.5293843625E10, 2.8912835952E12, 1.8691126272E13, 3.68071409664E13, 2.7348959232E13, 7.9725330432E12, 7.55914244096E11};
        if (d < 1.0E-300) {
            return Double.MIN_VALUE;
        }
        if (d >= 0.6) {
            double d2 = dArray2[6];
            double d3 = dArray[6];
            for (int i = 6; i >= 1; --i) {
                d2 = d2 * d + dArray2[i - 1];
                d3 = d3 * d + dArray[i - 1];
            }
            double d4 = Math.sqrt(Math.PI / (2.0 * d)) * Math.exp(-d) * (d3 / d2);
            return d4;
        }
        double d5 = d * d;
        double d6 = Math.pow(d / 2.0, 0.25);
        double d7 = (((d5 / 1386.0 + 0.023809523809523808) * d5 + 0.3333333333333333) * d5 + 1.0) / (1.225416702465177 * d6);
        double d8 = (((d5 / 3510.0 + 0.011111111111111112) * d5 + 0.2) * d5 + 1.0) * d6 / 0.906402477055477;
        d7 = Math.PI * (d7 - d8) / 1.4142135623730951;
        return d7;
    }

    public static int multMod(int n, int n2, int n3, int n4) {
        long l = n;
        long l2 = n4;
        l = (l * (long)n2 + (long)n3) % l2;
        return (int)l;
    }

    public static long multMod(long l, long l2, long l3, long l4) {
        long l5;
        long l6;
        long l7;
        long l8;
        if (l < 0x80000000L) {
            l8 = l;
            l7 = 0L;
        } else {
            long l9 = l / 0x80000000L;
            l8 = l - 0x80000000L * l9;
            long l10 = l4 / 0x80000000L;
            long l11 = l4 - 0x80000000L * l10;
            if (l9 >= 0x80000000L) {
                l9 -= 0x80000000L;
                l6 = l2 / l10;
                for (l7 = 0x80000000L * (l2 - l6 * l10) - l6 * l11; l7 < 0L; l7 += l4) {
                }
            } else {
                l7 = 0L;
            }
            if (l9 != 0L) {
                l5 = l4 / l9;
                l6 = l2 / l5;
                if ((l7 -= l6 * (l4 - l9 * l5)) > 0L) {
                    l7 -= l4;
                }
                l7 += l9 * (l2 - l6 * l5);
                while (l7 < 0L) {
                    l7 += l4;
                }
            }
            l6 = l7 / l10;
            for (l7 = 0x80000000L * (l7 - l6 * l10) - l6 * l11; l7 < 0L; l7 += l4) {
            }
        }
        if (l8 != 0L) {
            l5 = l4 / l8;
            l6 = l2 / l5;
            if ((l7 -= l6 * (l4 - l8 * l5)) > 0L) {
                l7 -= l4;
            }
            l7 += l8 * (l2 - l6 * l5);
            while (l7 < 0L) {
                l7 += l4;
            }
        }
        if ((l7 = l7 - l4 + l3) < 0L) {
            l7 += l4;
        }
        return l7;
    }

    public static double multMod(double d, double d2, double d3, double d4) {
        int n;
        double d5 = d * d2 + d3;
        if (d5 >= 9.007199254740992E15 || -d5 >= 9.007199254740992E15) {
            n = (int)(d * 7.62939453125E-6);
            d -= (double)n * 131072.0;
            d5 = (double)n * d2;
            n = (int)(d5 / d4);
            d5 -= (double)n * d4;
            d5 = d5 * 131072.0 + d * d2 + d3;
        }
        n = (int)(d5 / d4);
        return d5 -= (double)n * d4;
    }
}

