/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.rng;

import umontreal.iro.lecuyer.rng.RandomStreamBase;
import umontreal.iro.lecuyer.rng.Rijndael_Algorithm;

public class RandRijndael
extends RandomStreamBase {
    private static final int BLOCK_SIZE = 16;
    private static final int JUMP_STREAM = 10;
    private static final int JUMP_SUBSTREAM = 5;
    private static Object key;
    private static byte[] curr_stream;
    private byte[] stream = new byte[16];
    private byte[] substream = new byte[16];
    private byte[] state = new byte[16];
    private byte[] output;
    private int outputPos;

    private static void iterate(byte[] byArray, int n) {
        while (n < byArray.length) {
            int n2 = n++;
            byArray[n2] = (byte)(byArray[n2] + 1);
            if (byArray[n2] == 0) continue;
        }
    }

    public RandRijndael() {
        for (int i = 0; i < 16; ++i) {
            this.stream[i] = curr_stream[i];
        }
        RandRijndael.iterate(curr_stream, 10);
        this.resetStartStream();
    }

    public RandRijndael(String string) {
        this();
        this.name = string;
    }

    public static void setPackageSeed(byte[] byArray) {
        if (byArray.length != 16) {
            throw new IllegalArgumentException("Seed must contain 16 values");
        }
        for (int i = 0; i < 16; ++i) {
            RandRijndael.curr_stream[i] = byArray[i];
        }
    }

    public void setSeed(byte[] byArray) {
        if (byArray.length != 16) {
            throw new IllegalArgumentException("Seed must contain 16 values");
        }
        for (int i = 0; i < 16; ++i) {
            this.stream[i] = byArray[i];
        }
    }

    public byte[] getState() {
        byte[] byArray = new byte[16];
        for (int i = 0; i < 16; ++i) {
            byArray[i] = this.state[i];
        }
        return byArray;
    }

    public void resetStartStream() {
        for (int i = 0; i < 16; ++i) {
            this.substream[i] = this.stream[i];
        }
        this.resetStartSubstream();
    }

    public void resetStartSubstream() {
        for (int i = 0; i < 16; ++i) {
            this.state[i] = this.substream[i];
        }
        this.nextOutput();
    }

    public void resetNextSubstream() {
        RandRijndael.iterate(this.substream, 5);
        this.resetStartSubstream();
    }

    public String formatState() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.name == null) {
            stringBuffer.append("The state of the RandRijn is : [");
        } else {
            stringBuffer.append("The state of the " + this.name + " is : [");
        }
        for (int i = 0; i < 15; ++i) {
            stringBuffer.append(this.state[i] + ", ");
        }
        stringBuffer.append(this.state[15] + "]  ");
        stringBuffer.append("position : " + this.outputPos);
        return stringBuffer.toString();
    }

    private void nextOutput() {
        this.output = Rijndael_Algorithm.blockEncrypt(this.state, 0, key, 16);
        this.outputPos = 0;
        RandRijndael.iterate(this.state, 0);
    }

    protected double nextValue() {
        if (this.outputPos > 12) {
            this.nextOutput();
        }
        long l = this.output[this.outputPos++] & 0xFF;
        l <<= 8;
        l |= (long)(this.output[this.outputPos++] & 0xFF);
        l <<= 8;
        l |= (long)(this.output[this.outputPos++] & 0xFF);
        l <<= 8;
        return ((double)(l |= (long)(this.output[this.outputPos++] & 0xFF)) + 1.0) / 4.294967297E9;
    }

    static {
        try {
            key = Rijndael_Algorithm.makeKey(new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16}, 16);
        }
        catch (Exception exception) {
            key = new Object[0];
            System.exit(1);
        }
        curr_stream = new byte[16];
        for (int i = 0; i < 16; ++i) {
            RandRijndael.curr_stream[i] = 0;
        }
    }
}

