/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.rng;

import umontreal.iro.lecuyer.rng.RandomStream;
import umontreal.iro.lecuyer.util.PrintfFormat;

public class RandMrg
implements RandomStream {
    private static final double m1 = 4.294967087E9;
    private static final double m2 = 4.294944443E9;
    private static final double a12 = 1403580.0;
    private static final double a13n = 810728.0;
    private static final double a21 = 527612.0;
    private static final double a23n = 1370589.0;
    private static final double two17 = 131072.0;
    private static final double two53 = 9.007199254740992E15;
    private static final double invtwo24 = 5.960464477539063E-8;
    private static final double norm = 2.328306549295728E-10;
    private static final double[][] InvA1 = new double[][]{{1.84888585E8, 0.0, 1.945170933E9}, {1.0, 0.0, 0.0}, {0.0, 1.0, 0.0}};
    private static final double[][] InvA2 = new double[][]{{0.0, 3.60363334E8, 4.225571728E9}, {1.0, 0.0, 0.0}, {0.0, 1.0, 0.0}};
    private static final double[][] A1p0 = new double[][]{{0.0, 1.0, 0.0}, {0.0, 0.0, 1.0}, {-810728.0, 1403580.0, 0.0}};
    private static final double[][] A2p0 = new double[][]{{0.0, 1.0, 0.0}, {0.0, 0.0, 1.0}, {-1370589.0, 0.0, 527612.0}};
    private static final double[][] A1p76 = new double[][]{{8.2758667E7, 1.871391091E9, 4.127413238E9}, {3.672831523E9, 6.9195019E7, 1.871391091E9}, {3.672091415E9, 3.528743235E9, 6.9195019E7}};
    private static final double[][] A2p76 = new double[][]{{1.511326704E9, 3.759209742E9, 1.610795712E9}, {4.292754251E9, 1.511326704E9, 3.889917532E9}, {3.859662829E9, 4.292754251E9, 3.70846608E9}};
    private static final double[][] A1p127 = new double[][]{{2.427906178E9, 3.580155704E9, 9.49770784E8}, {2.26153695E8, 1.230515664E9, 3.580155704E9}, {1.988835001E9, 9.86791581E8, 1.230515664E9}};
    private static final double[][] A2p127 = new double[][]{{1.464411153E9, 2.77697599E8, 1.610723613E9}, {3.218393E7, 1.464411153E9, 1.022607788E9}, {2.824425944E9, 3.218393E7, 2.093834863E9}};
    private static double[] nextSeed = new double[]{12345.0, 12345.0, 12345.0, 12345.0, 12345.0, 12345.0};
    private double[] Cg = new double[6];
    private double[] Bg = new double[6];
    private double[] Ig = new double[6];
    private boolean anti = false;
    private boolean prec53 = false;
    private String descriptor;

    private static double multModM(double d, double d2, double d3, double d4) {
        double d5;
        int n;
        double d6 = d * d2 + d3;
        if (d6 >= 9.007199254740992E15 || d6 <= -9.007199254740992E15) {
            n = (int)(d / 131072.0);
            d -= (double)n * 131072.0;
            d6 = (double)n * d2;
            n = (int)(d6 / d4);
            d6 -= (double)n * d4;
            d6 = d6 * 131072.0 + d * d2 + d3;
        }
        n = (int)(d6 / d4);
        d6 -= (double)n * d4;
        if (d5 < 0.0) {
            return d6 += d4;
        }
        return d6;
    }

    private static void matVecModM(double[][] dArray, double[] dArray2, double[] dArray3, double d) {
        int n;
        double[] dArray4 = new double[3];
        for (n = 0; n < 3; ++n) {
            dArray4[n] = RandMrg.multModM(dArray[n][0], dArray2[0], 0.0, d);
            dArray4[n] = RandMrg.multModM(dArray[n][1], dArray2[1], dArray4[n], d);
            dArray4[n] = RandMrg.multModM(dArray[n][2], dArray2[2], dArray4[n], d);
        }
        for (n = 0; n < 3; ++n) {
            dArray3[n] = dArray4[n];
        }
    }

    private static void matMatModM(double[][] dArray, double[][] dArray2, double[][] dArray3, double d) {
        int n;
        int n2;
        double[] dArray4 = new double[3];
        double[][] dArray5 = new double[3][3];
        for (n2 = 0; n2 < 3; ++n2) {
            for (n = 0; n < 3; ++n) {
                dArray4[n] = dArray2[n][n2];
            }
            RandMrg.matVecModM(dArray, dArray4, dArray4, d);
            for (n = 0; n < 3; ++n) {
                dArray5[n][n2] = dArray4[n];
            }
        }
        for (n2 = 0; n2 < 3; ++n2) {
            for (n = 0; n < 3; ++n) {
                dArray3[n2][n] = dArray5[n2][n];
            }
        }
    }

    private static void matTwoPowModM(double[][] dArray, double[][] dArray2, double d, int n) {
        int n2;
        if (dArray != dArray2) {
            for (n2 = 0; n2 < 3; ++n2) {
                for (int i = 0; i < 3; ++i) {
                    dArray2[n2][i] = dArray[n2][i];
                }
            }
        }
        for (n2 = 0; n2 < n; ++n2) {
            RandMrg.matMatModM(dArray2, dArray2, dArray2, d);
        }
    }

    private static void matPowModM(double[][] dArray, double[][] dArray2, double d, int n) {
        int n2;
        int n3 = n;
        double[][] dArray3 = new double[3][3];
        for (int i = 0; i < 3; ++i) {
            for (n2 = 0; n2 < 3; ++n2) {
                dArray3[i][n2] = dArray[i][n2];
                dArray2[i][n2] = 0.0;
            }
        }
        for (n2 = 0; n2 < 3; ++n2) {
            dArray2[n2][n2] = 1.0;
        }
        while (n3 > 0) {
            if (n3 % 2 == 1) {
                RandMrg.matMatModM(dArray3, dArray2, dArray2, d);
            }
            RandMrg.matMatModM(dArray3, dArray3, dArray3, d);
            n3 /= 2;
        }
    }

    private double U01() {
        int n;
        double d = 1403580.0 * this.Cg[1] - 810728.0 * this.Cg[0];
        if ((d -= (double)(n = (int)(d / 4.294967087E9)) * 4.294967087E9) < 0.0) {
            d += 4.294967087E9;
        }
        this.Cg[0] = this.Cg[1];
        this.Cg[1] = this.Cg[2];
        this.Cg[2] = d;
        double d2 = 527612.0 * this.Cg[5] - 1370589.0 * this.Cg[3];
        if ((d2 -= (double)(n = (int)(d2 / 4.294944443E9)) * 4.294944443E9) < 0.0) {
            d2 += 4.294944443E9;
        }
        this.Cg[3] = this.Cg[4];
        this.Cg[4] = this.Cg[5];
        this.Cg[5] = d2;
        double d3 = d > d2 ? (d - d2) * 2.328306549295728E-10 : (d - d2 + 4.294967087E9) * 2.328306549295728E-10;
        return this.anti ? 1.0 - d3 : d3;
    }

    private double U01d() {
        double d = this.U01();
        if (this.anti) {
            return (d += (this.U01() - 1.0) * 5.960464477539063E-8) < 0.0 ? d + 1.0 : d;
        }
        return (d += this.U01() * 5.960464477539063E-8) < 1.0 ? d : d - 1.0;
    }

    public RandMrg() {
        int n;
        for (int i = 0; i < 6; ++i) {
            this.Cg[i] = this.Ig[i] = nextSeed[i];
            this.Bg[i] = this.Ig[i];
        }
        RandMrg.matVecModM(A1p127, nextSeed, nextSeed, 4.294967087E9);
        double[] dArray = new double[3];
        for (n = 0; n < 3; ++n) {
            dArray[n] = nextSeed[n + 3];
        }
        RandMrg.matVecModM(A2p127, dArray, dArray, 4.294944443E9);
        for (n = 0; n < 3; ++n) {
            RandMrg.nextSeed[n + 3] = dArray[n];
        }
    }

    public RandMrg(String string) {
        this();
        this.descriptor = string;
    }

    public static void setPackageSeed(long[] lArray) {
        if (lArray.length != 6) {
            throw new IllegalArgumentException("Seed must contain 6 values");
        }
        if (lArray[0] == 0L && lArray[1] == 0L && lArray[2] == 0L) {
            throw new IllegalArgumentException("The first 3 values must not be 0");
        }
        if (lArray[5] == 0L && lArray[3] == 0L && lArray[4] == 0L) {
            throw new IllegalArgumentException("The last 3 values must not be 0");
        }
        if (lArray[0] >= 0xFFFFFF2FL || lArray[1] >= 0xFFFFFF2FL || lArray[2] >= 0xFFFFFF2FL) {
            throw new IllegalArgumentException("The first 3 values must be less than 4294967087");
        }
        if (lArray[5] >= 4294944443L || lArray[3] >= 4294944443L || lArray[4] >= 4294944443L) {
            throw new IllegalArgumentException("The last 3 values must be less than 4294944443");
        }
        for (int i = 0; i < 6; ++i) {
            RandMrg.nextSeed[i] = lArray[i];
        }
    }

    public void resetStartStream() {
        for (int i = 0; i < 6; ++i) {
            this.Cg[i] = this.Bg[i] = this.Ig[i];
        }
    }

    public void resetStartSubstream() {
        for (int i = 0; i < 6; ++i) {
            this.Cg[i] = this.Bg[i];
        }
    }

    public void resetNextSubstream() {
        int n;
        RandMrg.matVecModM(A1p76, this.Bg, this.Bg, 4.294967087E9);
        double[] dArray = new double[3];
        for (n = 0; n < 3; ++n) {
            dArray[n] = this.Bg[n + 3];
        }
        RandMrg.matVecModM(A2p76, dArray, dArray, 4.294944443E9);
        for (n = 0; n < 3; ++n) {
            this.Bg[n + 3] = dArray[n];
        }
        for (n = 0; n < 6; ++n) {
            this.Cg[n] = this.Bg[n];
        }
    }

    public void increasedPrecis(boolean bl) {
        this.prec53 = bl;
    }

    public void setAntithetic(boolean bl) {
        this.anti = bl;
    }

    public void advanceState(int n, int n2) {
        int n3;
        double[][] dArray = new double[3][3];
        double[][] dArray2 = new double[3][3];
        double[][] dArray3 = new double[3][3];
        double[][] dArray4 = new double[3][3];
        if (n > 0) {
            RandMrg.matTwoPowModM(A1p0, dArray, 4.294967087E9, n);
            RandMrg.matTwoPowModM(A2p0, dArray3, 4.294944443E9, n);
        } else if (n < 0) {
            RandMrg.matTwoPowModM(InvA1, dArray, 4.294967087E9, -n);
            RandMrg.matTwoPowModM(InvA2, dArray3, 4.294944443E9, -n);
        }
        if (n2 >= 0) {
            RandMrg.matPowModM(A1p0, dArray2, 4.294967087E9, n2);
            RandMrg.matPowModM(A2p0, dArray4, 4.294944443E9, n2);
        } else {
            RandMrg.matPowModM(InvA1, dArray2, 4.294967087E9, -n2);
            RandMrg.matPowModM(InvA2, dArray4, 4.294944443E9, -n2);
        }
        if (n != 0) {
            RandMrg.matMatModM(dArray, dArray2, dArray2, 4.294967087E9);
            RandMrg.matMatModM(dArray3, dArray4, dArray4, 4.294944443E9);
        }
        RandMrg.matVecModM(dArray2, this.Cg, this.Cg, 4.294967087E9);
        double[] dArray5 = new double[3];
        for (n3 = 0; n3 < 3; ++n3) {
            dArray5[n3] = this.Cg[n3 + 3];
        }
        RandMrg.matVecModM(dArray4, dArray5, dArray5, 4.294944443E9);
        for (n3 = 0; n3 < 3; ++n3) {
            this.Cg[n3 + 3] = dArray5[n3];
        }
    }

    public void setSeed(long[] lArray) {
        if (lArray.length != 6) {
            throw new IllegalArgumentException("Seed must contain 6 values");
        }
        if (lArray[0] == 0L && lArray[1] == 0L && lArray[2] == 0L) {
            throw new IllegalArgumentException("The first 3 values must not be 0");
        }
        if (lArray[3] == 0L && lArray[4] == 0L && lArray[5] == 0L) {
            throw new IllegalArgumentException("The last 3 values must not be 0");
        }
        if (lArray[0] >= 0xFFFFFF2FL || lArray[1] >= 0xFFFFFF2FL || lArray[2] >= 0xFFFFFF2FL) {
            throw new IllegalArgumentException("The first 3 values must be less than 4294967087");
        }
        if (lArray[3] >= 4294944443L || lArray[4] >= 4294944443L || lArray[5] >= 4294944443L) {
            throw new IllegalArgumentException("The last 3 values must be less than 4294944443");
        }
        for (int i = 0; i < 6; ++i) {
            this.Bg[i] = this.Ig[i] = (double)lArray[i];
            this.Cg[i] = this.Ig[i];
        }
    }

    public double[] getState() {
        return this.Cg;
    }

    public String formatState() {
        PrintfFormat printfFormat = new PrintfFormat();
        printfFormat.append("The current state of the RandMrg");
        if (this.descriptor != null && this.descriptor.length() > 0) {
            printfFormat.append(" " + this.descriptor);
        }
        printfFormat.append(":\n   Cg = { ");
        for (int i = 0; i < 5; ++i) {
            printfFormat.append((long)this.Cg[i] + ", ");
        }
        printfFormat.append((long)this.Cg[5] + " }\n\n");
        return printfFormat.toString();
    }

    public String formatStateFull() {
        int n;
        PrintfFormat printfFormat = new PrintfFormat();
        printfFormat.append("The RandMrg");
        if (this.descriptor != null && this.descriptor.length() > 0) {
            printfFormat.append(" " + this.descriptor);
        }
        printfFormat.append(":\n   anti = " + (this.anti ? "true" : "false")).append('\n');
        printfFormat.append("   Ig = { ");
        for (n = 0; n < 5; ++n) {
            printfFormat.append((long)this.Ig[n] + ", ");
        }
        printfFormat.append((long)this.Ig[5] + " }\n");
        printfFormat.append("   Bg = { ");
        for (n = 0; n < 5; ++n) {
            printfFormat.append((long)this.Bg[n] + ", ");
        }
        printfFormat.append((long)this.Bg[5] + " }\n");
        printfFormat.append("   Cg = { ");
        for (n = 0; n < 5; ++n) {
            printfFormat.append((long)this.Cg[n] + ", ");
        }
        printfFormat.append((long)this.Cg[5] + " }\n\n");
        return printfFormat.toString();
    }

    public double nextDouble() {
        if (this.prec53) {
            return this.U01d();
        }
        return this.U01();
    }

    public void nextArrayOfDouble(double[] dArray, int n, int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("n must be positive.");
        }
        for (int i = n; i < n + n2; ++i) {
            dArray[i] = this.nextDouble();
        }
    }

    public int nextInt(int n, int n2) {
        return n + (int)(this.nextDouble() * ((double)(n2 - n) + 1.0));
    }

    public void nextArrayOfInt(int n, int n2, int[] nArray, int n3, int n4) {
        if (n4 <= 0) {
            throw new IllegalArgumentException("n must be positive.");
        }
        for (int i = n3; i < n3 + n4; ++i) {
            nArray[i] = this.nextInt(n, n2);
        }
    }
}

