/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import umontreal.iro.lecuyer.probdist.ContinuousDistribution;

public class WeibullDist
extends ContinuousDistribution {
    private double alpha;
    private double lambda;
    private double delta;

    public WeibullDist(double d) {
        this.setParams(d, 1.0, 0.0);
    }

    public WeibullDist(double d, double d2, double d3) {
        this.setParams(d, d2, d3);
    }

    public double density(double d) {
        return WeibullDist.density(this.alpha, this.lambda, this.delta, d);
    }

    public double cdf(double d) {
        return WeibullDist.cdf(this.alpha, this.lambda, this.delta, d);
    }

    public double barF(double d) {
        return WeibullDist.barF(this.alpha, this.lambda, this.delta, d);
    }

    public double inverseF(double d) {
        return WeibullDist.inverseF(this.alpha, this.lambda, this.delta, d);
    }

    public static double density(double d, double d2, double d3, double d4) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        return d4 <= d3 ? 0.0 : d * Math.pow(d2, d) * Math.pow(d4 - d3, d - 1.0) * Math.exp(-Math.pow(d2 * (d4 - d3), d));
    }

    public static double density(double d, double d2) {
        return WeibullDist.density(d, 1.0, 0.0, d2);
    }

    public static double cdf(double d, double d2, double d3, double d4) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        if (d4 <= d3) {
            return 0.0;
        }
        if (d >= 1.0 && d2 * (d4 - d3) >= 1000.0) {
            return 1.0;
        }
        double d5 = Math.pow(d2 * (d4 - d3), d);
        if (d5 >= 1000.0) {
            return 1.0;
        }
        return 1.0 - Math.exp(-d5);
    }

    public static double cdf(double d, double d2) {
        return WeibullDist.cdf(d, 1.0, 0.0, d2);
    }

    public static double barF(double d, double d2, double d3, double d4) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        if (d4 <= 0.0) {
            return 1.0;
        }
        if (d >= 1.0 && d4 >= 2048.0) {
            return 0.0;
        }
        double d5 = Math.pow(d2 * (d4 - d3), d);
        if (d5 >= 2048.0) {
            return 0.0;
        }
        return Math.exp(-d5);
    }

    public static double barF(double d, double d2) {
        return WeibullDist.barF(d, 1.0, 0.0, d2);
    }

    public static double inverseF(double d, double d2, double d3, double d4) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        if (d4 < 0.0 || d4 > 1.0) {
            throw new IllegalArgumentException("u not in [0, 1]");
        }
        if (d4 <= 0.0) {
            return 0.0;
        }
        if (d4 >= 1.0) {
            throw new ArithmeticException("inverse function cannot be positive infinity");
        }
        double d5 = -Math.log(1.0 - d4);
        if (Math.log(d5) / Math.log(10.0) >= d * 308.0) {
            throw new ArithmeticException("inverse function cannot be positive infinity");
        }
        return Math.pow(d5, 1.0 / d) / d2 + d3;
    }

    public static double inverseF(double d, double d2) {
        return WeibullDist.inverseF(d, 1.0, 0.0, d2);
    }

    public double getAlpha() {
        return this.alpha;
    }

    public double getLambda() {
        return this.lambda;
    }

    public double getDelta() {
        return this.delta;
    }

    public void setParams(double d, double d2, double d3) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        this.alpha = d;
        this.lambda = d2;
        this.delta = d3;
    }
}

