/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import umontreal.iro.lecuyer.probdist.DiscreteDistributionInt;
import umontreal.iro.lecuyer.probdist.GammaDist;
import umontreal.iro.lecuyer.util.Num;

public class PoissonDist
extends DiscreteDistributionInt {
    private double lambda;
    public static double MAXLAMBDA = 100000.0;

    public PoissonDist(double d) {
        this.setLambda(d);
    }

    public double prob(int n) {
        if (n < 0) {
            return 0.0;
        }
        if (this.pdf == null) {
            return PoissonDist.prob(this.lambda, n);
        }
        if (n > this.xmax || n < this.xmin) {
            return PoissonDist.prob(this.lambda, n);
        }
        return this.pdf[n - this.xmin];
    }

    public double cdf(int n) {
        if (n < 0) {
            return 0.0;
        }
        if (this.lambda == 0.0) {
            return 1.0;
        }
        if (this.cdf == null) {
            return GammaDist.barF((double)n + 1.0, 15, this.lambda);
        }
        if (n >= this.xmax) {
            return 1.0;
        }
        if (n < this.xmin) {
            double d = 0.0;
            for (int i = n; i > n - 5 && i >= 0; --i) {
                d += PoissonDist.prob(this.lambda, i);
            }
            return d;
        }
        if (n <= this.xmed) {
            return this.cdf[n - this.xmin];
        }
        return 1.0 - this.cdf[n + 1 - this.xmin];
    }

    public double barF(int n) {
        if (n <= 0) {
            return 1.0;
        }
        if (this.cdf == null) {
            return GammaDist.cdf(n, 15, this.lambda);
        }
        if (n > this.xmax) {
            return GammaDist.cdf(n, 15, this.lambda);
        }
        if (n <= this.xmin) {
            return 1.0;
        }
        if (n > this.xmed) {
            return this.cdf[n - this.xmin];
        }
        return 1.0 - this.cdf[n - 1 - this.xmin];
    }

    public int inverseF(double d) {
        if (this.cdf == null) {
            return PoissonDist.inverseF(this.lambda, d);
        }
        return super.inverseF(d);
    }

    public static double prob(double d, int n) {
        double d2;
        if (n < 0) {
            return 0.0;
        }
        if (d < 20.0) {
            d2 = Math.exp(-d) * Math.pow(d, n) / Num.factorial(n);
        } else {
            double d3 = (double)n * Math.log(d) - Num.lnGamma((double)n + 1.0) - d;
            d2 = Math.exp(d3);
        }
        return d2;
    }

    public static double cdf(double d, int n) {
        if (d < 0.0) {
            throw new IllegalArgumentException("lambda < 0");
        }
        if (d == 0.0) {
            return 1.0;
        }
        if (n < 0) {
            return 0.0;
        }
        if (d > 150.0) {
            return GammaDist.barF((double)n + 1.0, 15, d);
        }
        double d2 = 1.0;
        double d3 = 1.0;
        for (int i = 1; i <= n; ++i) {
            d3 += (d2 *= d / (double)i);
        }
        return Math.exp(-d) * d3;
    }

    public static double barF(double d, int n) {
        double d2;
        if (d < 0.0) {
            throw new IllegalArgumentException("lambda < 0");
        }
        if (n <= 0) {
            return 1.0;
        }
        if (d > 150.0) {
            return GammaDist.cdf(n, 15, d);
        }
        double d3 = d2 = Math.exp((double)n * Math.log(d) - Num.lnFactorial(n));
        int n2 = n + 1;
        while (d2 > DiscreteDistributionInt.EPSILON) {
            d3 += (d2 *= d / (double)n2);
            ++n2;
        }
        return Math.exp(-d) * d3;
    }

    public static int inverseF(double d, double d2) {
        if (d2 < 0.0 || d2 > 1.0) {
            throw new IllegalArgumentException("u is not in range [0,1]");
        }
        if (d < 0.0) {
            throw new IllegalArgumentException("lambda < 0");
        }
        int n = 0;
        if (d > 150.0) {
            while (GammaDist.barF((double)n + 1.0, 15, d) < d2) {
                ++n;
            }
            return n;
        }
        d2 *= Math.exp(d);
        double d3 = 1.0;
        for (double d4 = 1.0; d4 < d2; d4 += (d3 *= d / (double)(++n))) {
        }
        return n;
    }

    public double getLambda() {
        return this.lambda;
    }

    public void setLambda(double d) {
        int n;
        int n2;
        if (d < 0.0) {
            throw new IllegalArgumentException("lambda < 0");
        }
        this.lambda = d;
        if (d > MAXLAMBDA) {
            this.pdf = null;
            this.cdf = null;
            return;
        }
        int n3 = (int)(d + 16.0 * (2.0 + Math.sqrt(d)));
        double[] dArray = new double[1 + n3];
        double[] dArray2 = new double[1 + n3];
        int n4 = (int)d;
        double d2 = EPSILON / PoissonDist.prob(d, n4);
        dArray[n4] = 1.0;
        double d3 = 1.0;
        int n5 = n4;
        while (n5 > 0 && dArray[n5] > d2) {
            dArray[n5 - 1] = dArray[n5] * (double)n5 / d;
            d3 += dArray[--n5];
        }
        this.xmin = n2 = n5;
        n5 = n4;
        while (dArray[n5] > d2) {
            dArray[n5 + 1] = dArray[n5] * d / (double)(n5 + 1);
            d3 += dArray[++n5];
            if (n5 < n3 - 1) continue;
            double[] dArray3 = new double[1 + (n3 *= 2)];
            System.arraycopy(dArray, 0, dArray3, 0, dArray.length);
            dArray = dArray3;
            dArray3 = new double[1 + n3];
            System.arraycopy(dArray2, 0, dArray3, 0, dArray2.length);
            dArray2 = dArray3;
        }
        this.xmax = n = n5;
        n5 = n2;
        while (n5 <= n) {
            int n6 = n5++;
            dArray[n6] = dArray[n6] / d3;
        }
        dArray2[n2] = dArray[n2];
        n5 = n2;
        while (n5 < n && dArray2[n5] < 0.5) {
            dArray2[++n5] = dArray[n5] + dArray2[n5 - 1];
        }
        this.xmed = n5;
        dArray2[n] = dArray[n];
        n5 = n - 1;
        do {
            dArray2[n5] = dArray[n5] + dArray2[n5 + 1];
        } while (--n5 > this.xmed);
        this.pdf = new double[n + 1 - n2];
        this.cdf = new double[n + 1 - n2];
        System.arraycopy(dArray, n2, this.pdf, 0, n - n2 + 1);
        System.arraycopy(dArray2, n2, this.cdf, 0, n - n2 + 1);
    }
}

