/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import umontreal.iro.lecuyer.probdist.DiscreteDistributionInt;

public class LogarithmicDist
extends DiscreteDistributionInt {
    private double theta;
    private double t;

    public LogarithmicDist(double d) {
        this.setTheta(d);
    }

    public double prob(int n) {
        if (n < 1) {
            return 0.0;
        }
        return -this.t * Math.pow(this.theta, n) / (double)n;
    }

    public double cdf(int n) {
        double d;
        if (n < 1) {
            return 0.0;
        }
        double d2 = d = this.prob(1);
        for (int i = 2; i <= n; ++i) {
            d += (d2 *= this.theta * (double)(i - 1) / (double)i);
        }
        return d;
    }

    public double barF(int n) {
        double d;
        if (n < 1) {
            return 1.0;
        }
        double d2 = d = this.prob(n);
        int n2 = n + 1;
        while (d2 > EPSILON) {
            d += (d2 *= this.theta * (double)(n2 - 1) / (double)n2);
        }
        return d;
    }

    public int inverseF(double d) {
        return LogarithmicDist.inverseF(this.theta, d);
    }

    public static double prob(double d, int n) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("theta not in range (0,1)");
        }
        if (n < 1) {
            return 0.0;
        }
        return -Math.log(1.0 - d) * Math.pow(d, n) / (double)n;
    }

    public static double cdf(double d, int n) {
        double d2;
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("theta not in range (0,1)");
        }
        if (n < 1) {
            return 0.0;
        }
        double d3 = d2 = LogarithmicDist.prob(d, 1);
        for (int i = 2; i <= n; ++i) {
            d2 += (d3 *= d * (double)(i - 1) / (double)i);
        }
        return d2;
    }

    public static double barF(double d, int n) {
        double d2;
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("theta not in range (0,1)");
        }
        if (n < 1) {
            return 1.0;
        }
        double d3 = d2 = LogarithmicDist.prob(d, n);
        int n2 = n + 1;
        while (d3 > EPSILON) {
            d2 += (d3 *= d * (double)(n2 - 1) / (double)n2);
        }
        return d2;
    }

    public static int inverseF(double d, double d2) {
        throw new UnsupportedOperationException();
    }

    public double getTheta() {
        return this.theta;
    }

    public void setTheta(double d) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("theta not in range (0,1)");
        }
        this.theta = d;
        this.t = Math.log(1.0 - d);
    }
}

