/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import umontreal.iro.lecuyer.probdist.ContinuousDistribution;
import umontreal.iro.lecuyer.probdist.NormalDist;

public class JohnsonSUDist
extends ContinuousDistribution {
    private double gamma;
    private double delta;
    private double xi;
    private double lambda;

    public JohnsonSUDist(double d, double d2) {
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("delta <= 0");
        }
        this.gamma = d;
        this.delta = d2;
        this.xi = 0.0;
        this.lambda = 1.0;
    }

    public JohnsonSUDist(double d, double d2, double d3, double d4) {
        this.setParams(d, d2, d3, d4);
    }

    public double density(double d) {
        return JohnsonSUDist.density(this.gamma, this.delta, this.xi, this.lambda, d);
    }

    public double cdf(double d) {
        return JohnsonSUDist.cdf(this.gamma, this.delta, this.xi, this.lambda, d);
    }

    public double inverseF(double d) {
        return JohnsonSUDist.inverseF(this.gamma, this.delta, this.xi, this.lambda, d);
    }

    public static double density(double d, double d2, double d3, double d4, double d5) {
        if (d4 <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("delta <= 0");
        }
        double d6 = (d5 - d3) / d4;
        double d7 = d6 >= 0.0 ? (d5 < 1.0E30 ? d6 + Math.sqrt(d6 * d6 + 1.0) : 2.0 * d6) : ((d6 = -d6) < 1.0E30 ? 1.0 / (d6 + Math.sqrt(d6 * d6 + 1.0)) : 1.0 / (2.0 * d6));
        double d8 = d + d2 * Math.log(d7);
        return d2 / (d4 * Math.sqrt(Math.PI * 2) * Math.sqrt(d6 * d6 + 1.0)) * Math.exp(-d8 * d8 / 2.0);
    }

    public static double cdf(double d, double d2, double d3, double d4, double d5) {
        if (d4 <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("delta <= 0");
        }
        double d6 = (d5 - d3) / d4;
        double d7 = d6 >= 0.0 ? (d5 < 1.0E30 ? d6 + Math.sqrt(d6 * d6 + 1.0) : 2.0 * d6) : ((d6 = -d6) < 1.0E30 ? 1.0 / (d6 + Math.sqrt(d6 * d6 + 1.0)) : 1.0 / (2.0 * d6));
        return NormalDist.cdf01(d + d2 * Math.log(d7));
    }

    public static double barF(double d, double d2, double d3, double d4, double d5) {
        if (d4 <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("delta <= 0");
        }
        double d6 = (d5 - d3) / d4;
        double d7 = d6 >= 0.0 ? (d5 < 1.0E30 ? d6 + Math.sqrt(d6 * d6 + 1.0) : 2.0 * d6) : ((d6 = -d6) < 1.0E30 ? 1.0 / (d6 + Math.sqrt(d6 * d6 + 1.0)) : 1.0 / (2.0 * d6));
        return NormalDist.barF01(d + d2 * Math.log(d7));
    }

    public static double inverseF(double d, double d2, double d3, double d4, double d5) {
        if (d4 <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("delta <= 0");
        }
        if (d5 > 1.0 || d5 < 0.0) {
            throw new IllegalArgumentException("u not in [0,1]");
        }
        double d6 = NormalDist.inverseF01(d5);
        if (d6 >= 1000.0) {
            throw new ArithmeticException("inverse cannot be positive infinity");
        }
        if (d6 <= -1000.0) {
            throw new ArithmeticException("inverse cannot be negative infinity");
        }
        double d7 = (d6 - d) / d2;
        if (d7 >= 709.782712893384) {
            throw new ArithmeticException("inverse cannot be positive infinity");
        }
        if (d7 <= -707.7032713517042) {
            throw new ArithmeticException("Inverse cannot be negative infinity");
        }
        d6 = Math.exp(d7);
        return d3 + d4 * (d6 * d6 - 1.0) / (2.0 * d6);
    }

    public double getGamma() {
        return this.gamma;
    }

    public double getDelta() {
        return this.delta;
    }

    public double getXi() {
        return this.xi;
    }

    public double getLambda() {
        return this.lambda;
    }

    public void setParams(double d, double d2, double d3, double d4) {
        if (d4 <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("delta <= 0");
        }
        this.gamma = d;
        this.delta = d2;
        this.xi = d3;
        this.lambda = d4;
    }
}

