/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import umontreal.iro.lecuyer.probdist.ContinuousDistribution;
import umontreal.iro.lecuyer.probdist.GammaDist;
import umontreal.iro.lecuyer.util.Num;

public class ChiDist
extends ContinuousDistribution {
    private int nu;

    public ChiDist(int n) {
        this.setNu(n);
    }

    public double density(double d) {
        return ChiDist.density(this.nu, d);
    }

    public double cdf(double d) {
        return ChiDist.cdf(this.nu, d);
    }

    public double barF(double d) {
        return ChiDist.barF(this.nu, d);
    }

    public double inverseF(double d) {
        return ChiDist.inverseF(this.nu, d);
    }

    public static double density(int n, double d) {
        if (n <= 0) {
            throw new IllegalArgumentException("nu <= 0");
        }
        if (d <= 0.0) {
            return 0.0;
        }
        return Math.exp((double)(n - 1) * Math.log(d) - d * d / 2.0 - ((double)n / 2.0 - 1.0) * 0.6931471805599453 - Num.lnGamma((double)n / 2.0));
    }

    public static double cdf(int n, double d) {
        if (d <= 0.0) {
            return 0.0;
        }
        return GammaDist.cdf((double)n / 2.0, 15, d * d / 2.0);
    }

    public static double barF(int n, double d) {
        if (d <= 0.0) {
            return 1.0;
        }
        return GammaDist.barF((double)n / 2.0, 15, d * d / 2.0);
    }

    public static double inverseF(int n, double d) {
        double d2 = GammaDist.inverseF((double)n / 2.0, 15, d);
        return Math.sqrt(2.0 * d2);
    }

    public int getNu() {
        return this.nu;
    }

    public void setNu(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("nu <= 0");
        }
        this.nu = n;
    }
}

