/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import umontreal.iro.lecuyer.probdist.DiscreteDistributionInt;
import umontreal.iro.lecuyer.probdist.NormalDist;
import umontreal.iro.lecuyer.probdist.PoissonDist;
import umontreal.iro.lecuyer.util.Num;

public class BinomialDist
extends DiscreteDistributionInt {
    private int n;
    private double p;
    private double q;
    public static double MAXN = 100000.0;

    public BinomialDist(int n, double d) {
        this.setBinomial(n, d);
    }

    public double prob(int n) {
        if (this.n == 0) {
            return 1.0;
        }
        if (n < 0 || n > this.n) {
            return 0.0;
        }
        if (this.p == 0.0) {
            if (n > 0) {
                return 0.0;
            }
            return 1.0;
        }
        if (this.q == 0.0) {
            if (n < this.n) {
                return 0.0;
            }
            return 1.0;
        }
        if (this.pdf == null) {
            return BinomialDist.prob(this.n, this.p, this.q, n);
        }
        if (n > this.xmax || n < this.xmin) {
            return BinomialDist.prob(this.n, this.p, this.q, n);
        }
        return this.pdf[n - this.xmin];
    }

    public double cdf(int n) {
        if (this.p < 0.0 || this.p > 1.0) {
            throw new IllegalArgumentException("p not in [0,1]");
        }
        if (this.n == 0) {
            return 1.0;
        }
        if (n < 0) {
            return 0.0;
        }
        if (n >= this.n) {
            return 1.0;
        }
        if (this.p == 0.0) {
            return 1.0;
        }
        if (this.p == 1.0) {
            return 0.0;
        }
        if (this.cdf != null) {
            if (n >= this.xmax) {
                return 1.0;
            }
            if (n < this.xmin) {
                return BinomialDist.cdf(this.n, this.p, n);
            }
            if (n <= this.xmed) {
                return this.cdf[n - this.xmin];
            }
            return 1.0 - this.cdf[n + 1 - this.xmin];
        }
        return BinomialDist.cdf(this.n, this.p, n);
    }

    public double barF(int n) {
        if (this.p < 0.0 || this.p > 1.0) {
            throw new IllegalArgumentException("p not in [0,1]");
        }
        if (this.n == 0) {
            return 1.0;
        }
        if (n < 1) {
            return 1.0;
        }
        if (n > this.n) {
            return 0.0;
        }
        if (this.p == 0.0) {
            return 0.0;
        }
        if (this.p == 1.0) {
            return 1.0;
        }
        if (this.cdf != null) {
            if (n > this.xmax) {
                return 0.0;
            }
            if (n <= this.xmin) {
                return 1.0;
            }
            if (n > this.xmed) {
                return this.cdf[n - this.xmin];
            }
            return 1.0 - this.cdf[n - 1 - this.xmin];
        }
        return 1.0 - BinomialDist.cdf(this.n, this.p, n);
    }

    public int inverseF(double d) {
        if (this.cdf == null) {
            return BinomialDist.inverseF(this.n, this.p, d);
        }
        return super.inverseF(d);
    }

    public static double prob(int n, double d, int n2) {
        return BinomialDist.prob(n, d, 1.0 - d, n2);
    }

    public static double prob(int n, double d, double d2, int n2) {
        double d3;
        int n3 = 1;
        if (n < 0) {
            throw new IllegalArgumentException("n < 0");
        }
        if (n == 0) {
            return 1.0;
        }
        if (n2 < 0 || n2 > n) {
            return 0.0;
        }
        if (n2 > n / 2) {
            n2 = n - n2;
            d3 = d;
            d = d2;
            d2 = d3;
        }
        if (d < 0.0) {
            d = -d;
            if ((n2 & 1) != 0) {
                n3 *= -1;
            }
        }
        if (d2 < 0.0) {
            d2 = -d2;
            if ((n - n2 & 1) != 0) {
                n3 *= -1;
            }
        }
        if (n2 <= 15) {
            d3 = Math.pow(d, n2) * Num.combination(n, n2) * Math.pow(d2, n - n2);
            return (double)n3 * d3;
        }
        d3 = (double)n2 * Math.log(d) + (double)(n - n2) * Math.log(d2) + Num.lnFactorial(n) - Num.lnFactorial(n - n2) - Num.lnFactorial(n2);
        if (d3 >= 709.0895657128241) {
            throw new IllegalArgumentException("term overflow");
        }
        if (d3 < -708.3964185322641) {
            return 0.0;
        }
        return (double)n3 * Math.exp(d3);
    }

    public static double cdf(int n, double d, int n2) {
        double d2 = DiscreteDistributionInt.EPSILON;
        double d3 = 1.0 - d;
        boolean bl = false;
        if (d < 0.0 | d > 1.0) {
            throw new IllegalArgumentException("p not in [0,1]");
        }
        if (n < 0) {
            throw new IllegalArgumentException("n < 0");
        }
        if (n == 0) {
            return 1.0;
        }
        if (n2 < 0) {
            return 0.0;
        }
        if (n2 >= n) {
            return 1.0;
        }
        if (d <= 0.0) {
            return 1.0;
        }
        if (d >= 1.0) {
            return 0.0;
        }
        if (n < 10000) {
            int n3;
            double d4;
            int n4 = (int)((double)(n + 1) * d);
            if (n4 > n2) {
                n4 = n2;
            }
            double d5 = d4 = BinomialDist.prob(n, d, 1.0 - d, n4);
            double d6 = d4;
            double d7 = d3 / d;
            for (n3 = n4; n3 > 0 && !((d5 *= d7 * (double)n3 / (double)(n - n3 + 1)) < d2); --n3) {
                d6 += d5;
            }
            d7 = d / d3;
            d5 = d4;
            for (n3 = n4; n3 < n2 && !((d5 *= d7 * (double)(n - n3) / (double)(n3 + 1)) < d2); ++n3) {
                d6 += d5;
            }
            return d6;
        }
        if (d > 0.5 || d == 0.5 && n2 > n / 2) {
            d = d3;
            d3 = 1.0 - d;
            bl = true;
            n2 = n - n2 - 1;
        }
        if ((double)n * d * d3 > 100.0) {
            double d8 = Math.pow((double)(n2 + 1) * d3 / ((double)(n - n2) * d), 0.3333333333333333);
            double d9 = d8 * (9.0 - 1.0 / (double)(n2 + 1)) - 9.0 + 1.0 / (double)(n - n2);
            double d10 = 3.0 * Math.sqrt(d8 * d8 / (double)(n2 + 1) + 1.0 / (double)(n - n2));
            d9 /= d10;
            if (bl) {
                return NormalDist.barF01(d9);
            }
            return NormalDist.cdf01(d9);
        }
        double d11 = (double)(2 * n - n2) * d / (2.0 - d);
        double d12 = (2.0 * d11 * d11 - (double)n2 * d11 - (double)(n2 * n2) - (double)(2 * n2)) / (double)(6 * (2 * n - n2) * (2 * n - n2));
        d12 = d11 / (1.0 - d12);
        if (bl) {
            return 1.0 - PoissonDist.cdf(d12, n2);
        }
        return PoissonDist.cdf(d12, n2);
    }

    public static int inverseF(int n, double d, double d2) {
        double d3;
        int n2;
        double d4 = 1.0 - d;
        if (d2 < 0.0 || d2 >= 1.0) {
            throw new IllegalArgumentException("u not in [0,1]");
        }
        if (n < 10000) {
            double d5;
            int n3;
            int n4 = n3 = (int)((double)(n + 1) * d);
            double d6 = d5 = BinomialDist.prob(n, d, n4);
            double d7 = d5;
            double d8 = d4 / d;
            for (n4 = n3; n4 > 0 && !((d6 *= d8 * (double)n4 / (double)(n - n4 + 1)) < EPSILON); --n4) {
                d7 += d6;
            }
            if (d7 >= d2) {
                for (n4 = n3; d7 >= d2 && n4 >= 0; --n4) {
                    d8 = d4 / d;
                    d7 -= d5;
                    d5 *= d8 * (double)n4 / (double)(n - n4 + 1);
                }
                return n4 + 1;
            }
            while (d7 < d2 && n4 <= n) {
                d8 = d / d4;
                d7 += (d5 *= d8 * (double)(n - n4) / (double)(n4 + 1));
                ++n4;
            }
            return n4;
        }
        for (n2 = 0; n2 <= n && !((d3 = BinomialDist.cdf(n, d, n2)) >= d2); ++n2) {
        }
        return n2;
    }

    private void setBinomial(int n, double d) {
        int n2;
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("p not in range (0, 1)");
        }
        double d2 = 1.0 - d;
        double d3 = 0.0;
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        this.n = n;
        this.p = d;
        this.q = d2;
        if ((double)n > MAXN) {
            this.pdf = null;
            this.cdf = null;
            return;
        }
        double[] dArray = new double[1 + n];
        double[] dArray2 = new double[1 + n];
        int n3 = (int)((double)(n + 1) * Math.abs(d) / (Math.abs(d) + Math.abs(d2)));
        if (n3 > n) {
            n3 = n;
        }
        dArray[n3] = BinomialDist.prob(n, d, d2, n3);
        if (d != 0.0 || d != -0.0) {
            d3 = d2 / d;
        }
        for (n2 = n3; n2 > 0 && Math.abs(dArray[n2]) > EPSILON; --n2) {
            dArray[n2 - 1] = dArray[n2] * d3 * (double)n2 / (double)(n - n2 + 1);
        }
        int n4 = n2;
        if (d2 != 0.0 || d2 != -0.0) {
            d3 = d / d2;
        }
        for (n2 = n3; n2 < n && Math.abs(dArray[n2]) > EPSILON; ++n2) {
            dArray[n2 + 1] = dArray[n2] * d3 * (double)(n - n2) / (double)(n2 + 1);
        }
        int n5 = n2;
        dArray2[n4] = dArray[n4];
        n2 = n4;
        while (n2 < n && dArray2[n2] < 0.5) {
            dArray2[++n2] = dArray2[n2 - 1] + dArray[n2];
        }
        this.xmed = n2;
        dArray2[n5] = dArray[n5];
        n2 = n5 - 1;
        do {
            dArray2[n2] = dArray[n2] + dArray2[n2 + 1];
        } while (--n2 > this.xmed);
        this.xmin = n4;
        this.xmax = n5;
        this.pdf = new double[n5 + 1 - n4];
        this.cdf = new double[n5 + 1 - n4];
        System.arraycopy(dArray, n4, this.pdf, 0, n5 + 1 - n4);
        System.arraycopy(dArray2, n4, this.cdf, 0, n5 + 1 - n4);
    }

    public int getN() {
        return this.n;
    }

    public double getP() {
        return this.p;
    }

    public void setParams(int n, double d) {
        this.setBinomial(n, d);
    }
}

