/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;
import java.awt.image.PixelGrabber;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;

public abstract class PSGrBase
extends Graphics {
    public static final boolean DEBUG = false;
    protected static final int PAGEHEIGHT = 842;
    protected static final int PAGEWIDTH = 596;
    protected static final int XOFFSET = 0;
    protected static final int YOFFSET = 0;
    protected static final char[] hd = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    protected static final int charsPerRow = 72;
    protected PrintWriter os;
    protected Color clr = Color.black;
    protected Color backClr = Color.white;
    protected Font font = new Font("Helvetica", 0, 12);
    protected Rectangle clippingRect = new Rectangle(0, 0, 596, 842);

    public PSGrBase() {
        this(new OutputStreamWriter(System.out), true);
    }

    public PSGrBase(Writer writer) {
        this(writer, true);
    }

    public PSGrBase(Writer writer, boolean bl) {
        this.setOutput(writer);
        if (bl) {
            this.emitProlog();
        }
    }

    @Override
    public Graphics create() {
        throw new RuntimeException("create() not implemented");
    }

    public void setOutput(Writer writer) {
        this.os = !(writer instanceof PrintWriter) ? new PrintWriter(writer, true) : (PrintWriter)writer;
    }

    @Override
    public void translate(int n, int n2) {
        this.os.print(n);
        this.os.print(" ");
        this.os.print(n2);
        this.os.print(" T ");
    }

    protected void scale(double d, double d2) {
        this.os.print(d);
        this.os.print(" ");
        this.os.print(d2);
        this.os.println(" sc ");
    }

    protected void lineto(int n, int n2) {
        this.os.print(n);
        this.os.print(" ");
        this.os.print(n2);
        this.os.print(" L ");
    }

    protected void moveto(int n, int n2) {
        this.os.print(n);
        this.os.print(" ");
        this.os.print(n2);
        this.os.print(" M ");
    }

    protected void lineto(double d, double d2) {
        this.os.print(d);
        this.os.print(" ");
        this.os.print(d2);
        this.os.print(" L ");
    }

    protected void moveto(double d, double d2) {
        this.os.print(d);
        this.os.print(" ");
        this.os.print(d2);
        this.os.print(" M ");
    }

    @Override
    public Color getColor() {
        return this.clr;
    }

    public void setBackground(Color color) {
        this.backClr = color;
    }

    @Override
    public void setColor(Color color) {
        if (color != null) {
            this.clr = color;
        }
        this.os.print((double)this.clr.getRed() / 255.0);
        this.os.print(" ");
        this.os.print((double)this.clr.getGreen() / 255.0);
        this.os.print(" ");
        this.os.print((double)this.clr.getBlue() / 255.0);
        this.os.println(" setrgbcolor");
    }

    @Override
    public void setPaintMode() {
    }

    @Override
    public void setXORMode(Color color) {
    }

    @Override
    public Font getFont() {
        return this.font;
    }

    @Override
    public void setFont(Font font) {
        if (font != null) {
            this.font = font;
            String string = this.font.getName();
            int n = this.font.getStyle();
            if (string.startsWith("Times")) {
                switch (n) {
                    case 0: {
                        string = "Times-Roman";
                        break;
                    }
                    case 1: {
                        string = "Times-Bold";
                        break;
                    }
                    case 2: {
                        string = "Times-Italic";
                        break;
                    }
                    case 3: {
                        string = string + "Times-BoldItalic";
                    }
                }
            } else {
                switch (n) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        string = string + "-Bold";
                        break;
                    }
                    case 2: {
                        string = string + "-Oblique";
                        break;
                    }
                    case 3: {
                        string = string + "-BoldOblique";
                    }
                }
            }
            this.os.println("/" + string + " findfont");
            this.os.print(this.font.getSize());
            this.os.println(" scalefont setfont");
        }
    }

    @Override
    public FontMetrics getFontMetrics() {
        return this.getFontMetrics(this.getFont());
    }

    @Override
    public FontMetrics getFontMetrics(Font font) {
        return Toolkit.getDefaultToolkit().getFontMetrics(font);
    }

    @Override
    public Rectangle getClipRect() {
        return this.clippingRect;
    }

    @Override
    public Shape getClip() {
        return this.clippingRect;
    }

    @Override
    public void setClip(Shape shape) {
        Rectangle rectangle = shape.getBounds();
        this.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    @Override
    public Rectangle getClipBounds() {
        return this.clippingRect;
    }

    @Override
    public void setClip(int n, int n2, int n3, int n4) {
        n2 = this.transformY(n2);
        this.clippingRect = new Rectangle(n, n2, n3, n4);
        this.os.println("initclip");
        this.moveto(n, n2);
        this.lineto(n + n3, n2);
        this.lineto(n + n3, n2 - n4);
        this.lineto(n, n2 - n4);
        this.os.println("closepath eoclip newpath");
    }

    @Override
    public void clipRect(int n, int n2, int n3, int n4) {
        this.setClip(n, n2, n3, n4);
    }

    @Override
    public void copyArea(int n, int n2, int n3, int n4, int n5, int n6) {
        throw new RuntimeException("copyArea not supported");
    }

    @Override
    public void drawLine(int n, int n2, int n3, int n4) {
        n2 = this.transformY(n2);
        n4 = this.transformY(n4);
        this.moveto(n, n2);
        this.lineto(n3, n4);
        this.stroke(false);
    }

    public void drawLine(double d, double d2, double d3, double d4) {
        d2 = this.transformY(d2);
        d4 = this.transformY(d4);
        this.moveto(d, d2);
        this.lineto(d3, d4);
        this.stroke(false);
    }

    protected void doRect(int n, int n2, int n3, int n4, boolean bl) {
        n2 = this.transformY(n2);
        this.moveto(n, n2);
        this.lineto(n + n3, n2);
        this.lineto(n + n3, n2 - n4);
        this.lineto(n, n2 - n4);
        this.lineto(n, n2);
        this.stroke(bl);
    }

    @Override
    public void fillRect(int n, int n2, int n3, int n4) {
        this.doRect(n, n2, n3, n4, true);
    }

    @Override
    public void drawRect(int n, int n2, int n3, int n4) {
        this.doRect(n, n2, n3, n4, false);
    }

    @Override
    public void clearRect(int n, int n2, int n3, int n4) {
        this.gsave();
        Color color = this.getColor();
        this.setColor(this.backClr);
        this.doRect(n, n2, n3, n4, true);
        this.setColor(color);
        this.grestore();
    }

    protected void doRoundRect(int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        n2 = this.transformY(n2);
        this.gsave();
        int n7 = n6 / 2;
        this.translate(n, n2);
        if (n6 != n5) {
            if (n6 > n5) {
                double d = (double)n6 / (double)n5;
                this.scale(1.0, d);
                n4 = (int)((double)n4 / d);
                n7 = n5 / 2;
            } else {
                double d = (double)n5 / (double)n6;
                this.scale(d, 1.0);
                n3 = (int)((double)n3 / d);
                n7 = n6 / 2;
            }
        }
        this.os.println("0 setlinewidth");
        this.moveto(n7, 0);
        this.arcTo(n3, 0, n3, -n4, n7);
        this.arcTo(n3, -n4, 0, -n4, n7);
        this.arcTo(0, -n4, 0, 0, n7);
        this.arcTo(0, 0, n3, 0, n7);
        this.stroke(bl);
        this.os.println("1 setlinewidth");
        this.grestore();
    }

    protected void stroke(boolean bl) {
        if (bl) {
            this.gsave();
            this.os.print(" E ");
            this.grestore();
        }
        this.os.println(" S ");
    }

    protected void arcTo(int n, int n2, int n3, int n4, int n5) {
        this.os.print(n);
        this.os.print(" ");
        this.os.print(n2);
        this.os.print(" ");
        this.os.print(n3);
        this.os.print(" ");
        this.os.print(n4);
        this.os.print(" ");
        this.os.print(n5);
        this.os.println(" arcto");
        this.os.println("4 {pop} repeat");
    }

    @Override
    public void drawRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.doRoundRect(n, n2, n3, n4, n5, n6, false);
    }

    @Override
    public void fillRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.doRoundRect(n, n2, n3, n4, n5, n6, true);
    }

    @Override
    public void draw3DRect(int n, int n2, int n3, int n4, boolean bl) {
        Color color = this.getColor();
        Color color2 = color.brighter();
        Color color3 = color.darker();
        this.setColor(bl ? color2 : color3);
        this.drawLine(n, n2, n, n2 + n4);
        this.drawLine(n + 1, n2, n + n3 - 1, n2);
        this.setColor(bl ? color3 : color2);
        this.drawLine(n + 1, n2 + n4, n + n3, n2 + n4);
        this.drawLine(n + n3, n2, n + n3, n2 + n4);
        this.setColor(color);
    }

    @Override
    public void fill3DRect(int n, int n2, int n3, int n4, boolean bl) {
        Color color = this.getColor();
        Color color2 = color.brighter();
        Color color3 = color.darker();
        if (!bl) {
            this.setColor(color3);
        }
        this.fillRect(n + 1, n2 + 1, n3 - 2, n4 - 2);
        this.setColor(bl ? color2 : color3);
        this.drawLine(n, n2, n, n2 + n4 - 1);
        this.drawLine(n + 1, n2, n + n3 - 2, n2);
        this.setColor(bl ? color3 : color2);
        this.drawLine(n + 1, n2 + n4 - 1, n + n3 - 1, n2 + n4 - 1);
        this.drawLine(n + n3 - 1, n2, n + n3 - 1, n2 + n4 - 1);
        this.setColor(color);
    }

    @Override
    public void drawOval(int n, int n2, int n3, int n4) {
        this.doArc(n, n2, n3, n4, 0, 360, false);
    }

    @Override
    public void fillOval(int n, int n2, int n3, int n4) {
        if (n3 == n4) {
            this.doArc(n, n2, n3);
        } else {
            this.doArc(n, n2, n3, n4, 0, 360, true);
        }
    }

    protected void doArc(int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        n2 = this.transformY(n2);
        this.gsave();
        int n7 = n + n3 / 2;
        int n8 = n2 - n4 / 2;
        this.translate(n7, n8);
        float f = (float)n4 / (float)n3;
        this.scale(1.0, f);
        if (bl) {
            this.moveto(0, 0);
        }
        this.os.println("0 sl ");
        float f2 = n5 + n6;
        this.os.print("0 0 ");
        this.os.print((double)n3 / 2.0);
        this.os.print(" ");
        this.os.print(n5);
        this.os.print(" ");
        this.os.print(f2);
        this.os.println(" arc");
        if (bl) {
            this.os.print(" C ");
        }
        this.stroke(bl);
        this.os.print("1 sl ");
        this.grestore();
    }

    protected void doArc(int n, int n2, int n3) {
        n2 = this.transformY(n2);
        this.gsave();
        int n4 = n + n3 / 2;
        int n5 = n2 - n3 / 2;
        this.translate(n4, n5);
        this.os.print(" A ");
        this.os.print((double)n3 / 2.0);
        this.os.println(" AA ");
    }

    @Override
    public void drawArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.doArc(n, n2, n3, n4, n5, n6, false);
    }

    @Override
    public void fillArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.doArc(n, n2, n3, n4, n5, n6, true);
    }

    protected void doPoly(int[] nArray, int[] nArray2, int n, boolean bl, boolean bl2) {
        int n2;
        if (n < 2) {
            return;
        }
        int[] nArray3 = new int[n];
        for (n2 = 0; n2 < n; ++n2) {
            nArray3[n2] = this.transformY(nArray2[n2]);
        }
        this.moveto(nArray[0], nArray3[0]);
        for (n2 = 0; n2 < n; ++n2) {
            this.lineto(nArray[n2], nArray3[n2]);
        }
        this.stroke(bl);
    }

    @Override
    public void drawPolyline(int[] nArray, int[] nArray2, int n) {
        this.doPoly(nArray, nArray2, n, false, false);
    }

    @Override
    public void drawPolygon(int[] nArray, int[] nArray2, int n) {
        this.doPoly(nArray, nArray2, n, false, true);
    }

    @Override
    public void drawPolygon(Polygon polygon) {
        this.doPoly(polygon.xpoints, polygon.ypoints, polygon.npoints, false, true);
    }

    @Override
    public void fillPolygon(int[] nArray, int[] nArray2, int n) {
        this.doPoly(nArray, nArray2, n, true, true);
    }

    @Override
    public void fillPolygon(Polygon polygon) {
        this.doPoly(polygon.xpoints, polygon.ypoints, polygon.npoints, true, true);
    }

    @Override
    public void drawString(String string, int n, int n2) {
        n2 = this.transformY(n2);
        this.moveto(n, n2);
        this.os.print(" (");
        this.os.print(string);
        this.os.println(") center show stroke");
    }

    @Override
    public void drawChars(char[] cArray, int n, int n2, int n3, int n4) {
        this.drawString(new String(cArray, n, n2), n3, n4);
    }

    @Override
    public void drawBytes(byte[] byArray, int n, int n2, int n3, int n4) {
        this.drawString(new String(byArray, n, n2), n3, n4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, ImageObserver imageObserver, Color color) {
        int n9 = image.getWidth(imageObserver);
        int n10 = image.getHeight(imageObserver);
        n2 = this.transformY(n2);
        int[] nArray = new int[n9 * n10];
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, n9, n10, nArray, 0, n9);
        boolean bl = false;
        try {
            bl = pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            if (!bl) {
                this.os.println("%warning: error on image grab");
                System.err.println("warning: error on image grab: " + pixelGrabber.getStatus());
                return false;
            }
        }
        finally {
            if (!bl) {
                this.os.println("%warning: error on image grab");
                System.err.println("warning: error on image grab: " + pixelGrabber.getStatus());
                return false;
            }
        }
        if (n4 < 1 || n3 < 1) {
            n4 = n10;
            n3 = n9;
        }
        int n11 = n6 == 0 ? 0 : n5;
        int n12 = n8 == 0 ? n10 : n6 + n8;
        int n13 = n5 == 0 ? 0 : n5;
        int n14 = n7 == 0 ? n9 : n5 + n7;
        int n15 = n12 - n11;
        int n16 = n14 - n13;
        this.gsave();
        this.os.println("% build a temporary dictionary");
        this.os.println("20 dict begin");
        this.emitColorImageProlog(n16);
        this.os.println("% lower left corner");
        this.translate(n, n2);
        this.os.println("% size of image");
        this.scale(n3, n4);
        this.os.print(n16);
        this.os.print(" ");
        this.os.print(n15);
        this.os.println(" 8");
        this.os.print("[");
        this.os.print(n16);
        this.os.print(" 0 0 -");
        this.os.print(n15);
        this.os.print(" 0 ");
        this.os.print(0);
        this.os.println("]");
        this.os.println("{currentfile pix readhexstring pop}");
        this.os.println("false 3 colorimage");
        this.os.println("");
        int n17 = 0;
        char[] cArray = new char[73];
        int n18 = color == null ? -1 : color.getRGB();
        for (int i = n11; i < n12; ++i) {
            int n19 = 0;
            ++n17;
            for (int j = n13; j < n14; ++j) {
                int n20 = i * n9 + j;
                int n21 = nArray[n20];
                int n22 = n21 & 0xFF000000;
                if (n22 == 0) {
                    n21 = n18;
                }
                cArray[n19++] = hd[(n21 & 0xF00000) >> 20];
                cArray[n19++] = hd[(n21 & 0xF0000) >> 16];
                cArray[n19++] = hd[(n21 & 0xF000) >> 12];
                cArray[n19++] = hd[(n21 & 0xF00) >> 8];
                cArray[n19++] = hd[(n21 & 0xF0) >> 4];
                cArray[n19++] = hd[n21 & 0xF];
                if (n19 < 72) continue;
                this.os.write(cArray, 0, n19);
                this.os.println();
                if (n17 > 5) {
                    try {
                        Thread.sleep(5L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    n17 = 0;
                }
                n19 = 0;
            }
            if (n19 == 0) continue;
            this.os.write(cArray, 0, n19);
            this.os.println();
        }
        this.os.println();
        this.os.println("end");
        this.grestore();
        return true;
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, ImageObserver imageObserver) {
        return this.doImage(image, n, n2, 0, 0, 0, 0, 0, 0, imageObserver, null);
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, ImageObserver imageObserver) {
        return this.doImage(image, n, n2, n3 - n, n4 - n2, n5, n6, n7 - n5, n8 - n6, imageObserver, null);
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color, ImageObserver imageObserver) {
        return this.doImage(image, n, n2, n3 - n, n4 - n2, n5, n6, n7 - n5, n8 - n6, imageObserver, color);
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
        return this.doImage(image, n, n2, n3, n4, 0, 0, 0, 0, imageObserver, null);
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, Color color, ImageObserver imageObserver) {
        return this.doImage(image, n, n2, 0, 0, 0, 0, 0, 0, imageObserver, color);
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, int n3, int n4, Color color, ImageObserver imageObserver) {
        return this.doImage(image, n, n2, n3, n4, 0, 0, 0, 0, imageObserver, color);
    }

    @Override
    public void dispose() {
        this.os.flush();
    }

    @Override
    public void finalize() {
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "[font=" + this.getFont() + ",color=" + this.getColor() + "]";
    }

    protected int transformY(int n) {
        return 842 - n;
    }

    protected double transformY(double d) {
        return 842.0 - d;
    }

    protected void emitProlog() {
        this.os.println("% PSGr is (C) 1996 Ernest Friedman-Hill and Sandia National Labs");
        this.os.println("% Right to unrestricted personal and commerical use is granted");
        this.os.println("% if this acknowledgement is given on product or packing materials");
        this.os.println("/bd {bind def} def");
        this.os.println("/M {moveto} bd");
        this.os.println("/L {lineto} bd");
        this.os.println("/S {stroke} bd");
        this.os.println("/C {closepath} bd");
        this.os.println("/T {translate} bd");
        this.os.println("/sc {scale} bd");
        this.os.println("/gr {grestore} bd");
        this.os.println("/gs {gsave} bd");
        this.os.println("/sl {setlinewidth} bd");
        this.os.println("/E {eofill} bd");
        this.os.println("/A {0 0 moveto 0 sl 0 0} bd");
        this.os.println("/AA {0 360 arc closepath gsave eofill grestore stroke 1 setlinewidth grestore} bd");
        this.os.println("/center {dup stringwidth pop 2 div neg 0 rmoveto} bd");
        this.translate(0, 0);
        this.setFont(this.font);
    }

    protected void emitColorImageProlog(int n) {
        this.os.println("% Color picture stuff, lifted from XV's PS files");
        this.os.println("% define string to hold a scanline's worth of data");
        this.os.print("/pix ");
        this.os.print(n * 3);
        this.os.println(" string def");
        this.os.println("% define space for color conversions");
        this.os.print("/grays ");
        this.os.print(n);
        this.os.println(" string def  % space for gray scale line");
        this.os.println("/npixls 0 def");
        this.os.println("/rgbindx 0 def");
        this.os.println("% define 'colorimage' if it isn't defined");
        this.os.println("%   ('colortogray' and 'mergeprocs' come from xwd2ps");
        this.os.println("%     via xgrab)");
        this.os.println("/colorimage where   % do we know about 'colorimage'?");
        this.os.println("{ pop }           % yes: pop off the 'dict' returned");
        this.os.println("{                 % no:  define one");
        this.os.println("/colortogray {  % define an RGB->I function");
        this.os.println("/rgbdata exch store    % call input 'rgbdata'");
        this.os.println("rgbdata length 3 idiv");
        this.os.println("/npixls exch store");
        this.os.println("/rgbindx 0 store");
        this.os.println("0 1 npixls 1 sub {");
        this.os.println("grays exch");
        this.os.println("rgbdata rgbindx       get 20 mul    % Red");
        this.os.println("rgbdata rgbindx 1 add get 32 mul    % Green");
        this.os.println("rgbdata rgbindx 2 add get 12 mul    % Blue");
        this.os.println("add add 64 idiv      % I = .5G + .31R + .18B");
        this.os.println("put");
        this.os.println("/rgbindx rgbindx 3 add store");
        this.os.println("} for");
        this.os.println("grays 0 npixls getinterval");
        this.os.println("} bind def");
        this.os.println("");
        this.os.println("% Utility procedure for colorimage operator.");
        this.os.println("% This procedure takes two procedures off the");
        this.os.println("% stack and merges them into a single procedure.");
        this.os.println("");
        this.os.println("/mergeprocs { % def");
        this.os.println("dup length");
        this.os.println("3 -1 roll");
        this.os.println("dup");
        this.os.println("length");
        this.os.println("dup");
        this.os.println("5 1 roll");
        this.os.println("3 -1 roll");
        this.os.println("add");
        this.os.println("array cvx");
        this.os.println("dup");
        this.os.println("3 -1 roll");
        this.os.println("0 exch");
        this.os.println("putinterval");
        this.os.println("dup");
        this.os.println("4 2 roll");
        this.os.println("putinterval");
        this.os.println("} bind def");
        this.os.println("");
        this.os.println("/colorimage { % def");
        this.os.println("pop pop     % remove 'false 3' operands");
        this.os.println("{colortogray} mergeprocs");
        this.os.println("image");
        this.os.println("} bind def");
        this.os.println("} ifelse          % end of 'false' case");
    }

    public void gsave() {
        this.os.print(" gs ");
    }

    public void grestore() {
        this.os.print(" gr ");
    }

    public void emitThis(String string) {
        this.os.println(string);
    }

    protected void diagnostic(String string) {
        this.os.print("% PSGR-");
        this.os.print(this.hashCode());
        this.os.print(": ");
        this.os.println(string);
    }
}

