/*
 * Decompiled with CFR 0.152.
 */
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.Line2D;
import java.io.PrintWriter;
import javax.swing.JPanel;

public class MapPanel
extends JPanel {
    private BayesX b;
    public static final double MAXDOUBLE = Double.MAX_VALUE;
    public static final double WHITE_X = 95.047;
    public static final double WHITE_Y = 100.0;
    public static final double WHITE_Z = 108.883;
    public static final double WHITE_u = 0.1978398;
    public static final double WHITE_v = 0.4683363;
    public static final double GAMMA = 2.2;
    public static final double DEG2RAD = 0.0174532925199433;
    private double h1 = 130.0;
    private double h2 = 25.0;
    private double c = 100.0;
    private double l1 = 90.0;
    private double l2 = 70.0;
    protected short page;
    private double xstep;
    private double ystep;
    private double xstart;
    private double ystart;
    private int PAGEHEIGHT = 842;
    private int PAGEWIDTH = 596;
    private int xoffset = 120;
    private int yoffset = 120;
    private int width = 356;
    private int height = 210;
    private int scale = 1;
    private int pointsize = 3;
    private int pspointsize = 20;
    private int fontsize = 12;
    private double titlescale = 1.5;
    private double minX;
    private double maxX;
    private double minY;
    private double maxY;
    private PSGr2 PSGr;

    public MapPanel(BayesX bayesX) {
        this.b = bayesX;
    }

    public void setplotparam(int n, int n2, int n3, int n4, int n5, int n6, double d) {
        this.xoffset = n;
        this.yoffset = n2;
        this.width = n3;
        this.height = n4;
        this.pspointsize = n5;
        this.fontsize = n6;
        this.titlescale = d;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setComposite(AlphaComposite.getInstance(2));
        graphics2D.setPaint(Color.white);
        Rectangle rectangle = this.getBounds();
        rectangle.setBounds(0, 0, (int)rectangle.getWidth(), (int)rectangle.getHeight());
        graphics2D.fill(rectangle);
        graphics2D.setColor(Color.black);
        switch (this.b.function) {
            case 1: {
                this.showmap(graphics2D);
                break;
            }
            case 2: {
                this.drawmap(graphics);
                break;
            }
            case 3: {
                this.plotnonp(graphics);
                break;
            }
            case 4: {
                this.plotsample(graphics);
                break;
            }
            case 5: {
                this.plotautocor(graphics);
                break;
            }
            case 6: {
                this.plotsurf(graphics);
            }
        }
    }

    private void showmap(Graphics2D graphics2D) {
        int n;
        double d = this.getWidth();
        double d2 = this.getHeight();
        double[] dArray = new double[4];
        double[] dArray2 = new double[2];
        this.b.getboundaries(dArray);
        this.maxX = dArray[2];
        this.maxY = dArray[3];
        this.minX = dArray[0];
        this.minY = dArray[1];
        this.setSize((int)d, (int)d2);
        d2 = (int)(d * (this.maxY - this.minY) / (this.maxX - this.minX));
        for (n = 0; n < this.b.getnrregions(); ++n) {
            for (int i = 0; i < this.b.getnrpoly(n); ++i) {
                for (int j = 0; j < this.b.getnrlines(n, i); ++j) {
                    this.b.getline(dArray, n, i, j);
                    graphics2D.draw(new Line2D.Double((dArray[0] - this.minX) * 0.9 * d / (this.maxX - this.minX) + 0.05 * d, -(dArray[2] - this.minY) * 0.9 * d2 / (this.maxY - this.minY) + 0.95 * d2, (dArray[1] - this.minX) * 0.9 * d / (this.maxX - this.minX) + 0.05 * d, -(dArray[3] - this.minY) * 0.9 * d2 / (this.maxY - this.minY) + 0.95 * d2));
                }
            }
        }
        if (this.b.drawnames) {
            graphics2D.setFont(new Font("TimesRoman", 1, this.b.fontsize));
            for (n = 0; n < this.b.getnrregions(); ++n) {
                this.b.getcentroid(dArray2, n);
                graphics2D.drawString(this.b.getregionname(n), (int)((dArray2[0] - this.minX) * 0.9 * d / (this.maxX - this.minX) + 0.05 * d), (int)(-(dArray2[1] - this.minY) * 0.9 * d2 / (this.maxY - this.minY) + 0.95 * d2));
            }
            graphics2D.setFont(new Font("TimesRoman", 0, this.b.fontsize));
        }
    }

    private void drawmap(Graphics graphics) {
        double d = this.getWidth();
        double d2 = this.getHeight();
        double[] dArray = new double[4];
        this.b.getboundaries(dArray);
        this.maxX = dArray[2];
        this.maxY = dArray[3];
        this.minX = dArray[0];
        this.minY = dArray[1];
        int n = 0;
        if (!this.b.title.equals("")) {
            n = n + 10 + (int)(this.b.titlescale * (double)this.b.fontsize);
        }
        this.helpdrawmap(graphics, d2, d, n, true);
    }

    public void SaveMap(PrintWriter printWriter) {
        int n;
        double[] dArray = new double[4];
        double[] dArray2 = new double[2];
        this.b.getboundaries(dArray);
        this.maxX = dArray[2];
        this.maxY = dArray[3];
        this.minX = dArray[0];
        this.minY = dArray[1];
        double d = this.PAGEWIDTH;
        double d2 = d * (this.maxY - this.minY) / (this.maxX - this.minX);
        if (d2 > (double)this.PAGEHEIGHT) {
            d = d * (double)this.PAGEHEIGHT / d2;
            d2 = d2 * (double)this.PAGEHEIGHT / d2;
        }
        printWriter.println("%!PS-Adobe-3.0");
        printWriter.print("%%BoundingBox:");
        printWriter.print((int)Math.round(0.05 * d));
        printWriter.print(" ");
        printWriter.print(this.PAGEHEIGHT - (int)Math.round(0.95 * d2 + 2.0));
        printWriter.print(" ");
        printWriter.print((int)Math.round(0.95 * d));
        printWriter.print(" ");
        printWriter.println(this.PAGEHEIGHT - (int)Math.round(0.05 * d2));
        printWriter.println("0 setlinewidth");
        printWriter.println("%%Pages:1");
        printWriter.println("%%Page:1 1");
        PSGr2 pSGr2 = new PSGr2(printWriter);
        for (n = 0; n < this.b.getnrregions(); ++n) {
            for (int i = 0; i < this.b.getnrpoly(n); ++i) {
                for (int j = 0; j < this.b.getnrlines(n, i); ++j) {
                    this.b.getline(dArray, n, i, j);
                    ((Graphics)pSGr2).drawLine((int)Math.round((dArray[0] - this.minX) * 0.9 * d / (this.maxX - this.minX) + 0.05 * d), (int)Math.round(-(dArray[2] - this.minY) * 0.9 * d2 / (this.maxY - this.minY) + 0.95 * d2), (int)Math.round((dArray[1] - this.minX) * 0.9 * d / (this.maxX - this.minX) + 0.05 * d), (int)Math.round(-(dArray[3] - this.minY) * 0.9 * d2 / (this.maxY - this.minY) + 0.95 * d2));
                }
            }
        }
        if (this.b.drawnames) {
            ((Graphics)pSGr2).setFont(new Font("TimesRoman", 1, this.b.fontsize));
            for (n = 0; n < this.b.getnrregions(); ++n) {
                this.b.getcentroid(dArray2, n);
                ((Graphics)pSGr2).drawString(this.b.getregionname(n), (int)((dArray2[0] - this.minX) * 0.9 * d / (this.maxX - this.minX) + 0.05 * d), (int)(-(dArray2[1] - this.minY) * 0.9 * d2 / (this.maxY - this.minY) + 0.95 * d2));
            }
            ((Graphics)pSGr2).setFont(new Font("TimesRoman", 0, this.b.fontsize));
        }
        printWriter.println("showpage");
        printWriter.println("grestore");
        printWriter.println("gsave");
        printWriter.close();
    }

    public void Savedrawmap(PrintWriter printWriter) {
        double[] dArray = new double[4];
        this.b.getboundaries(dArray);
        this.maxX = dArray[2];
        this.maxY = dArray[3];
        this.minX = dArray[0];
        this.minY = dArray[1];
        double d = this.PAGEWIDTH;
        double d2 = d * (this.maxY - this.minY) / (this.maxX - this.minX);
        int n = 0;
        if (!this.b.title.equals("")) {
            n = n + 10 + (int)(this.b.titlescale * (double)this.b.fontsize);
        }
        int n2 = n;
        if (this.b.legend) {
            n2 = n2 + 30 + 13 * this.b.fontsize / 10;
        }
        if (d2 + (double)n2 > (double)this.PAGEHEIGHT) {
            d = d * (double)(this.PAGEHEIGHT - n2) / (d2 + (double)n2);
            d2 = d2 * (double)(this.PAGEHEIGHT - n2) / (d2 + (double)n2);
        }
        printWriter.println("%!PS-Adobe-3.0");
        printWriter.print("%%BoundingBox:");
        printWriter.print((int)Math.round(0.05 * d));
        printWriter.print(" ");
        printWriter.print(this.PAGEHEIGHT - (int)Math.round(0.95 * d2 + (double)n2 + 2.0));
        printWriter.print(" ");
        printWriter.print((int)Math.round(0.95 * d));
        printWriter.print(" ");
        printWriter.println(this.PAGEHEIGHT - (int)Math.round(0.05 * d2));
        printWriter.println("0 setlinewidth");
        printWriter.println("%%Pages:1");
        printWriter.println("%%Page:1 1");
        PSGr2 pSGr2 = new PSGr2(printWriter);
        this.helpdrawmap(pSGr2, d2, d, n, false);
        printWriter.println("showpage");
        printWriter.println("grestore");
        printWriter.println("gsave");
        printWriter.close();
    }

    private void helpdrawmap(Graphics graphics, double d, double d2, int n, boolean bl) {
        int n2;
        double d3;
        double d4;
        Polygon polygon;
        int n3;
        int n4;
        boolean bl2 = false;
        this.b.nrNA = 0;
        double[] dArray = new double[4];
        double[] dArray2 = new double[4];
        double[] dArray3 = new double[2];
        this.setSize((int)d2, (int)d);
        d = (int)(d2 * (this.maxY - this.minY) / (this.maxX - this.minX));
        for (n4 = 0; n4 < this.b.getnrregions(); ++n4) {
            if (this.b.isin(n4)) continue;
            for (n3 = 0; n3 < this.b.getnrpoly(n4); ++n3) {
                polygon = new Polygon();
                this.b.getline(dArray2, n4, n3, this.b.getnrlines(n4, n3) - 1);
                this.b.getline(dArray, n4, n3, 0);
                if (dArray[0] == dArray2[0] && dArray[2] == dArray2[2] || dArray[0] == dArray2[1] && dArray[2] == dArray2[3]) {
                    polygon.addPoint((int)Math.round((dArray[0] - this.minX) * 0.9 * d2 / (this.maxX - this.minX) + 0.05 * d2), (int)Math.round(-(dArray[2] - this.minY) * 0.9 * d / (this.maxY - this.minY) + 0.95 * d + (double)n));
                    polygon.addPoint((int)Math.round((dArray[1] - this.minX) * 0.9 * d2 / (this.maxX - this.minX) + 0.05 * d2), (int)Math.round(-(dArray[3] - this.minY) * 0.9 * d / (this.maxY - this.minY) + 0.95 * d + (double)n));
                    d4 = dArray[1];
                    d3 = dArray[3];
                } else {
                    polygon.addPoint((int)Math.round((dArray[1] - this.minX) * 0.9 * d2 / (this.maxX - this.minX) + 0.05 * d2), (int)Math.round(-(dArray[3] - this.minY) * 0.9 * d / (this.maxY - this.minY) + 0.95 * d + (double)n));
                    polygon.addPoint((int)Math.round((dArray[0] - this.minX) * 0.9 * d2 / (this.maxX - this.minX) + 0.05 * d2), (int)Math.round(-(dArray[2] - this.minY) * 0.9 * d / (this.maxY - this.minY) + 0.95 * d + (double)n));
                    d4 = dArray[0];
                    d3 = dArray[2];
                }
                for (n2 = 1; n2 < this.b.getnrlines(n4, n3); ++n2) {
                    this.b.getline(dArray, n4, n3, n2);
                    if (dArray[0] == d4 && dArray[2] == d3) {
                        d4 = dArray[1];
                        d3 = dArray[3];
                        polygon.addPoint((int)Math.round((dArray[1] - this.minX) * 0.9 * d2 / (this.maxX - this.minX) + 0.05 * d2), (int)Math.round(-(dArray[3] - this.minY) * 0.9 * d / (this.maxY - this.minY) + 0.95 * d + (double)n));
                        continue;
                    }
                    d4 = dArray[0];
                    d3 = dArray[2];
                    polygon.addPoint((int)Math.round((dArray[0] - this.minX) * 0.9 * d2 / (this.maxX - this.minX) + 0.05 * d2), (int)Math.round(-(dArray[2] - this.minY) * 0.9 * d / (this.maxY - this.minY) + 0.95 * d + (double)n));
                }
                if (this.b.shades > 0) {
                    bl2 = this.ComputeColor(graphics, n4);
                    graphics.fillPolygon(polygon.xpoints, polygon.ypoints, this.b.getnrlines(n4, n3) + 1);
                    graphics.setColor(Color.black);
                }
                graphics.drawPolygon(polygon.xpoints, polygon.ypoints, this.b.getnrlines(n4, n3) + 1);
                if (!bl2) continue;
                this.drawNA(graphics, polygon);
                ++this.b.nrNA;
            }
        }
        for (n4 = 0; n4 < this.b.getnrregions(); ++n4) {
            if (!this.b.isin(n4)) continue;
            for (n3 = 0; n3 < this.b.getnrpoly(n4); ++n3) {
                polygon = new Polygon();
                this.b.getline(dArray2, n4, n3, this.b.getnrlines(n4, n3) - 1);
                this.b.getline(dArray, n4, n3, 0);
                if (dArray[0] == dArray2[0] && dArray[2] == dArray2[2] || dArray[0] == dArray2[1] && dArray[2] == dArray2[3]) {
                    polygon.addPoint((int)Math.round((dArray[0] - this.minX) * 0.9 * d2 / (this.maxX - this.minX) + 0.05 * d2), (int)Math.round(-(dArray[2] - this.minY) * 0.9 * d / (this.maxY - this.minY) + 0.95 * d + (double)n));
                    polygon.addPoint((int)Math.round((dArray[1] - this.minX) * 0.9 * d2 / (this.maxX - this.minX) + 0.05 * d2), (int)Math.round(-(dArray[3] - this.minY) * 0.9 * d / (this.maxY - this.minY) + 0.95 * d + (double)n));
                    d4 = dArray[1];
                    d3 = dArray[3];
                } else {
                    polygon.addPoint((int)Math.round((dArray[1] - this.minX) * 0.9 * d2 / (this.maxX - this.minX) + 0.05 * d2), (int)Math.round(-(dArray[3] - this.minY) * 0.9 * d / (this.maxY - this.minY) + 0.95 * d + (double)n));
                    polygon.addPoint((int)Math.round((dArray[0] - this.minX) * 0.9 * d2 / (this.maxX - this.minX) + 0.05 * d2), (int)Math.round(-(dArray[2] - this.minY) * 0.9 * d / (this.maxY - this.minY) + 0.95 * d + (double)n));
                    d4 = dArray[0];
                    d3 = dArray[2];
                }
                for (n2 = 1; n2 < this.b.getnrlines(n4, n3); ++n2) {
                    this.b.getline(dArray, n4, n3, n2);
                    if (dArray[0] == d4 && dArray[2] == d3) {
                        d4 = dArray[1];
                        d3 = dArray[3];
                        polygon.addPoint((int)Math.round((dArray[1] - this.minX) * 0.9 * d2 / (this.maxX - this.minX) + 0.05 * d2), (int)Math.round(-(dArray[3] - this.minY) * 0.9 * d / (this.maxY - this.minY) + 0.95 * d + (double)n));
                        continue;
                    }
                    d4 = dArray[0];
                    d3 = dArray[2];
                    polygon.addPoint((int)Math.round((dArray[0] - this.minX) * 0.9 * d2 / (this.maxX - this.minX) + 0.05 * d2), (int)Math.round(-(dArray[2] - this.minY) * 0.9 * d / (this.maxY - this.minY) + 0.95 * d + (double)n));
                }
                if (this.b.shades > 0) {
                    bl2 = this.ComputeColor(graphics, n4);
                    graphics.fillPolygon(polygon.xpoints, polygon.ypoints, this.b.getnrlines(n4, n3) + 1);
                    graphics.setColor(Color.black);
                }
                graphics.drawPolygon(polygon.xpoints, polygon.ypoints, this.b.getnrlines(n4, n3) + 1);
                if (!bl2) continue;
                this.drawNA(graphics, polygon);
                ++this.b.nrNA;
            }
        }
        if (this.b.drawnames) {
            graphics.setFont(new Font("TimesRoman", 1, this.b.fontsize));
            for (n4 = 0; n4 < this.b.getnrregions(); ++n4) {
                this.b.getcentroid(dArray3, n4);
                graphics.drawString(this.b.getregionname(n4), (int)((dArray3[0] - this.minX) * 0.9 * d2 / (this.maxX - this.minX) + 0.05 * d2), (int)(-(dArray3[1] - this.minY) * 0.9 * d / (this.maxY - this.minY) + 0.95 * d + (double)n));
            }
            graphics.setFont(new Font("TimesRoman", 0, this.b.fontsize));
        }
        if (this.b.legend) {
            this.drawlegend(graphics, d, d2, bl);
        }
        if (!this.b.title.equals("")) {
            this.drawtitle(graphics, d, d2, bl);
        }
    }

    private boolean ComputeColor(Graphics graphics, int n) {
        int n2;
        double d = this.b.lowerlimit;
        double d2 = this.b.upperlimit;
        double d3 = 0.0;
        double d4 = d + (d2 - d) / 2.0;
        for (n2 = 0; n2 < this.b.getDRows() && this.b.getname(n) != this.b.getDoubleValue(n2, 1); ++n2) {
        }
        if (n2 < this.b.getDRows()) {
            d3 = this.b.getDoubleValue(n2, 0);
            if (this.b.color) {
                if (this.b.hcl) {
                    int[] nArray = new int[3];
                    double d5 = this.b.shades == 1 ? 0.0 : Math.floor((double)(this.b.shades - 1) * (d3 - d) / (d2 - d)) / (double)(this.b.shades - 1) * 2.0 - 1.0;
                    if (d5 > 1.0) {
                        d5 = 1.0;
                    }
                    if (d5 < -1.0) {
                        d5 = -1.0;
                    }
                    if (this.b.swap) {
                        d5 = -d5;
                    }
                    nArray = d5 > 0.0 ? MapPanel.hcl2rgb(this.h1, this.c * Math.abs(d5), this.l1 + (this.l2 - this.l1) * Math.abs(d5)) : MapPanel.hcl2rgb(this.h2, this.c * Math.abs(d5), this.l1 + (this.l2 - this.l1) * Math.abs(d5));
                    graphics.setColor(new Color(nArray[0], nArray[1], nArray[2]));
                } else if (d3 < d4) {
                    int n3 = this.b.shades == 1 ? 255 : (int)((double)this.b.shades * (d3 - d) / (d2 - d)) * 510 / (this.b.shades - 1);
                    if (n3 > 255) {
                        n3 = 255;
                    }
                    if (n3 < 0) {
                        n3 = 0;
                    }
                    if (this.b.swap) {
                        graphics.setColor(new Color(n3, 255, 0));
                    } else {
                        graphics.setColor(new Color(255, n3, 0));
                    }
                } else {
                    int n4 = this.b.shades == 1 ? 255 : (this.b.shades - 1 - (int)((double)this.b.shades * (d3 - d) / (d2 - d))) * 510 / (this.b.shades - 1);
                    if (n4 > 255) {
                        n4 = 255;
                    }
                    if (n4 < 0) {
                        n4 = 0;
                    }
                    if (this.b.swap) {
                        graphics.setColor(new Color(255, n4, 0));
                    } else {
                        graphics.setColor(new Color(n4, 255, 0));
                    }
                }
            } else {
                int n5 = this.b.shades == 1 ? 127 : (int)((double)this.b.shades * (d3 - d) / (d2 - d)) * 255 / (this.b.shades - 1);
                if (n5 > 255) {
                    n5 = 255;
                }
                if (n5 < 0) {
                    n5 = 0;
                }
                if (this.b.swap) {
                    graphics.setColor(new Color(255 - n5, 255 - n5, 255 - n5));
                } else {
                    graphics.setColor(new Color(n5, n5, n5));
                }
            }
            return false;
        }
        graphics.setColor(new Color(255, 255, 255));
        return true;
    }

    private void drawlegend(Graphics graphics, double d, double d2, boolean bl) {
        Polygon polygon;
        int n;
        Object object;
        int n2 = 0;
        if (!this.b.title.equals("")) {
            n2 = n2 + 10 + (int)(this.b.titlescale * (double)this.b.fontsize);
        }
        double d3 = 0.55 * d2;
        double d4 = 0.95 * d + (double)n2 + 10.0;
        int n3 = 20;
        if (this.b.color) {
            if (this.b.hcl) {
                object = new int[3];
                double d5 = d2 * 0.3 / (double)this.b.shades;
                for (n = 0; n < this.b.shades; ++n) {
                    polygon = new Polygon();
                    polygon.addPoint((int)Math.round(d3 + (double)n * d5), (int)Math.round(d4));
                    polygon.addPoint((int)Math.round(d3 + (double)n * d5), (int)Math.round(d4 + (double)n3));
                    polygon.addPoint((int)Math.round(d3 + (double)(n + 1) * d5), (int)Math.round(d4 + (double)n3));
                    polygon.addPoint((int)Math.round(d3 + (double)(n + 1) * d5), (int)Math.round(d4));
                    polygon.addPoint((int)Math.round(d3 + (double)n * d5), (int)Math.round(d4));
                    double d6 = this.b.shades == 1 ? 0.0 : (double)n / (double)(this.b.shades - 1) * 2.0 - 1.0;
                    if (d6 > 1.0) {
                        d6 = 1.0;
                    }
                    if (d6 < -1.0) {
                        d6 = -1.0;
                    }
                    if (this.b.swap) {
                        d6 = -d6;
                    }
                    object = d6 > 0.0 ? (Object)MapPanel.hcl2rgb(this.h1, this.c * Math.abs(d6), this.l1 + (this.l2 - this.l1) * Math.abs(d6)) : MapPanel.hcl2rgb(this.h2, this.c * Math.abs(d6), this.l1 + (this.l2 - this.l1) * Math.abs(d6));
                    graphics.setColor(new Color(object[0], object[1], object[2]));
                    graphics.fillPolygon(polygon.xpoints, polygon.ypoints, 5);
                }
            } else {
                int n4;
                int n5;
                int n6 = (this.b.shades + 1) / 2;
                double d7 = d2 * 0.3 / (double)this.b.shades;
                for (n5 = 0; n5 < n6; ++n5) {
                    polygon = new Polygon();
                    polygon.addPoint((int)Math.round(d3 + (double)n5 * d7), (int)Math.round(d4));
                    polygon.addPoint((int)Math.round(d3 + (double)n5 * d7), (int)Math.round(d4 + (double)n3));
                    polygon.addPoint((int)Math.round(d3 + (double)(n5 + 1) * d7), (int)Math.round(d4 + (double)n3));
                    polygon.addPoint((int)Math.round(d3 + (double)(n5 + 1) * d7), (int)Math.round(d4));
                    polygon.addPoint((int)Math.round(d3 + (double)n5 * d7), (int)Math.round(d4));
                    n4 = this.b.shades == 1 ? 255 : n5 * 510 / (this.b.shades - 1);
                    if (this.b.swap) {
                        graphics.setColor(new Color(n4, 255, 0));
                    } else {
                        graphics.setColor(new Color(255, n4, 0));
                    }
                    graphics.fillPolygon(polygon.xpoints, polygon.ypoints, 5);
                }
                for (n5 = 0; n5 < n6; ++n5) {
                    polygon = new Polygon();
                    polygon.addPoint((int)Math.round(d3 + 0.3 * d2 - (double)n5 * d7), (int)Math.round(d4));
                    polygon.addPoint((int)Math.round(d3 + 0.3 * d2 - (double)n5 * d7), (int)Math.round(d4 + (double)n3));
                    polygon.addPoint((int)Math.round(d3 + 0.3 * d2 - (double)(n5 + 1) * d7), (int)Math.round(d4 + (double)n3));
                    polygon.addPoint((int)Math.round(d3 + 0.3 * d2 - (double)(n5 + 1) * d7), (int)Math.round(d4));
                    polygon.addPoint((int)Math.round(d3 + 0.3 * d2 - (double)n5 * d7), (int)Math.round(d4));
                    n4 = this.b.shades == 1 ? 255 : n5 * 510 / (this.b.shades - 1);
                    if (this.b.swap) {
                        graphics.setColor(new Color(255, n4, 0));
                    } else {
                        graphics.setColor(new Color(n4, 255, 0));
                    }
                    graphics.fillPolygon(polygon.xpoints, polygon.ypoints, 5);
                }
            }
        } else {
            int n7 = this.b.shades;
            double d8 = d2 * 0.3 / (double)n7;
            for (int i = 0; i < n7; ++i) {
                polygon = new Polygon();
                polygon.addPoint((int)Math.round(d3 + (double)i * d8), (int)Math.round(d4));
                polygon.addPoint((int)Math.round(d3 + (double)i * d8), (int)Math.round(d4 + (double)n3));
                polygon.addPoint((int)Math.round(d3 + (double)(i + 1) * d8), (int)Math.round(d4 + (double)n3));
                polygon.addPoint((int)Math.round(d3 + (double)(i + 1) * d8), (int)Math.round(d4));
                polygon.addPoint((int)Math.round(d3 + (double)i * d8), (int)Math.round(d4));
                int n8 = this.b.shades == 1 ? 127 : i * 255 / (this.b.shades - 1);
                if (this.b.swap) {
                    graphics.setColor(new Color(255 - n8, 255 - n8, 255 - n8));
                } else {
                    graphics.setColor(new Color(n8, n8, n8));
                }
                graphics.fillPolygon(polygon.xpoints, polygon.ypoints, 5);
            }
        }
        polygon = new Polygon();
        polygon.addPoint((int)Math.round(d3), (int)Math.round(d4));
        polygon.addPoint((int)Math.round(d3), (int)Math.round(d4 + (double)n3));
        polygon.addPoint((int)Math.round(d3 + 0.3 * d2), (int)Math.round(d4 + (double)n3));
        polygon.addPoint((int)Math.round(d3 + 0.3 * d2), (int)Math.round(d4));
        polygon.addPoint((int)Math.round(d3), (int)Math.round(d4));
        graphics.setColor(Color.black);
        graphics.drawPolygon(polygon.xpoints, polygon.ypoints, 5);
        n = 0;
        double d9 = this.b.upperlimit;
        double d10 = this.b.lowerlimit;
        graphics.setFont(new Font("TimesRoman", 0, this.b.fontsize));
        object = String.valueOf(d10);
        if (bl) {
            n = (int)((double)(((String)object).length() * this.b.fontsize) * 0.25);
        }
        graphics.drawString((String)object, (int)Math.round(d3) - n, (int)Math.round(d4 + (double)n3 + 1.3 * (double)this.b.fontsize));
        graphics.drawLine((int)Math.round(d3), (int)Math.round(d4 + (double)n3), (int)Math.round(d3), (int)Math.round(d4 + (double)n3 + 3.0));
        if (d10 < 0.0 && 0.0 < d9 && this.b.lowerlimit + (this.b.upperlimit - this.b.lowerlimit) / 3.0 < 0.0 && 0.0 < this.b.upperlimit - (this.b.upperlimit - this.b.lowerlimit) / 3.0) {
            object = String.valueOf(0);
            if (bl) {
                n = (int)((double)(((String)object).length() * this.b.fontsize) * 0.25);
            }
            graphics.drawString((String)object, (int)Math.round(d3 - d10 / (d9 - d10) * 0.3 * d2) - n, (int)Math.round(d4 + (double)n3 + 1.3 * (double)this.b.fontsize));
            graphics.drawLine((int)Math.round(d3 - d10 / (d9 - d10) * 0.3 * d2), (int)Math.round(d4 + (double)n3), (int)Math.round(d3 - d10 / (d9 - d10) * 0.3 * d2), (int)Math.round(d4 + (double)n3 + 3.0));
        }
        object = String.valueOf(d9);
        if (bl) {
            n = (int)((double)(((String)object).length() * this.b.fontsize) * 0.25);
        }
        graphics.drawString((String)object, (int)Math.round(d3 + 0.3 * d2) - n, (int)Math.round(d4 + (double)n3 + 1.3 * (double)this.b.fontsize));
        graphics.drawLine((int)Math.round(d3 + 0.3 * d2), (int)Math.round(d4 + (double)n3), (int)Math.round(d3 + 0.3 * d2), (int)Math.round(d4 + (double)n3 + 3.0));
    }

    private void drawNA(Graphics graphics, Polygon polygon) {
        int n;
        int n2;
        int n3;
        int n4 = 5;
        Rectangle rectangle = polygon.getBounds();
        for (n3 = rectangle.y; n3 < rectangle.y + rectangle.height; n3 += n4) {
            n2 = rectangle.x;
            for (n = n3; n2 <= rectangle.x + rectangle.width && n <= rectangle.y + rectangle.height; ++n, ++n2) {
                if (!polygon.contains(n2, n, 1.0, 1.0)) continue;
                graphics.drawLine(n2, n, n2 + 1, n + 1);
            }
        }
        for (n3 = rectangle.x; n3 < rectangle.x + rectangle.width; n3 += n4) {
            n = rectangle.y;
            for (n2 = n3; n2 <= rectangle.x + rectangle.width && n <= rectangle.y + rectangle.height; ++n, ++n2) {
                if (!polygon.contains(n2, n, 1.0, 1.0)) continue;
                graphics.drawLine(n2, n, n2 + 1, n + 1);
            }
        }
    }

    private void drawtitle(Graphics graphics, double d, double d2, boolean bl) {
        int n = 0;
        if (bl) {
            n = (int)((double)this.b.title.length() * this.b.titlescale * (double)this.b.fontsize * 0.5);
        }
        graphics.setFont(new Font("TimesRoman", 1, (int)(this.b.titlescale * (double)this.b.fontsize)));
        graphics.drawString(this.b.title, (int)(d2 / 2.0 - (double)n), (int)(0.05 * d + this.b.titlescale * (double)this.b.fontsize));
        graphics.setFont(new Font("TimesRoman", 0, this.b.fontsize));
    }

    public void plotnonp(Graphics graphics) {
        this.setplotparam((this.PAGEWIDTH - this.b.width) / 2, 120, this.b.width, this.b.height, this.b.pointsize, this.b.fontsize, this.b.titlescale);
        this.plotframe(graphics, 0, true);
        for (int i = 1; i < this.b.getDCols(); ++i) {
            this.plot(graphics, i);
        }
    }

    public void Saveplotnonp(PrintWriter printWriter) {
        PSGr2 pSGr2;
        this.setplotparam((this.PAGEWIDTH - this.b.width) / 2, 120, this.b.width, this.b.height, this.b.pointsize, this.b.fontsize, this.b.titlescale);
        int n = (int)(0.6 * (double)this.fontsize);
        int n2 = (int)(1.5 * (double)this.fontsize);
        printWriter.println("%!PS-Adobe-3.0");
        printWriter.print("%%BoundingBox:");
        if (this.b.ylab.equals("")) {
            printWriter.print(this.xoffset - 6 * n - 6);
        } else {
            printWriter.print(this.xoffset - 6 * n - n2);
        }
        printWriter.print(" ");
        if (this.b.xlab.equals("")) {
            printWriter.print(this.PAGEHEIGHT - this.yoffset - this.height - n2 - 2);
        } else {
            printWriter.print(this.PAGEHEIGHT - this.yoffset - this.height - 2 * n2 - 2);
        }
        printWriter.print(" ");
        printWriter.print(this.xoffset + this.width + 2);
        printWriter.print(" ");
        if (this.b.title.equals("")) {
            printWriter.println(this.PAGEHEIGHT - this.yoffset + 2);
        } else {
            printWriter.println((double)(this.PAGEHEIGHT - this.yoffset) + 1.5 * this.titlescale * (double)n2);
        }
        this.PSGr = pSGr2 = new PSGr2(printWriter);
        this.scale = 10;
        this.pointsize = this.pspointsize;
        printWriter.println("%%Pages:(atend)");
        printWriter.println("%%Page:1 1");
        printWriter.println("0.1 0.1 scale");
        printWriter.print(this.b.linewidth);
        printWriter.println(" setlinewidth");
        this.plotframe(pSGr2, 0, false);
        for (int i = 1; i < this.b.getDCols(); ++i) {
            this.plot(pSGr2, i);
        }
        printWriter.println("showpage");
        printWriter.close();
    }

    private void plotframe(Graphics graphics, int n, boolean bl) {
        String string;
        int n2;
        boolean bl2 = false;
        int n3 = 0;
        int n4 = 5;
        int n5 = 5;
        int n6 = (int)(0.6 * (double)this.fontsize);
        int n7 = (int)(1.5 * (double)this.fontsize);
        if (this.b.function == 3) {
            this.minX = this.b.getMin(0);
            this.maxX = this.b.getMax(0);
            this.minY = this.b.getMin(1);
            this.maxY = this.b.getMax(1);
            for (n2 = 2; n2 < this.b.getDCols(); ++n2) {
                if (!(this.b.getMin(n2) < this.minY)) continue;
                this.minY = this.b.getMin(n2);
            }
            for (n2 = 2; n2 < this.b.getDCols(); ++n2) {
                if (!(this.b.getMax(n2) > this.maxY)) continue;
                this.maxY = this.b.getMax(n2);
            }
            if (this.b.xmax > -1.7976931348623157E308) {
                this.maxX = this.b.xmax;
            }
            if (this.b.xmin < Double.MAX_VALUE) {
                this.minX = this.b.xmin;
            }
            if (this.b.ymax > -1.7976931348623157E308) {
                this.maxY = this.b.ymax;
            }
            if (this.b.ymin < Double.MAX_VALUE) {
                this.minY = this.b.ymin;
            }
            if (this.b.year != 0 && this.b.month != 0) {
                bl2 = true;
            }
        } else if (this.b.function == 4) {
            this.minX = this.b.getMin(0);
            this.maxX = this.b.getMax(0);
            this.minY = this.b.getMin(n);
            this.maxY = this.b.getMax(n);
        } else if (this.b.function == 5) {
            this.minX = this.b.getMin(0);
            this.maxX = this.b.getMax(0);
            this.minY = -0.1;
            this.maxY = 1.0;
        }
        if (this.maxY == this.minY) {
            this.maxY *= 1.1;
            this.minY *= 0.9;
        }
        this.xstart = this.minX;
        this.ystart = this.minY;
        if (this.b.function == 3) {
            if (this.b.xstart != Double.MAX_VALUE) {
                this.xstart = this.b.xstart;
            }
            if (this.b.ystart != Double.MAX_VALUE) {
                this.ystart = this.b.ystart;
            }
        }
        this.xstep = (this.maxX - this.xstart) / (double)(n4 - 1);
        this.ystep = (this.maxY - this.ystart) / (double)(n5 - 1);
        if (this.b.function == 3) {
            if (this.b.xstep > 0.0) {
                this.xstep = this.b.xstep;
                n4 = (int)((this.maxX - this.xstart) / this.xstep) + 1;
            }
            if (this.b.ystep > 0.0) {
                this.ystep = this.b.ystep;
                n5 = (int)((this.maxY - this.ystart) / this.ystep) + 1;
            }
        } else if ((int)(this.maxX % 4.0) == 0) {
            n4 = 5;
            this.xstep = this.maxX / 4.0;
        } else if ((int)(this.maxX % 3.0) == 0) {
            n4 = 4;
            this.xstep = this.maxX / 3.0;
        } else if ((int)(this.maxX % 5.0) == 0) {
            n4 = 6;
            this.xstep = this.maxX / 5.0;
        } else if ((int)(this.maxX % 2.0) == 0) {
            n4 = 3;
            this.xstep = this.maxX / 2.0;
        } else {
            n4 = 5;
            this.xstep = (this.maxX - this.maxX % 4.0) / 4.0;
        }
        graphics.setColor(Color.black);
        graphics.drawRect(this.scale * this.xoffset, this.PAGEHEIGHT - this.scale * (this.PAGEHEIGHT - this.yoffset), this.scale * this.width, this.scale * this.height);
        if (bl) {
            graphics.setFont(new Font("Monospaced", 1, this.scale * this.fontsize));
        } else {
            graphics.setFont(new Font("TimesRoman", 1, this.scale * this.fontsize));
        }
        if (this.b.function == 3) {
            if (bl2) {
                n2 = (int)this.b.getDoubleValue(0, 0);
                int n8 = (int)this.b.getDoubleValue(this.b.getDRows() - 1, 0);
                int n9 = this.b.year;
                int n10 = 12;
                if (this.b.xstep != 0.0) {
                    n10 = (int)this.b.xstep;
                }
                int n11 = n2;
                int n12 = this.b.month;
                if (n8 - n2 < 24) {
                    String[] stringArray = new String[]{};
                    if (this.xstep == 12.0) {
                        stringArray = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
                    } else if (this.xstep == 4.0) {
                        stringArray = new String[]{"Jan", "Apr", "Jul", "Oct"};
                    } else if (this.xstep == 2.0) {
                        stringArray = new String[]{"Jan", "Jul"};
                    }
                    while (n11 <= n8) {
                        if (n8 - n2 < 12 || (n12 - 1) % 2 == 0) {
                            string = String.valueOf(stringArray[n12 - 1]);
                            string = this.formatLabel(string, bl);
                            if (bl) {
                                n3 = (string.length() + 1) * n6 / 2;
                            }
                            graphics.drawString(string, this.translateX(n11) - this.scale * n3, this.PAGEHEIGHT - this.scale * (this.PAGEHEIGHT - (this.yoffset + this.height + 17 * n7 / 20)));
                        }
                        if ((n12 - 1) % n10 == 0) {
                            string = String.valueOf(n9);
                            string = this.formatLabel(string, bl);
                            if (bl) {
                                n3 = (string.length() + 1) * n6 / 2;
                            }
                            graphics.drawString(string, this.translateX(n11) - this.scale * n3, this.PAGEHEIGHT - this.scale * (this.PAGEHEIGHT - (this.yoffset + this.height + 29 * n7 / 20)));
                        }
                        if (n12 % n10 == 0) {
                            ++n9;
                        }
                        if (n12 == n10) {
                            n12 = 0;
                        }
                        graphics.drawLine(this.translateX(n11), this.PAGEHEIGHT - this.scale * (this.PAGEHEIGHT - this.yoffset - this.height), this.translateX(n11), this.PAGEHEIGHT - this.scale * (this.PAGEHEIGHT - this.yoffset - this.height - 5));
                        ++n11;
                        ++n12;
                    }
                } else {
                    int n13 = (n8 - n2) / 6;
                    while (n11 <= n8) {
                        if ((n12 - 1) % n13 == 0) {
                            string = String.valueOf(n9);
                            string = this.formatLabel(string, bl);
                            if (bl) {
                                n3 = (string.length() + 1) * n6 / 2;
                            }
                            graphics.drawString(string, this.translateX(n11) - this.scale * n3, this.PAGEHEIGHT - this.scale * (this.PAGEHEIGHT - (this.yoffset + this.height + n7)));
                        }
                        if ((n12 - 1) % n10 == 0) {
                            graphics.drawLine(this.translateX(n11), this.PAGEHEIGHT - this.scale * (this.PAGEHEIGHT - this.yoffset - this.height), this.translateX(n11), this.PAGEHEIGHT - this.scale * (this.PAGEHEIGHT - this.yoffset - this.height - 5));
                        }
                        if (n11 % n10 == 0) {
                            ++n9;
                        }
                        ++n11;
                        ++n12;
                    }
                }
            } else {
                for (n2 = 0; n2 < n4; ++n2) {
                    double d = (double)Math.round((this.xstart + (double)n2 * this.xstep) * 1.0E10) / 1.0E10;
                    string = String.valueOf(d);
                    string = this.formatLabel(string, bl);
                    double d2 = this.xstart + (double)n2 * this.xstep;
                    if (!(this.xstart <= this.maxX) || !(d2 >= this.minX) || !(d2 <= this.maxX * 1.0000000001)) continue;
                    if (bl) {
                        n3 = (string.length() + 1) * n6 / 2;
                    }
                    graphics.drawString(string, this.translateX(d2) - this.scale * n3, this.PAGEHEIGHT - this.scale * (this.PAGEHEIGHT - (this.yoffset + this.height + n7)));
                    graphics.drawLine(this.translateX(d2), this.PAGEHEIGHT - this.scale * (this.PAGEHEIGHT - this.yoffset - this.height), this.translateX(d2), this.PAGEHEIGHT - this.scale * (this.PAGEHEIGHT - this.yoffset - this.height - 5));
                }
            }
        } else {
            string = String.valueOf(this.minX);
            string = string.substring(0, string.indexOf(46));
            if (bl) {
                n3 = string.length() * n6 / 2;
            }
            graphics.drawString(string, this.translateX(this.minX) - this.scale * n3, this.PAGEHEIGHT - this.scale * (this.PAGEHEIGHT - (this.yoffset + this.height + n7)));
            for (n2 = 1; n2 < n4; ++n2) {
                string = String.valueOf((double)n2 * this.xstep);
                string = string.substring(0, string.indexOf(46));
                if (bl) {
                    n3 = string.length() * n6 / 2;
                }
                graphics.drawString(string, this.translateX((double)n2 * this.xstep) - this.scale * n3, this.PAGEHEIGHT - this.scale * (this.PAGEHEIGHT - (this.yoffset + this.height + n7)));
                graphics.drawLine(this.translateX((double)n2 * this.xstep), this.PAGEHEIGHT - this.scale * (this.PAGEHEIGHT - this.yoffset - this.height), this.translateX((double)n2 * this.xstep), this.PAGEHEIGHT - this.scale * (this.PAGEHEIGHT - this.yoffset - this.height - 5));
            }
            graphics.drawLine(this.translateX(this.minX), this.PAGEHEIGHT - this.scale * (this.PAGEHEIGHT - this.yoffset - this.height), this.translateX(this.minX), this.PAGEHEIGHT - this.scale * (this.PAGEHEIGHT - this.yoffset - this.height - 5));
        }
        if (this.b.function == 5) {
            for (n2 = 0; n2 < 6; ++n2) {
                graphics.drawLine(this.scale * this.xoffset, this.translateY((double)n2 * 0.2), this.scale * (this.xoffset - 5), this.translateY((double)n2 * 0.2));
            }
        } else {
            for (n2 = 0; n2 < n5; ++n2) {
                double d = this.ystart + (double)n2 * this.ystep;
                if (!(this.ystart <= this.maxY) || !(d >= this.minY) || !(d <= this.maxY * 1.0000000001)) continue;
                graphics.drawLine(this.scale * this.xoffset, this.translateY(d), this.scale * (this.xoffset - 5), this.translateY(d));
            }
        }
        if (this.b.function == 5) {
            for (n2 = 0; n2 < 6; ++n2) {
                string = String.valueOf((double)n2 * 0.2);
                string = string.substring(0, 3);
                if (bl) {
                    n3 = (string.length() + 1) * n6 + 5 - 3 * n6;
                }
                graphics.drawString(string, this.scale * (this.xoffset - n3 - 3 * n6), this.translateY((double)n2 * 0.2) + this.scale * this.fontsize / 3);
            }
        } else {
            for (n2 = 0; n2 < n5; ++n2) {
                double d = (double)Math.round((this.ystart + (double)n2 * this.ystep) * 1.0E10) / 1.0E10;
                string = String.valueOf(d);
                string = this.formatLabel(string, bl);
                if (bl) {
                    n3 = (string.length() + 1) * n6 + 5 - 3 * n6;
                }
                double d3 = this.ystart + (double)n2 * this.ystep;
                if (!(this.ystart <= this.maxY) || !(d3 >= this.minY) || !(d3 <= this.maxY * 1.0000000001)) continue;
                graphics.drawString(string, this.scale * (this.xoffset - n3 - 3 * n6), this.translateY(d3) + this.scale * this.fontsize / 3);
            }
        }
        if (this.b.function == 3) {
            if (!this.b.title.equals("")) {
                if (bl) {
                    graphics.setFont(new Font("Monospaced", 1, (int)((double)(this.scale * this.fontsize) * this.titlescale)));
                } else {
                    graphics.setFont(new Font("TimesRoman", 1, (int)((double)(this.scale * this.fontsize) * this.titlescale)));
                }
                string = this.b.title;
                if (string.length() > 32) {
                    string = string.substring(0, 32);
                }
                if (bl) {
                    n3 = (int)((double)string.length() * this.titlescale * (double)n6 / 2.0);
                }
                graphics.drawString(string, this.scale * (this.xoffset + this.width / 2 - n3), this.PAGEHEIGHT - this.scale * (this.PAGEHEIGHT - (this.yoffset - (int)(this.titlescale * (double)n7))));
                if (bl) {
                    graphics.setFont(new Font("Monospaced", 1, this.scale * this.fontsize));
                } else {
                    graphics.setFont(new Font("TimesRoman", 1, this.scale * this.fontsize));
                }
            }
            if (!this.b.xlab.equals("")) {
                string = this.b.xlab;
                if (bl) {
                    n3 = string.length() * n6 / 2;
                }
                graphics.drawString(string, this.scale * (this.xoffset + this.width / 2 - n3), this.PAGEHEIGHT - this.scale * (this.PAGEHEIGHT - (this.yoffset + this.height + 2 * n7)));
            }
            if (!this.b.ylab.equals("")) {
                string = this.b.ylab;
                if (bl) {
                    n3 = string.length() > 14 ? 7 * n6 : string.length() * n6 / 2;
                }
                if (bl) {
                    graphics.drawString(string, this.scale * (this.xoffset - n3), this.PAGEHEIGHT - this.scale * (this.PAGEHEIGHT - (this.yoffset - 3 * n7 / 4)));
                } else {
                    this.PSGr.emitThis("gsave");
                    this.PSGr.translate(this.scale * (this.xoffset - 48), this.scale * (this.PAGEHEIGHT - (this.yoffset + this.height / 2)));
                    this.PSGr.emitThis("90 rotate");
                    this.PSGr.drawString(string, 0, this.PAGEHEIGHT);
                    this.PSGr.emitThis("grestore");
                }
            }
        } else if (this.b.function == 4) {
            string = "iteration";
            if (bl) {
                n3 = string.length() * n6 / 2;
            }
            graphics.drawString(string, this.scale * (this.xoffset + this.width / 2 - n3), this.PAGEHEIGHT - this.scale * (this.PAGEHEIGHT - (this.yoffset + this.height + 2 * n7)));
            string = "par " + n;
            if (bl) {
                n3 = string.length() > 14 ? 5 * n6 : string.length() * n6 / 2;
            }
            graphics.drawString(string, this.scale * (this.xoffset - n3), this.PAGEHEIGHT - this.scale * (this.PAGEHEIGHT - (this.yoffset - n7)));
        } else if (this.b.function == 5) {
            string = "lag";
            if (bl) {
                n3 = string.length() * n6 / 2;
            }
            graphics.drawString(string, this.scale * (this.xoffset + this.width / 2 - n3), this.PAGEHEIGHT - this.scale * (this.PAGEHEIGHT - (this.yoffset + this.height + 2 * n7)));
            string = this.b.getVarname(n);
            if (bl) {
                n3 = string.length() > 10 ? 5 * n6 : string.length() * n6 / 2;
            }
            graphics.drawString(string, this.scale * (this.xoffset - n3), this.PAGEHEIGHT - this.scale * (this.PAGEHEIGHT - (this.yoffset - n7)));
        }
    }

    private int translateX(double d) {
        return (int)Math.round((double)this.scale * (0.05 * (double)this.width + (d - this.minX) * 0.9 * (double)this.width / (this.maxX - this.minX))) + this.scale * this.xoffset;
    }

    private int translateY(double d) {
        return (int)Math.round((double)this.PAGEHEIGHT - (double)this.scale * ((double)(this.PAGEHEIGHT - this.yoffset - this.height) + 0.05 * (double)this.height + (d - this.minY) * 0.9 * (double)this.height / (this.maxY - this.minY)));
    }

    private void plotsample(Graphics graphics) {
        this.width = 165;
        this.height = 130;
        int n = this.page * this.b.plotsperpage + 1;
        this.yoffset = 50 - (this.height + 100);
        for (int i = 0; n < this.b.getDCols() && i < this.b.plotsperpage; ++n, ++i) {
            if (n % 2 != 0) {
                this.xoffset = 100;
                this.yoffset += this.height + 100;
            } else {
                this.xoffset = 100 + this.width + 66;
            }
            this.plotframe(graphics, n, true);
            this.plot(graphics, n);
        }
    }

    public void Saveplotsample(PrintWriter printWriter) {
        this.width = 165;
        this.height = 130;
        this.xoffset = 100;
        printWriter.println("%!PS-Adobe-3.0");
        printWriter.print("%%BoundingBox:");
        printWriter.print(this.xoffset - 44 - 6);
        printWriter.print(" ");
        printWriter.print(this.PAGEHEIGHT - 100 - 200 - 390 - 42);
        printWriter.print(" ");
        printWriter.print(this.xoffset + 2 * this.width + 66 + 5);
        printWriter.print(" ");
        printWriter.println(this.PAGEHEIGHT - 100 + 30);
        printWriter.println("%%Pages:(atend)");
        PSGr2 pSGr2 = new PSGr2(printWriter);
        this.scale = 10;
        this.pointsize = this.pspointsize;
        int n = 1;
        int n2 = this.b.getDCols();
        int n3 = (this.b.getDCols() - 2) / this.b.plotsperpage + 1;
        for (int i = 1; i <= n3; ++i) {
            printWriter.println("%%Page:" + i + " " + i);
            printWriter.println("0.1 0.1 scale");
            printWriter.println("3 setlinewidth");
            this.yoffset = 100 - (this.height + 100);
            for (int j = 0; n < n2 && j < 6; ++n, ++j) {
                if (n % 2 != 0) {
                    this.xoffset = 100;
                    this.yoffset += this.height + 100;
                } else {
                    this.xoffset = 100 + this.width + 66;
                }
                this.plotframe(pSGr2, n, false);
                this.plot(pSGr2, n);
            }
            printWriter.println("showpage");
        }
        printWriter.close();
    }

    public void Saveplotautocor(PrintWriter printWriter) {
        this.width = 165;
        this.height = 130;
        this.xoffset = 100;
        printWriter.println("%!PS-Adobe-3.0");
        printWriter.print("%%BoundingBox:");
        printWriter.print(this.xoffset - 29 - 6);
        printWriter.print(" ");
        printWriter.print(this.PAGEHEIGHT - 100 - 200 - 390 - 42);
        printWriter.print(" ");
        printWriter.print(100 + 2 * this.width + 66 + 5);
        printWriter.print(" ");
        printWriter.println(this.PAGEHEIGHT - 100 + 30);
        printWriter.println("%%Pages:(atend)");
        PSGr2 pSGr2 = new PSGr2(printWriter);
        this.scale = 10;
        this.pointsize = this.pspointsize;
        int n = 1;
        int n2 = this.b.getDCols();
        int n3 = (this.b.getDCols() - 2) / this.b.plotsperpage + 1;
        for (int i = 1; i <= n3; ++i) {
            printWriter.println("%%Page:" + i + " " + i);
            printWriter.println("0.1 0.1 scale");
            printWriter.println("3 setlinewidth");
            this.yoffset = 100 - (this.height + 100);
            for (int j = 0; n < n2 && j < this.b.plotsperpage; ++n, ++j) {
                if (this.b.plotsperpage == 6) {
                    if (j % 2 == 0) {
                        this.xoffset = 100;
                        this.yoffset += this.height + 100;
                    } else {
                        this.xoffset = 100 + this.width + 66;
                    }
                } else if (this.b.plotsperpage == 3) {
                    this.width = 396;
                    this.xoffset = 100;
                    this.yoffset += this.height + 100;
                }
                this.plotframe(pSGr2, n, false);
                this.plot(pSGr2, n);
                this.drawLine(pSGr2);
            }
            printWriter.println("showpage");
        }
        printWriter.close();
    }

    private void plotautocor(Graphics graphics) {
        this.width = 165;
        this.height = 130;
        int n = this.page * this.b.plotsperpage + 1;
        this.yoffset = 50 - (this.height + 100);
        for (int i = 0; n < this.b.getDCols() && i < this.b.plotsperpage; ++n, ++i) {
            if (this.b.plotsperpage == 6) {
                if (i % 2 == 0) {
                    this.xoffset = 100;
                    this.yoffset += this.height + 100;
                } else {
                    this.xoffset = 100 + this.width + 66;
                }
            } else if (this.b.plotsperpage == 3) {
                this.width = 396;
                this.xoffset = 100;
                this.yoffset += this.height + 100;
            }
            this.plotframe(graphics, n, true);
            this.plot(graphics, n);
            this.drawLine(graphics);
        }
    }

    private void plotsurf(Graphics graphics) {
        char c;
        this.setplotparam((this.PAGEWIDTH - 500) / 2, 120, 500, 500, this.b.pointsize, this.b.fontsize, this.b.titlescale);
        double[][] dArray = new double[this.b.getDRows()][3];
        for (c = '\u0000'; c < this.b.getDRows(); ++c) {
            dArray[c][0] = this.b.getDoubleValue(c, 0);
            dArray[c][1] = this.b.getDoubleValue(c, 1);
            dArray[c][2] = this.b.getDoubleValue(c, 2);
        }
        c = 'G';
        if (this.b.linecolor.length() > 0) {
            c = this.b.linecolor.charAt(0);
        }
        Plot3D plot3D = new Plot3D(dArray, this.b.gridsize, c, this.b.title, this.b.xlab, this.b.ylab, this.b.zlab, this.b.xstart, this.b.xstep, this.b.ystart, this.b.ystep, this.b.zstart, this.b.zstep, this.b.xrot, this.b.yrot, this.b.zrot);
        plot3D.Plot(graphics);
    }

    public void Saveplotsurf(PrintWriter printWriter) {
        printWriter.println("%!PS-Adobe-3.0");
        printWriter.println("%%Pages:1");
        printWriter.println("%%Page:1 1");
        PSGr2 pSGr2 = new PSGr2(printWriter);
        this.plotsurf(pSGr2);
        printWriter.println("showpage");
        printWriter.close();
    }

    private void plot(Graphics graphics, int n) {
        if (this.b.linecolor != null && this.b.linecolor.length() >= n) {
            if (this.b.linecolor.charAt(n - 1) == 'B') {
                graphics.setColor(Color.black);
            } else if (this.b.linecolor.charAt(n - 1) == 'G') {
                graphics.setColor(Color.gray);
            } else if (this.b.linecolor.charAt(n - 1) == 'r') {
                graphics.setColor(Color.red);
            } else if (this.b.linecolor.charAt(n - 1) == 'g') {
                graphics.setColor(Color.green);
            } else if (this.b.linecolor.charAt(n - 1) == 'b') {
                graphics.setColor(Color.blue);
            } else if (this.b.linecolor.charAt(n - 1) == 'c') {
                graphics.setColor(Color.cyan);
            } else if (this.b.linecolor.charAt(n - 1) == 'm') {
                graphics.setColor(Color.magenta);
            } else if (this.b.linecolor.charAt(n - 1) == 'o') {
                graphics.setColor(Color.orange);
            } else if (this.b.linecolor.charAt(n - 1) == 'y') {
                graphics.setColor(Color.yellow);
            }
        }
        if (this.b.function == 5) {
            if (this.b.connect.equals("points") || this.b.connect.length() >= n && this.b.connect.charAt(n - 1) == 'p') {
                for (int i = 0; i < this.b.getDRows(); ++i) {
                    if (!(this.b.getDoubleValue(i, n) >= -0.16)) continue;
                    graphics.fillOval(this.translateX(this.b.getDoubleValue(i, 0)), this.translateY(this.b.getDoubleValue(i, n)), this.pointsize, this.pointsize);
                }
            } else {
                int[] nArray = new int[this.b.getDRows()];
                int[] nArray2 = new int[this.b.getDRows()];
                for (int i = 0; i < this.b.getDRows(); ++i) {
                    nArray[i] = this.translateX(this.b.getDoubleValue(i, 0));
                    nArray2[i] = this.b.getDoubleValue(i, n) < -0.16 ? this.translateY(-0.16) : this.translateY(this.b.getDoubleValue(i, n));
                }
                graphics.drawPolyline(nArray, nArray2, this.b.getDRows());
            }
        } else if (this.b.connect.length() >= n && this.b.connect.charAt(n - 1) == 'p' || this.b.connect.length() >= n && this.b.connect.charAt(n - 1) == '5') {
            for (int i = 0; i < this.b.getDRows(); ++i) {
                double d;
                double d2 = this.b.getDoubleValue(i, 0);
                if (!(this.minX <= d2 & d2 <= this.maxX & this.minY <= (d = this.b.getDoubleValue(i, n)) & d <= this.maxY)) continue;
                graphics.fillOval(this.translateX(d2), this.translateY(d), this.pointsize, this.pointsize);
            }
        } else if (this.b.connect.length() >= n && this.b.connect.charAt(n - 1) == '-' || this.b.connect.length() >= n && this.b.connect.charAt(n - 1) == '4') {
            this.dashedLine(graphics, 30, 0.5, n);
        } else if (this.b.connect.length() >= n && this.b.connect.charAt(n - 1) == '_' || this.b.connect.length() >= n && this.b.connect.charAt(n - 1) == '3') {
            this.dashedLine(graphics, 25, 0.7, n);
        } else if (this.b.connect.length() >= n && this.b.connect.charAt(n - 1) == 'd' || this.b.connect.length() >= n && this.b.connect.charAt(n - 1) == '2') {
            this.dashedLine(graphics, 12, 0.7, n);
        } else {
            for (int i = 1; i < this.b.getDRows(); ++i) {
                double d;
                double d3;
                double d4 = this.b.getDoubleValue(i - 1, 0);
                double d5 = this.b.getDoubleValue(i - 1, n);
                if (!(this.minX <= d4 & d4 <= this.maxX & this.minX <= (d3 = this.b.getDoubleValue(i, 0)) & d3 <= this.maxX & this.minY <= d5 & d5 <= this.maxY & this.minY <= (d = this.b.getDoubleValue(i, n)) & d <= this.maxY)) continue;
                graphics.drawLine(this.translateX(d4), this.translateY(d5), this.translateX(d3), this.translateY(d));
            }
        }
        graphics.setColor(Color.black);
    }

    private void dashedLine(Graphics graphics, int n, double d, int n2) {
        int n3 = this.b.getDRows();
        double d2 = (this.maxX - this.minX) / (double)n;
        for (int i = 0; i < n; ++i) {
            double d3;
            double d4;
            double d5;
            double d6;
            double d7 = this.minX + (double)i * d2;
            double d8 = this.minX + ((double)i + d) * d2;
            double d9 = this.minX + ((double)i + 1.0) * d2;
            int n4 = -1;
            int n5 = -2;
            double d10 = this.b.getDoubleValue(0, 0);
            double d11 = this.b.getDoubleValue(n3 - 1, 0);
            double d12 = this.b.getDoubleValue(0, n2);
            double d13 = this.b.getDoubleValue(n3 - 1, n2);
            if (d7 < d10) {
                d7 = d10;
            }
            if (d8 > d11) {
                d8 = d11;
            }
            double d14 = this.minX - 1.0;
            double d15 = this.minX - 1.0;
            double d16 = this.maxX + 1.0;
            double d17 = this.maxX + 1.0;
            int n6 = 0;
            double d18 = this.b.getDoubleValue(n6, 0);
            while (n6 + 1 < n3 && d18 < d7) {
                d18 = this.b.getDoubleValue(++n6, 0);
            }
            if (d7 <= d18 && d18 <= d8) {
                d14 = d18;
                d15 = this.b.getDoubleValue(n6, n2);
                n4 = n6;
            }
            while (n6 + 1 < n3 && d18 < d8) {
                d18 = this.b.getDoubleValue(++n6, 0);
            }
            d11 = d18;
            d13 = this.b.getDoubleValue(n6, n2);
            n6 = n3 - 1;
            d18 = this.b.getDoubleValue(n6, 0);
            while (n6 > 0 && d18 > d8) {
                d18 = this.b.getDoubleValue(--n6, 0);
            }
            if (d7 <= d18 && d18 <= d8) {
                d16 = d18;
                d17 = this.b.getDoubleValue(n6, n2);
                n5 = n6;
            }
            while (n6 > 0 && d18 > d7) {
                d18 = this.b.getDoubleValue(--n6, 0);
            }
            d10 = d18;
            d12 = this.b.getDoubleValue(n6, n2);
            if (d14 < this.minX && d16 > this.maxX) {
                d6 = d7;
                d5 = d12 + (d7 - d10) * (d13 - d12) / (d11 - d10);
                d4 = d8;
                d3 = d12 + (d8 - d10) * (d13 - d12) / (d11 - d10);
                if (d6 != d4 && this.minX <= d6 & d6 <= this.maxX & this.minX <= d4 & d4 <= this.maxX & this.minY <= d5 & d5 <= this.maxY & this.minY <= d3 & d3 <= this.maxY) {
                    graphics.drawLine(this.translateX(d6), this.translateY(d5), this.translateX(d4), this.translateY(d3));
                } else if (d6 == d4) {
                    graphics.fillOval(this.translateX(d6), this.translateY(d5), 3, 3);
                }
            } else {
                d6 = d7;
                d5 = d12 + (d7 - d10) * (d15 - d12) / (d14 - d10);
                d4 = d14;
                d3 = d15;
                if (d6 != d4 && this.minX <= d6 & d6 <= this.maxX & this.minX <= d4 & d4 <= this.maxX & this.minY <= d5 & d5 <= this.maxY & this.minY <= d3 & d3 <= this.maxY) {
                    graphics.drawLine(this.translateX(d6), this.translateY(d5), this.translateX(d4), this.translateY(d3));
                } else if (d6 == d4) {
                    graphics.fillOval(this.translateX(d6), this.translateY(d5), 3, 3);
                }
                d6 = d16;
                d5 = d17;
                d4 = d8;
                d3 = d12 + (d8 - d10) * (d13 - d17) / (d11 - d16);
                if (d6 != d4 && this.minX <= d6 & d6 <= this.maxX & this.minX <= d4 & d4 <= this.maxX & this.minY <= d5 & d5 <= this.maxY & this.minY <= d3 & d3 <= this.maxY) {
                    graphics.drawLine(this.translateX(d6), this.translateY(d5), this.translateX(d4), this.translateY(d3));
                } else if (d6 == d4) {
                    graphics.fillOval(this.translateX(d6), this.translateY(d5), 3, 3);
                }
            }
            for (int j = n4; j < n5; ++j) {
                d6 = this.b.getDoubleValue(j, 0);
                d5 = this.b.getDoubleValue(j, n2);
                d4 = this.b.getDoubleValue(j + 1, 0);
                d3 = this.b.getDoubleValue(j + 1, n2);
                if (d6 != d4 && this.minX <= d6 & d6 <= this.maxX & this.minX <= d4 & d4 <= this.maxX & this.minY <= d5 & d5 <= this.maxY & this.minY <= d3 & d3 <= this.maxY) {
                    graphics.drawLine(this.translateX(d6), this.translateY(d5), this.translateX(d4), this.translateY(d3));
                    continue;
                }
                if (d6 != d4) continue;
                graphics.fillOval(this.translateX(d6), this.translateY(d5), 3, 3);
            }
        }
    }

    private void drawLine(Graphics graphics) {
        for (int i = 0; i < 100; ++i) {
            if (i % 3 != 0) continue;
            double d = this.minX + (double)i * (this.maxX - this.minX) / 101.0;
            double d2 = d + (this.maxX - this.minX) / 101.0;
            graphics.drawLine(this.translateX(d), this.translateY(0.1), this.translateX(d2), this.translateY(0.1));
        }
    }

    private String formatLabel(String string, boolean bl) {
        if (string.indexOf(69) > -1) {
            if (string.indexOf(46) > -1) {
                string = string.substring(0, string.indexOf(46) + 2) + string.substring(string.indexOf(69));
            }
        } else if (string.indexOf(101) > -1) {
            if (string.indexOf(46) > -1) {
                string = string.substring(0, string.indexOf(46) + 2) + string.substring(string.indexOf(101));
            }
        } else if (string.indexOf(46) > -1) {
            if (string.charAt(0) != '-') {
                string = ' ' + string;
            }
            if (string.indexOf(46) < 3) {
                int n = 2;
                while (Math.pow(10.0, n - 2) * this.ystep < 0.1) {
                    ++n;
                }
                double d = this.round(Double.parseDouble(string), n);
                string = String.valueOf(d);
            } else if (string.indexOf(46) == 3) {
                int n = 1;
                double d = this.round(Double.parseDouble(string), n);
                string = String.valueOf(d);
            } else {
                double d = this.round(Double.parseDouble(string), 0);
                string = String.valueOf(d);
            }
            if (string.charAt(string.length() - 2) == '.' & string.charAt(string.length() - 1) == '0') {
                string = string.substring(0, string.indexOf(46));
            }
        }
        if (bl && string.charAt(0) != '-') {
            string = ' ' + string;
        }
        return string;
    }

    private double round(double d, int n) {
        double d2 = Math.pow(10.0, n);
        d = (double)Math.round(d * d2) / d2;
        return d;
    }

    static double gtrans(double d) {
        if (d > 0.00304) {
            return 1.055 * Math.pow(d, 0.45454545454545453) - 0.055;
        }
        return 12.92 * d;
    }

    static int[] hcl2rgb(double d, double d2, double d3) {
        double d4;
        double d5;
        double d6;
        d = 0.0174532925199433 * d;
        double d7 = d3;
        double d8 = d2 * Math.cos(d);
        double d9 = d2 * Math.sin(d);
        if (d7 <= 0.0 && d8 == 0.0 && d9 == 0.0) {
            d6 = 0.0;
            d5 = 0.0;
            d4 = 0.0;
        } else {
            d5 = 100.0 * (d7 > 7.999592 ? Math.pow((d7 + 16.0) / 116.0, 3.0) : d7 / 903.3);
            double d10 = d8 / (13.0 * d7) + 0.1978398;
            double d11 = d9 / (13.0 * d7) + 0.4683363;
            d6 = 9.0 * d5 * d10 / (4.0 * d11);
            d4 = -d6 / 3.0 - 5.0 * d5 + 3.0 * d5 / d11;
        }
        double d12 = 255.0 * MapPanel.gtrans((3.240479 * d6 - 1.53715 * d5 - 0.498535 * d4) / 100.0);
        double d13 = 255.0 * MapPanel.gtrans((-0.969256 * d6 + 1.875992 * d5 + 0.041556 * d4) / 100.0);
        double d14 = 255.0 * MapPanel.gtrans((0.055648 * d6 - 0.204043 * d5 + 1.057311 * d4) / 100.0);
        if (d12 > 255.0) {
            d12 = 255.0;
        }
        if (d12 < 0.0) {
            d12 = 0.0;
        }
        if (d13 > 255.0) {
            d13 = 255.0;
        }
        if (d13 < 0.0) {
            d13 = 0.0;
        }
        if (d14 > 255.0) {
            d14 = 255.0;
        }
        if (d14 < 0.0) {
            d14 = 0.0;
        }
        int[] nArray = new int[]{(int)d12, (int)d13, (int)d14};
        return nArray;
    }
}

